class Pieza {
	
	private int fila, columna; 
	
	public Pieza(int x, int y) {
		fila = x;
		columna = y;
	}
	
	public boolean mover(int x, int y) {
		fila = x;
		columna = y;
		return true;
	}
	
	public int obtenerFila() {
		return fila;
	}
	public int obtenerColumna() {
		return columna;
	}
}

class Caballo extends Pieza {

	public Caballo(int x, int y) {
		super(x, y);
	}

	public boolean mover(int x, int y) {
		if ((1 <= x && x <= 8) //fila a la que quiero mover est en el rango vlido
			&& (1 <= y && y <= 8) //columna a la que quiero mover est en el rango vlido
			&& (Math.abs(x - obtenerFila()) == 2 && Math.abs(y - obtenerColumna()) == 1) //muevo 2 horizontal y 1 verticalmente
			|| (Math.abs(x - obtenerFila()) == 1 && Math.abs(y - obtenerColumna()) == 2)) //muevo 2 vertical y 1 horizontalmente
			return super.mover(x, y);
		else
			return false;
	}

}

class Torre extends Pieza {

	public Torre(int x, int y) {
		super(x, y);
	}

	public boolean mover(int x, int y) {
		if ((1 <= x && x <= 8) && (1 <= y && y <= 8) //fila y columna en rango vlido 
		&& ((x == obtenerFila() && y != obtenerColumna()) //quiero mover a la misma fila y otra columna
		|| (x != obtenerFila() && y == obtenerColumna()))) // quiero mover a la misma columna y otra fila
			return super.mover(x, y);
		else
			return false;
	}

	boolean comer(Pieza X, Pieza Y) {
		int i = Y.obtenerFila(), j = Y.obtenerColumna();
		return X.mover(i, j);
	}

}