import java.io.*; import java.awt.*; import java.awt.event.*;
class Agenda extends Frame implements ActionListener{

static public int[] indices(String x,String[]y,int n){
  int m=0;
  for(int i=0; i<n; ++i)
    if( y[i].equals(x) ) ++m;
  int[]aux=new int[m];
  for(int i=0,j=0; i<n; ++i)
    if( y[i].equals(x) ) aux[j++]=i;
  return aux;
}

static public int indice(String x,String[]y,int ip,int iu){
  if( ip>iu ) return -1;
  return x.equals(y[ip]) ? ip: indice(x,y,ip+1,iu);
}

//busqueda binaria
static public int indice2(String x,String[]y,int ip,int iu){
  int n=(int)((iu-ip+1)*Math.random())+ip;
  if(ip>iu) 
    return -1;
  if(y[n].compareTo(x)>0)
    n=indice2(x,y,ip,n-1);
  else if(y[n].compareTo(x)<0)
    n=indice2(x,y,n+1,iu);
  else 
    while(y[n-1].compareTo(x)==0)
      --n; 
  return n;
}

static public void main(String[]args)throws IOException{
  new Agenda().show();
}
protected int N=1000,n=0,i=0, ind=0;
protected String[] nombres=new String[N],fonos=new String[N];
protected Button 
  bnombre = new Button("nombre:"),
  bfono = new Button("fono"),
  sgte = new Button("siguiente"),
  quit = new Button("quit");
protected TextField
  nombre = new TextField(""), fono=new TextField("");
public Agenda()throws IOException{
  setSize(200,200);
  setLayout( new GridLayout(3,2) );
  add(bnombre); add(nombre);
  add(bfono); add(fono);
  add(sgte); add(quit);
  bnombre.addActionListener(this);
  bfono.addActionListener(this);
  sgte.addActionListener(this);
  quit.addActionListener(this);
  BufferedReader a=new BufferedReader(new FileReader("Agenda.txt"));
  for(n=0; n<N; ++n){
    String linea=a.readLine();
    if(linea==null)break;
    nombres[n]=linea.substring(0,20).trim();
    fonos[n]=linea.substring(20);
  }    
}
public void actionPerformed(ActionEvent x){
  if(x.getSource()==quit) System.exit(0);
  if(x.getSource()==bnombre){
     i=indice(nombre.getText().trim(),nombres,0,n-1);
     fono.setText(i<0?"no tiene":fonos[i]);
     ind=1;
  }else if(x.getSource()==bfono){
     i=indice(fono.getText(),fonos,0,n-1);
     nombre.setText(i<0?"no existe":nombres[i]);
     ind=2;
  }else if(x.getSource()==sgte){
     if(ind==1){
       i=indice(nombre.getText().trim(),nombres,i+1,n-1);
       fono.setText(i<0?"no tiene":fonos[i]);
     }else if(ind==2){
       i=indice(fono.getText(),fonos,i+1,n-1);
       nombre.setText(i<0?"no existe":nombres[i]);
     }
  }
}
}


    



  
  
