# Cargar libreras necesarias
library(tidyverse)

# Verificar balance inicial entre grupos
table(base_seleccion_aleatoria_chile$tratamiento)
prop.table(table(base_seleccion_aleatoria_chile$sexo, base_seleccion_aleatoria_chile$tratamiento), margin = 2)
t.test(base_seleccion_aleatoria_chile$edad ~ base_seleccion_aleatoria_chile$tratamiento)
t.test(base_seleccion_aleatoria_chile$ingreso_hogar ~ base_seleccion_aleatoria_chile$tratamiento)

# Estimar efecto promedio del tratamiento (Diferencia de proporciones)
mean(base_seleccion_aleatoria_chile$trabajo_post[base_seleccion_aleatoria_chile$tratamiento == 1]) - mean(base_seleccion_aleatoria_chile$trabajo_post[base_seleccion_aleatoria_chile$tratamiento == 0])

# Modelo de regresin lineal
modelo <- lm(trabajo_post ~ tratamiento, data = base_seleccion_aleatoria_chile)
summary(modelo)

# Visualizacin simple

# Visualizacin simple
base_seleccion_aleatoria_chile %>%
  group_by(tratamiento) %>%
  summarise(tasa_empleo = mean(trabajo_post)) %>%
  ggplot(aes(x = factor(tratamiento, labels = c("Control", "Tratamiento")), y = tasa_empleo)) +
  geom_col(fill = "steelblue") +
  labs(title = "Efecto del Programa en Insercin Laboral",
       x = "Grupo", y = "Proporcin con Empleo Post") +
  theme_minimal()