# PAUTA MINI CONTROL VII #
# PROFESOR: MIGUEL ANGEL ZAPATA PEREZ #

# PREGUNTA 2 #
# Cargar el conjunto de datos mtcars
data("mtcars")

# Calcular las correlaciones
correlaciones <- cor(mtcars[, c("mpg", "wt", "hp", "qsec")])
print(correlaciones)

# Modelo de regresión lineal
modelo <- lm(mpg ~ wt + hp + qsec, data = mtcars)
library(stargazer)
stargazer(modelo, type = "text", ci = TRUE, ci.level = 0.95, single.row = FALSE, report = "vc*stp")

# Predicción para un automóvil con características específicas
nueva_obs <- data.frame(wt = 3.000, hp = 150, qsec = 18)
prediccion <- predict(modelo, newdata = nueva_obs, interval = "confidence", level = 0.95)
print(prediccion)

# Análisis de multicolinealidad
library(car)
vif_valores <- vif(modelo)
print(vif_valores)
