
******** 	EJERCICIOS DE REGRESION CON BASE BEAUTY.DTA  *******

*** REGRESION LINEAL SIMPLE ***

reg wage educ				

/* El resultado nos dice que el la bondad de ajuste es bajo R2 = 4%, lo que quiere señalar que ante una variación en la educación, 
en promedio, el salario varia en un 4%, por lo tanto el modelo no es bueno o la variable no es buena explicando el salario*/

/* El valor del coeficiente 0.377 quiere decir que ante un aumento de 1 unidad en la educacion (lease un año adicional de educacion)
, en promedio, el salario crece en 0.377 unidades monetarias, por lo existe una relación positiva entre ambas variables. Dependiendo
de la unidad de medida del ingreso se podría interpretar si tiene mayor alcance o no el año de educación adicional*/

* Comando que guarda los resultados de la regresion como OLS1

est store OLS1	

* Calculamos el Yestimado de la regresion

predict wage1

* Calculamos los residuos mu de la regresion
				
predict residuo, residuals  

*** REGRESION LINEAL MULTIPLE ***

reg wage educ exper

/* El resultado nos dice que el la bondad de ajuste es bajo R2 = 12%, lo que quiere señalar que ante una variación en las variables explicativas, 
en promedio, el salario varia en un 12%, por lo tanto el modelo no es bueno o se explica de buena manera las variaciones del ingreso con esas variables*/

/* El valor del coeficiente 0.47 quiere decir que ante un aumento de 1 unidad en la educacion (lease un año adicional de educacion)
,en promedio, el salario crece en 0.47 unidades monetarias, es decir, existe una relación positiva entre ambas variables, mientras que ante un año adicional
de experiencia, el ingreso aumenta en promedio, en 0.11 unidades monetarias. Se puede destacar entonces que la unidad adicional de educacion incrementa en mayor 
medida el salario*/

* Comando que guarda los resultados de la regresion como OLS2

est store OLS2

* Vamos a comparar modelos con estas dos formas

esttab OLS1 OLS2 , varwidth(25) t scalars(N r2 F p) title ("Comparacion Modelos") 
esttab OLS1 OLS2 , label b(%10.5f) se(%5,4f) scalars(N r2 F) star(* 0.1 ** 0.05 *** 0.01) title("Comparacion Modelos") 


* Cual es el salario de una persona con 14 años de educacion y experiencia de 10 años

reg wage educ exper
lincom _cons+14*educ+10*expe


* Genere regresion multiple para estimar efecto de educación y una dummy

reg wage educ black female


/*Lo interesante de los resultados de esta regresion es la interpretacion de las dummy. Por ejemplo, una mujer obtiene un salario de 3.09 unidades 
monetarias respecto del hombre. Si el salario es el salario por hora, uno podria decir que la mujer obtiene un salario 3.09 unidades monetarias por hora, en promedio, menor
al hombre.*/ 

* Si hacemos una regresion lineal con una variable nominal sin traspasarla a dummy tendremos problemas en la interpretacion. 
* Hagamos una regresion con variables dicotomicas

* Regresion generando dummy cuando no está creada (notese el mismo resultado para Casado y para married)

reg wage educ exper female
reg wage educ exper i.female





