/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.InputStream;
import java.util.Random;
import sun.audio.AudioData;
import sun.audio.AudioDataStream;
import sun.audio.AudioPlayer;

class MembraneFrame
extends Frame
implements ComponentListener,
ActionListener,
AdjustmentListener,
MouseMotionListener,
MouseListener,
ItemListener {
    Thread engine = null;
    Dimension winSize;
    Image dbimage;
    Random random;
    int maxTerms = 16;
    int maxMaxTerms = 64;
    int sampleCount;
    public static final double epsilon = 1.0E-5;
    public static final double epsilon2 = 0.003;
    Button sineButton;
    Button blankButton;
    Checkbox stoppedCheck;
    Checkbox soundCheck;
    Checkbox freqCheck;
    Checkbox fixedCheck;
    Checkbox colorCheck;
    Choice modeChooser;
    Choice displayChooser;
    Choice display2Chooser;
    Scrollbar dampingBar;
    Scrollbar brightnessBar;
    Scrollbar speedBar;
    Scrollbar forceBar;
    Scrollbar loadBar;
    Scrollbar aspectBar;
    Scrollbar baseFreqBar;
    Rectangle view3d;
    Rectangle view2d;
    Rectangle viewFreq;
    boolean showMode;
    boolean editingFunc;
    boolean dragStop;
    int cell2dWidth;
    int cell2dHeight;
    double aspectRatio = 1.0;
    double[][] magcoef;
    double[][] dampcoef;
    double[][] phasecoef;
    double[][] phasecoefcos;
    double[][] phasecoefadj;
    double modephasecos;
    double[][] omega;
    double[] data;
    static final double pi = Math.PI;
    double step;
    double[][] func;
    double[][] funci;
    int[] xpoints;
    int[] ypoints;
    int selectedCoefX;
    int selectedCoefY;
    int selectedGridX;
    int selectedGridY;
    double selectedGridFunc;
    static final int SEL_NONE = 0;
    static final int SEL_FUNC_3D = 1;
    static final int SEL_FUNC_2D = 2;
    static final int SEL_MAG = 3;
    static final int MODE_PLUCK = 0;
    static final int MODE_SHAPE = 1;
    static final int MODE_VIEW_ROTATE = 2;
    static final int MODE_VIEW_ZOOM = 3;
    static final int MODE_SHOW_MODE = 4;
    static final int DISP_3D_2D = 0;
    static final int DISP_3D = 1;
    static final int DISP_2D = 2;
    static final int DISP2_SOLID = 0;
    static final int DISP2_WIRE_XY = 1;
    static final int DISP2_WIRE_X = 2;
    static final int DISP2_WIRE_Y = 3;
    static final int COLOR_HEIGHT = 0;
    static final int COLOR_VEL = 1;
    static final int COLOR_NONE = 2;
    int selection;
    int dragX;
    int dragY;
    int dragStartX;
    int dragStartY;
    boolean dragSet;
    boolean dragClear;
    double viewAngle;
    double viewAngleDragStart;
    double viewZoom = 1.6;
    double viewZoomDragStart;
    double viewAngleCos = 1.0;
    double viewAngleSin = 0.0;
    double viewHeight = -14.0;
    double viewHeightDragStart;
    double viewDistance;
    double magDragStart;
    boolean view2dSwap;
    boolean view2dReflectX;
    boolean view2dReflectY;
    boolean dragging;
    double t;
    int pause;
    double scalex;
    double scaley;
    int centerX3d;
    int centerY3d;
    double topz = 3.0;
    MembraneCanvas cv;
    Membrane applet;
    double logep2 = 0.0;
    static final int[] to_ulaw = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 30, 30, 31, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 49, 51, 53, 55, 57, 59, 61, 63, 66, 70, 74, 78, 84, 92, 104, 254, 231, 219, 211, 205, 201, 197, 193, 190, 188, 186, 184, 182, 180, 178, 176, 175, 174, 173, 172, 171, 170, 169, 168, 167, 166, 165, 164, 163, 162, 161, 160, 159, 159, 158, 158, 157, 157, 156, 156, 155, 155, 154, 154, 153, 153, 152, 152, 151, 151, 150, 150, 149, 149, 148, 148, 147, 147, 146, 146, 145, 145, 144, 144, 143, 143, 143, 143, 142, 142, 142, 142, 141, 141, 141, 141, 140, 140, 140, 140, 139, 139, 139, 139, 138, 138, 138, 138, 137, 137, 137, 137, 136, 136, 136, 136, 135, 135, 135, 135, 134, 134, 134, 134, 133, 133, 133, 133, 132, 132, 132, 132, 131, 131, 131, 131, 130, 130, 130, 130, 129, 129, 129, 129, 128, 128, 128, 128};
    int skew;
    double sndmin;
    double sndmax;

    public String getAppletInfo() {
        return "Membrane by Paul Falstad";
    }

    int getrand(int n) {
        int n2 = this.random.nextInt();
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2 % n;
    }

    MembraneFrame(Membrane membrane) {
        super("Oscillating Membrane Applet");
        this.applet = membrane;
    }

    public void init() {
        this.selectedCoefY = -1;
        this.selectedCoefX = -1;
        this.setLayout(new MembraneLayout());
        this.cv = new MembraneCanvas(this);
        this.cv.addComponentListener(this);
        this.cv.addMouseMotionListener(this);
        this.cv.addMouseListener(this);
        this.add(this.cv);
        this.sineButton = new Button("Fundamental");
        this.add(this.sineButton);
        this.sineButton.addActionListener(this);
        this.blankButton = new Button("Clear");
        this.add(this.blankButton);
        this.blankButton.addActionListener(this);
        this.stoppedCheck = new Checkbox("Stopped");
        this.stoppedCheck.addItemListener(this);
        this.add(this.stoppedCheck);
        this.freqCheck = new Checkbox("Show Frequencies", true);
        this.freqCheck.addItemListener(this);
        this.add(this.freqCheck);
        this.fixedCheck = new Checkbox("Fixed Edges", true);
        this.fixedCheck.addItemListener(this);
        this.add(this.fixedCheck);
        this.colorCheck = new Checkbox("Color", true);
        this.colorCheck.addItemListener(this);
        this.add(this.colorCheck);
        this.soundCheck = new Checkbox("Sound", false);
        this.soundCheck.addItemListener(this);
        this.add(this.soundCheck);
        this.modeChooser = new Choice();
        this.modeChooser.add("Mouse = Poke membrane");
        this.modeChooser.add("Mouse = Shape membrane");
        this.modeChooser.add("Mouse = Adjust view angle");
        this.modeChooser.add("Mouse = Adjust view zoom");
        this.modeChooser.add("Mouse = Show mode");
        this.modeChooser.addItemListener(this);
        this.add(this.modeChooser);
        this.displayChooser = new Choice();
        this.displayChooser.add("Display 3d+2d");
        this.displayChooser.add("Display 3d only");
        this.displayChooser.add("Display 2d only");
        this.displayChooser.addItemListener(this);
        this.add(this.displayChooser);
        this.displayChooser.select(1);
        this.display2Chooser = new Choice();
        this.display2Chooser.add("3d view = Solid");
        this.display2Chooser.add("3d view = Wireframe x,y");
        this.display2Chooser.add("3d view = Wireframe x");
        this.display2Chooser.add("3d view = Wireframe y");
        this.display2Chooser.addItemListener(this);
        this.add(this.display2Chooser);
        this.add(new Label("Simulation Speed", 1));
        this.speedBar = new Scrollbar(0, 20, 1, 1, 200);
        this.add(this.speedBar);
        this.speedBar.addAdjustmentListener(this);
        this.add(new Label("Damping", 1));
        this.dampingBar = new Scrollbar(0, 0, 5, 0, 100);
        this.add(this.dampingBar);
        this.dampingBar.addAdjustmentListener(this);
        this.add(new Label("Brightness", 1));
        this.brightnessBar = new Scrollbar(0, 10, 1, 0, 150);
        this.add(this.brightnessBar);
        this.brightnessBar.addAdjustmentListener(this);
        this.add(new Label("Resolution", 1));
        this.loadBar = new Scrollbar(0, 4, 1, 3, 7);
        this.add(this.loadBar);
        this.loadBar.addAdjustmentListener(this);
        this.add(new Label("Aspect Ratio", 1));
        this.aspectBar = new Scrollbar(0, 10, 1, 5, 31);
        this.add(this.aspectBar);
        this.aspectBar.addAdjustmentListener(this);
        this.add(new Label("Base Frequency", 1));
        this.baseFreqBar = new Scrollbar(0, 44, 1, 10, 100);
        this.add(this.baseFreqBar);
        this.baseFreqBar.addAdjustmentListener(this);
        this.baseFreqBar.disable();
        this.setLoadCount();
        try {
            String string = this.applet.getParameter("PAUSE");
            if (string != null) {
                this.pause = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.magcoef = new double[this.maxMaxTerms][this.maxMaxTerms];
        this.phasecoef = new double[this.maxMaxTerms][this.maxMaxTerms];
        this.phasecoefcos = new double[this.maxMaxTerms][this.maxMaxTerms];
        this.phasecoefadj = new double[this.maxMaxTerms][this.maxMaxTerms];
        this.func = new double[this.maxMaxTerms + 1][this.maxMaxTerms + 1];
        this.funci = new double[this.maxMaxTerms + 1][this.maxMaxTerms + 1];
        this.random = new Random();
        this.setDamping();
        this.reinit();
        this.cv.setBackground(Color.black);
        this.cv.setForeground(Color.lightGray);
        this.resize(500, 500);
        this.handleResize();
        this.show();
    }

    void reinit() {
        this.doSine();
    }

    void handleResize() {
        Dimension dimension = this.winSize = this.cv.getSize();
        if (this.winSize.width == 0) {
            return;
        }
        this.dbimage = this.createImage(dimension.width, dimension.height);
        this.setupDisplay();
    }

    void setupDisplay() {
        this.viewFreq = null;
        this.view2d = null;
        this.view3d = null;
        if (this.winSize == null) {
            return;
        }
        switch (this.displayChooser.getSelectedIndex()) {
            case 1: {
                if (!this.freqCheck.getState()) {
                    this.view3d = new Rectangle(this.winSize);
                    break;
                }
                this.view3d = new Rectangle(0, 0, this.winSize.width, this.winSize.height / 2);
                this.viewFreq = new Rectangle(0, this.winSize.height / 2, this.winSize.width, this.winSize.height / 2);
                break;
            }
            case 2: {
                if (!this.freqCheck.getState()) {
                    this.view2d = new Rectangle(this.winSize);
                    break;
                }
                this.view2d = new Rectangle(0, 0, this.winSize.width, this.winSize.height / 2);
                this.viewFreq = new Rectangle(0, this.winSize.height / 2, this.winSize.width, this.winSize.height / 2);
                break;
            }
            default: {
                if (!this.freqCheck.getState()) {
                    this.view3d = new Rectangle(0, 0, this.winSize.width, this.winSize.height / 2);
                    this.view2d = new Rectangle(0, this.winSize.height / 2, this.winSize.width, this.winSize.height / 2);
                    break;
                }
                this.view3d = new Rectangle(0, 0, this.winSize.width / 2, this.winSize.height / 2);
                this.view2d = new Rectangle(this.winSize.width / 2, 0, this.winSize.width / 2, this.winSize.height / 2);
                this.viewFreq = new Rectangle(0, this.winSize.height / 2, this.winSize.width, this.winSize.height / 2);
            }
        }
        if (this.viewFreq != null) {
            this.viewFreq.x = (this.winSize.width - this.viewFreq.height) / 2;
            this.viewFreq.width -= this.viewFreq.x * 2;
        }
        if (this.view2d != null) {
            double d;
            this.cell2dWidth = (this.view2d.width - 2) / (this.sampleCount + 1);
            this.cell2dHeight = (this.view2d.height - 2) / (this.sampleCount + 1);
            double d2 = d = this.view2dSwap ? 1.0 / this.aspectRatio : this.aspectRatio;
            if ((double)this.cell2dWidth > (double)this.cell2dHeight * d) {
                this.cell2dWidth = (int)((double)this.cell2dHeight * d);
            }
            if ((double)this.cell2dHeight > (double)this.cell2dWidth / d) {
                this.cell2dHeight = (int)((double)this.cell2dWidth / d);
            }
            int n = this.cell2dWidth * (this.sampleCount + 1) + 2;
            int n2 = this.cell2dHeight * (this.sampleCount + 1) + 2;
            this.view2d.x += (this.view2d.width - n) / 2;
            this.view2d.y += (this.view2d.height - n2) / 2;
            this.view2d.width = n;
            this.view2d.height = n2;
            this.brightnessBar.enable();
        } else {
            this.brightnessBar.disable();
        }
    }

    void doSine() {
        for (int i = 0; i != this.sampleCount; ++i) {
            for (int j = 0; j != this.sampleCount; ++j) {
                this.magcoef[i][j] = 0.0;
            }
        }
        if (this.fixedCheck.getState()) {
            this.magcoef[1][1] = 1.0;
        } else if (this.omega[0][1] < this.omega[1][0]) {
            this.magcoef[0][1] = 1.0;
        } else {
            this.magcoef[1][0] = 1.0;
        }
    }

    void doBlank() {
        for (int i = 0; i <= this.sampleCount; ++i) {
            for (int j = 0; j <= this.sampleCount; ++j) {
                this.func[i][j] = 0.0;
            }
        }
        this.transform(true);
    }

    void transform(boolean bl) {
        double d;
        int n;
        int n2;
        this.t = 0.0;
        int[] nArray = new int[2];
        nArray[0] = nArray[1] = this.maxTerms * 2;
        int n3 = this.maxTerms * 4;
        int n4 = this.maxTerms * 2;
        double d2 = this.fixedCheck.getState() ? -1.0 : 1.0;
        for (n2 = 0; n2 != this.maxTerms * this.maxTerms * 8; ++n2) {
            this.data[n2] = 0.0;
        }
        for (n2 = 0; n2 <= this.sampleCount; ++n2) {
            for (n = 0; n <= this.sampleCount; ++n) {
                d = bl ? 0.0 : this.funci[n2][n];
                this.data[n2 * 2 + n * n3] = this.func[n2][n];
                this.data[n2 * 2 + n * n3 + 1] = d;
                if (n2 > 0) {
                    this.data[(n4 - n2) * 2 + n * n3] = d2 * this.func[n2][n];
                    this.data[(n4 - n2) * 2 + n * n3 + 1] = d2 * d;
                    if (n > 0) {
                        this.data[(n4 - n2) * 2 + (n4 - n) * n3] = this.func[n2][n];
                        this.data[(n4 - n2) * 2 + (n4 - n) * n3 + 1] = d;
                    }
                }
                if (n <= 0) continue;
                this.data[n2 * 2 + (n4 - n) * n3] = d2 * this.func[n2][n];
                this.data[n2 * 2 + (n4 - n) * n3 + 1] = d2 * d;
            }
        }
        this.ndfft(this.data, nArray, 2, 1);
        d = -4.0 / (double)(n4 * n4);
        for (n2 = 0; n2 != this.maxTerms; ++n2) {
            for (n = 0; n != this.maxTerms; ++n) {
                double d3;
                double d4 = this.data[n2 * 2 + n * n3] * d;
                double d5 = this.data[n2 * 2 + n * n3 + 1] * d;
                if (d4 < 1.0E-5 && d4 > -1.0E-5) {
                    d4 = 0.0;
                }
                if (d5 < 1.0E-5 && d5 > -1.0E-5) {
                    d5 = 0.0;
                }
                if (bl) {
                    d5 = 0.0;
                }
                d2 = 1.0;
                if (d4 < 0.0) {
                    d4 = -d4;
                    d5 = -d5;
                    d2 = -1.0;
                }
                double d6 = Math.sqrt(d4 * d4 + d5 * d5);
                this.magcoef[n2][n] = d6 * d2;
                this.phasecoefadj[n2][n] = d3 = Math.atan2(d5, d4);
                this.phasecoef[n2][n] = d3;
            }
        }
    }

    int getPanelHeight() {
        return this.winSize.height / 3;
    }

    void centerString(Graphics graphics, String string, int n) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, (this.winSize.width - fontMetrics.stringWidth(string)) / 2, n);
    }

    public void paint(Graphics graphics) {
        this.cv.repaint();
    }

    public void updateMembrane(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        Graphics graphics2 = this.dbimage.getGraphics();
        if (this.winSize == null || this.winSize.width == 0) {
            return;
        }
        boolean bl = true;
        if (!this.stoppedCheck.getState()) {
            int n11 = this.speedBar.getValue();
            double d = (double)n11 * 0.00625;
            this.t += (d += (double)(n11 * this.getrand(20)) * 2.7279275E-5);
        }
        Color color = new Color(76, 76, 76);
        Color color2 = new Color(127, 127, 127);
        graphics2.setColor(this.cv.getBackground());
        graphics2.fillRect(0, 0, this.winSize.width, this.winSize.height);
        graphics2.setColor(this.cv.getForeground());
        this.xpoints = new int[3];
        this.xpoints = new int[3];
        if (this.dragStop) {
            this.t = 0.0;
        }
        if (!this.editingFunc) {
            for (n10 = 0; n10 != this.maxTerms; ++n10) {
                for (n9 = 0; n9 != this.maxTerms; ++n9) {
                    if (this.magcoef[n10][n9] < 1.0E-5 && this.magcoef[n10][n9] > -1.0E-5) {
                        this.phasecoefadj[n10][n9] = 0.0;
                        this.phasecoef[n10][n9] = 0.0;
                        this.magcoef[n10][n9] = 0.0;
                        continue;
                    }
                    double[] dArray = this.magcoef[n10];
                    int n12 = n9;
                    dArray[n12] = dArray[n12] * this.dampcoef[n10][n9];
                    bl = false;
                    this.phasecoef[n10][n9] = (this.omega[n10][n9] * this.t + this.phasecoefadj[n10][n9]) % (Math.PI * 2);
                    this.phasecoefcos[n10][n9] = Math.cos(this.phasecoef[n10][n9]);
                }
            }
            this.genFunc(false);
        }
        double d = (double)this.brightnessBar.getValue() / 10.0;
        if (this.dragStop) {
            bl = true;
        }
        if (this.showMode) {
            bl = false;
            this.modephasecos = Math.cos(this.omega[this.selectedCoefX][this.selectedCoefY] * this.t + this.phasecoefadj[this.selectedCoefX][this.selectedCoefY]);
            if (this.magcoef[this.selectedCoefX][this.selectedCoefY] < 0.0) {
                this.modephasecos = -this.modephasecos;
            }
        }
        int n13 = this.sampleCount / 2;
        if (this.view3d != null) {
            boolean bl2;
            int n14;
            this.scaleworld();
            this.xpoints = new int[4];
            this.ypoints = new int[4];
            int n15 = n8 = this.display2Chooser.getSelectedIndex() == 0 ? this.sampleCount - 1 : this.sampleCount;
            if (this.viewAngleCos > 0.0) {
                n7 = n8;
                n6 = -1;
                n5 = -1;
            } else {
                n7 = 0;
                n6 = n8 + 1;
                n5 = 1;
            }
            if (this.viewAngleSin > 0.0) {
                n4 = 0;
                n14 = n8 + 1;
                n3 = 1;
            } else {
                n4 = n8;
                n14 = -1;
                n3 = -1;
            }
            boolean bl3 = bl2 = !(-this.viewAngleSin * (double)n3 > this.viewAngleCos * (double)n5);
            if (this.display2Chooser.getSelectedIndex() == 0) {
                for (n2 = n4; n2 != n14; n2 += n3) {
                    block3: for (n = n7; n != n6; n += n5) {
                        if (!bl2) {
                            n2 = n4;
                        }
                        while (n2 != n14) {
                            this.map3d(n2 - n13, n - n13, this.func[n2][n], this.xpoints, this.ypoints, 0);
                            this.map3d(n2 + 1 - n13, n - n13, this.func[n2 + 1][n], this.xpoints, this.ypoints, 1);
                            this.map3d(n2 - n13, n + 1 - n13, this.func[n2][n + 1], this.xpoints, this.ypoints, 3);
                            this.map3d(n2 + 1 - n13, n + 1 - n13, this.func[n2 + 1][n + 1], this.xpoints, this.ypoints, 2);
                            double d2 = this.func[n2 + 1][n] - this.func[n2][n];
                            double d3 = this.func[n2][n + 1] - this.func[n2][n];
                            double d4 = (d2 + d3 + 1.0) * 0.5780346820809249 / Math.sqrt(d2 * d2 + d3 * d3 + 1.0);
                            graphics2.setColor(this.computeColor(n2, n, d4));
                            graphics2.fillPolygon(this.xpoints, this.ypoints, 4);
                            if (bl2) continue block3;
                            n2 += n3;
                        }
                    }
                    if (bl2) {
                        continue;
                    }
                    break;
                }
            } else {
                boolean bl4 = this.display2Chooser.getSelectedIndex() != 3;
                boolean bl5 = this.display2Chooser.getSelectedIndex() != 2;
                for (n2 = n4; n2 != n14; n2 += n3) {
                    block6: for (n = n7; n != n6; n += n5) {
                        if (!bl2) {
                            n2 = n4;
                        }
                        while (n2 != n14) {
                            graphics2.setColor(this.computeColor(n2, n, 0.0));
                            this.map3d(n2 - n13, n - n13, this.func[n2][n], this.xpoints, this.ypoints, 0);
                            if (n2 < this.sampleCount && bl4) {
                                this.map3d(n2 + 1 - n13, n - n13, this.func[n2 + 1][n], this.xpoints, this.ypoints, 1);
                                graphics2.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[1], this.ypoints[1]);
                            }
                            if (n < this.sampleCount && bl5) {
                                this.map3d(n2 - n13, n + 1 - n13, this.func[n2][n + 1], this.xpoints, this.ypoints, 2);
                                graphics2.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[2], this.ypoints[2]);
                            }
                            if (bl2) continue block6;
                            n2 += n3;
                        }
                    }
                    if (bl2) {
                        continue;
                    }
                    break;
                }
            }
        }
        if (this.view2d != null) {
            n3 = 65536;
            n4 = this.showMode ? 65792 : 256;
            double d5 = 0.0;
            if (this.viewAngle < 0.7853981633974483 || this.viewAngle >= 5.497787143782138) {
                this.view2dReflectX = false;
                this.view2dSwap = false;
                this.view2dReflectY = true;
            } else if (this.viewAngle >= 0.7853981633974483 && this.viewAngle < 2.356194490192345) {
                this.view2dSwap = true;
                this.view2dReflectY = false;
                this.view2dReflectX = false;
            } else if (this.viewAngle >= 2.356194490192345 && this.viewAngle < 3.9269908169872414) {
                this.view2dSwap = false;
                this.view2dReflectX = true;
                this.view2dReflectY = false;
            } else {
                this.view2dSwap = true;
                this.view2dReflectX = true;
                this.view2dReflectY = true;
            }
            graphics2.setColor(Color.white);
            graphics2.drawRect(this.view2d.x, this.view2d.y, this.view2d.width, this.view2d.height);
            for (n = 0; n <= this.maxTerms; ++n) {
                for (n2 = 0; n2 <= this.maxTerms; ++n2) {
                    int n16 = n8 = this.showMode ? (int)(255.0 * d * this.getMode(this.selectedCoefX, this.selectedCoefY, n2, n) * this.modephasecos) : (int)(255.0 * d * this.func[n2][n]);
                    if (n8 < -255) {
                        n8 = -255;
                    }
                    if (n8 > 255) {
                        n8 = 255;
                    }
                    if (n8 < 0) {
                        graphics2.setColor(new Color(-16777216 + n3 * -n8));
                    } else {
                        graphics2.setColor(new Color(-16777216 + n4 * n8));
                    }
                    if (this.view2dSwap) {
                        n7 = n;
                        n6 = n2;
                    } else {
                        n7 = n2;
                        n6 = n;
                    }
                    if (this.view2dReflectX) {
                        n7 = this.maxTerms - n7;
                    }
                    if (this.view2dReflectY) {
                        n6 = this.maxTerms - n6;
                    }
                    graphics2.fillRect(this.cell2dWidth * n7 + this.view2d.x + 1, this.cell2dHeight * n6 + this.view2d.y + 1, this.cell2dWidth, this.cell2dHeight);
                }
            }
        }
        if (this.viewFreq != null) {
            n3 = this.getTermWidth();
            graphics2.setColor(Color.white);
            for (n10 = n4 = this.fixedCheck.getState() ? 1 : 0; n10 <= this.maxTerms; ++n10) {
                n2 = n10 * n3;
                graphics2.drawLine(this.viewFreq.x + n4 * n3, n2 + this.viewFreq.y, this.viewFreq.x + n3 * this.maxTerms, n2 + this.viewFreq.y);
                graphics2.drawLine(this.viewFreq.x + n2, this.viewFreq.y + n4 * n3, this.viewFreq.x + n2, this.viewFreq.y + n3 * this.maxTerms);
            }
            int n17 = 65536;
            n5 = 256;
            for (n10 = n4; n10 != this.maxTerms; ++n10) {
                for (n9 = n4; n9 != this.maxTerms; ++n9) {
                    n2 = this.viewFreq.x + n10 * n3;
                    n = this.viewFreq.y + n9 * n3;
                    n7 = this.logcoef(this.magcoef[n10][n9]);
                    if (n7 < -255) {
                        n7 = -255;
                    }
                    if (n7 > 255) {
                        n7 = 255;
                    }
                    if (n7 < 0) {
                        graphics2.setColor(new Color(-16777216 + n17 * -n7));
                    } else {
                        graphics2.setColor(new Color(-16777216 + n5 * n7));
                    }
                    graphics2.fillRect(n2 + 1, n + 1, n3 - 1, n3 - 1);
                    n6 = (int)(this.phasecoefadj[n10][n9] * (double)n3 * 0.15915494309189535);
                    if (n6 > 0) {
                        graphics2.setColor(Color.blue);
                        graphics2.drawLine(n2 + n6, n + 1, n2 + n6, n + n3);
                    }
                    if (this.selectedCoefX == -1 || this.omega[this.selectedCoefX][this.selectedCoefY] != this.omega[n10][n9]) continue;
                    graphics2.setColor(Color.yellow);
                    graphics2.drawRect(n2, n, n3, n3);
                }
            }
        }
        graphics.drawImage(this.dbimage, 0, 0, this);
        if (!this.stoppedCheck.getState() && !bl) {
            this.cv.repaint(this.pause);
        }
    }

    Color computeColor(int n, int n2, double d) {
        double d2;
        double d3;
        double d4 = this.func[n][n2];
        if (!this.colorCheck.getState() && !this.showMode) {
            d4 = 0.0;
            if (this.display2Chooser.getSelectedIndex() != 0) {
                return Color.white;
            }
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        d = 0.5 + d * 0.5;
        double d5 = d4 < 0.0 ? -d4 : 0.0;
        double d6 = d3 = d4 > 0.0 ? d4 : 0.0;
        if (this.showMode) {
            d2 = this.getMode(this.selectedCoefX, this.selectedCoefY, n, n2) * this.modephasecos;
            if (d2 > 0.0) {
                d5 = d3 = d2;
            } else {
                d5 = -d2;
                d3 = 0.0;
            }
        }
        if (d5 > 1.0) {
            d5 = 1.0;
        }
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d5 < 0.0) {
            d5 = 0.0;
        }
        d2 = (1.0 - (d5 + d3)) * d;
        if (this.showMode) {
            d2 = (1.0 - d5) * d;
        }
        double d7 = 0.6;
        return new Color((int)((d * d5 + d7 * d2) * 255.0), (int)((d * d3 + d7 * d2) * 255.0), (int)(d7 * d2 * 255.0));
    }

    void genFunc(boolean bl) {
        int n;
        int n2;
        int[] nArray = new int[2];
        nArray[0] = nArray[1] = this.maxTerms * 2;
        int n3 = this.maxTerms * 4;
        int n4 = this.maxTerms * 2;
        double d = bl || this.fixedCheck.getState() ? -1.0 : 1.0;
        for (n2 = 0; n2 != this.maxTerms * this.maxTerms * 8; ++n2) {
            this.data[n2] = 0.0;
        }
        for (n2 = 0; n2 != this.sampleCount; ++n2) {
            for (n = 0; n != this.sampleCount; ++n) {
                double d2 = this.phasecoefcos[n2][n];
                double d3 = Math.sin(this.phasecoef[n2][n]);
                double d4 = -0.25 * this.magcoef[n2][n];
                double d5 = 0.0;
                double d6 = d4 * d2 - d5 * d3;
                double d7 = d5 * d2 + d4 * d3;
                this.data[n2 * 2 + n * n3] = d6;
                this.data[n2 * 2 + n * n3 + 1] = d7;
                if (n2 > 0) {
                    this.data[(n4 - n2) * 2 + n * n3] = d * d6;
                    this.data[(n4 - n2) * 2 + n * n3 + 1] = d * d7;
                    if (n > 0) {
                        this.data[(n4 - n2) * 2 + (n4 - n) * n3] = d6;
                        this.data[(n4 - n2) * 2 + (n4 - n) * n3 + 1] = d7;
                    }
                }
                if (n <= 0) continue;
                this.data[n2 * 2 + (n4 - n) * n3] = d * d6;
                this.data[n2 * 2 + (n4 - n) * n3 + 1] = d * d7;
            }
        }
        this.ndfft(this.data, nArray, 2, -1);
        for (n2 = 0; n2 <= this.sampleCount; ++n2) {
            for (n = 0; n <= this.sampleCount; ++n) {
                this.func[n2][n] = this.data[n2 * 2 + n * n3];
                this.funci[n2][n] = this.data[n2 * 2 + n * n3 + 1];
            }
        }
    }

    int logcoef(double d) {
        double d2;
        int n;
        if ((d *= (double)(n = d < 0.0 ? -1 : 1)) < (d2 = 0.003)) {
            return 0;
        }
        if (this.logep2 == 0.0) {
            this.logep2 = -Math.log(2.0 * d2);
        }
        return (int)((double)(255 * n) * (Math.log(d + d2) + this.logep2) / this.logep2);
    }

    void map3d(double d, double d2, double d3, int[] nArray, int[] nArray2, int n) {
        double d4 = (d *= this.aspectRatio) * this.viewAngleCos + d2 * this.viewAngleSin;
        double d5 = (d3 *= -4.0) - this.viewHeight;
        double d6 = d2 * this.viewAngleCos - d * this.viewAngleSin + this.viewDistance;
        nArray[n] = this.centerX3d + (int)(this.scalex * d4 / d6);
        nArray2[n] = this.centerY3d - (int)(this.scaley * d5 / d6);
    }

    void scaleworld() {
        this.scalex = this.viewZoom * (double)(this.view3d.width / 4) * this.viewDistance / (double)(this.maxTerms / 2);
        this.scaley = -this.scalex;
        int n = (int)(this.scaley * this.viewHeight / this.viewDistance);
        this.centerX3d = this.view3d.x + this.view3d.width / 2;
        this.centerY3d = this.view3d.y + this.view3d.height / 2 - n;
    }

    int getTermWidth() {
        int n = this.viewFreq.height / this.maxTerms;
        return n;
    }

    void edit(MouseEvent mouseEvent) {
        if (this.selection == 0) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        switch (this.selection) {
            case 3: {
                this.editMag(n, n2);
                break;
            }
            case 2: {
                this.editFunc2D(n, n2);
                break;
            }
            case 1: {
                this.editFunc3D(n, n2);
            }
        }
    }

    void editMag(int n, int n2) {
        double d;
        if (this.selectedCoefX == -1) {
            return;
        }
        if (this.modeChooser.getSelectedIndex() == 4) {
            this.showMode = true;
            this.cv.repaint(this.pause);
            return;
        }
        double d2 = (double)(this.dragStartY - n2) / 20.0 + this.magDragStart;
        if (d2 < -1.0) {
            d2 = -1.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if ((d = (double)(n - this.dragStartX) / 10.0) < 0.0) {
            d = 0.0;
        }
        if (d > Math.PI * 2) {
            d = Math.PI * 2;
        }
        if (this.magcoef[this.selectedCoefX][this.selectedCoefY] == d2 && this.phasecoefadj[this.selectedCoefX][this.selectedCoefY] == d) {
            return;
        }
        this.magcoef[this.selectedCoefX][this.selectedCoefY] = d2;
        this.phasecoefadj[this.selectedCoefX][this.selectedCoefY] = d;
        this.cv.repaint(this.pause);
    }

    void editMagClick() {
        if (this.selectedCoefX == -1) {
            return;
        }
        if (this.modeChooser.getSelectedIndex() == 4) {
            return;
        }
        this.magcoef[this.selectedCoefX][this.selectedCoefY] = this.magDragStart < 0.5 ? 1.0 : 0.0;
        this.phasecoefadj[this.selectedCoefX][this.selectedCoefY] = 0.0;
        this.cv.repaint(this.pause);
    }

    void editFunc2D(int n, int n2) {
        int n3 = this.selectedGridX;
        int n4 = this.selectedGridY;
        this.findGridPoint2D(n, n2);
        if (this.modeChooser.getSelectedIndex() == 0) {
            this.editFuncPluck(this.selectedGridX, this.selectedGridY, 1.0);
            return;
        }
        int n5 = n3;
        int n6 = n4;
        int n7 = this.selectedGridX;
        int n8 = this.selectedGridY;
        if (n5 == n7 && n6 == n8) {
            this.editFuncPoint(n7, n8, 1.0);
        } else if (this.abs(n8 - n6) > this.abs(n7 - n5)) {
            int n9 = this.sign(n8 - n6);
            for (n2 = n6; n2 != n8 + n9; n2 += n9) {
                n = n5 + (n7 - n5) * (n2 - n6) / (n8 - n6);
                this.editFuncPoint(n, n2, 1.0);
            }
        } else {
            int n10 = this.sign(n7 - n5);
            for (n = n5; n != n7 + n10; n += n10) {
                n2 = n6 + (n8 - n6) * (n - n5) / (n7 - n5);
                this.editFuncPoint(n, n2, 1.0);
            }
        }
        this.transform(false);
    }

    int sign(int n) {
        return n < 0 ? -1 : (n == 0 ? 0 : 1);
    }

    int abs(int n) {
        return n < 0 ? -n : n;
    }

    void editFunc3D(int n, int n2) {
        if (this.modeChooser.getSelectedIndex() == 2) {
            this.viewAngle = (double)(this.dragStartX - n) / 40.0 + this.viewAngleDragStart;
            while (this.viewAngle < 0.0) {
                this.viewAngle += Math.PI * 2;
            }
            while (this.viewAngle >= Math.PI * 2) {
                this.viewAngle -= Math.PI * 2;
            }
            this.viewAngleCos = Math.cos(this.viewAngle);
            this.viewAngleSin = Math.sin(this.viewAngle);
            this.viewHeight = (double)(this.dragStartY - n2) / 10.0 + this.viewHeightDragStart;
            this.setupDisplay();
            this.cv.repaint(this.pause);
            return;
        }
        if (this.modeChooser.getSelectedIndex() == 3) {
            this.viewZoom = (double)(n - this.dragStartX) / 40.0 + this.viewZoomDragStart;
            if (this.viewZoom < 0.1) {
                this.viewZoom = 0.1;
            }
            this.cv.repaint(this.pause);
            return;
        }
        if (this.selectedGridX == -1) {
            return;
        }
        double d = this.selectedGridFunc + (double)(this.dragStartY - n2) / 40.0;
        if (d < -1.0) {
            d = -1.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (this.modeChooser.getSelectedIndex() == 0) {
            this.editFuncPluck(this.selectedGridX, this.selectedGridY, d);
            return;
        }
        this.editFuncPoint(this.selectedGridX, this.selectedGridY, d);
        this.transform(false);
    }

    void editFuncPoint(int n, int n2, double d) {
        if (!this.dragSet && !this.dragClear) {
            this.dragClear = this.func[n][n2] > 0.1;
            this.dragSet = !this.dragClear;
        }
        this.func[n][n2] = this.dragSet ? d : 0.0;
        this.editingFunc = true;
        this.dragStop = true;
        this.cv.repaint(this.pause);
    }

    void editFuncPluck(int n, int n2, double d) {
        int n3;
        int n4;
        double d2 = 0.0;
        for (n4 = 0; n4 != this.maxTerms; ++n4) {
            this.magcoef[0][n4] = 0.0;
            this.magcoef[n4][0] = 0.0;
        }
        if (n == 0) {
            n = 1;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        if (n == this.maxTerms) {
            n = this.maxTerms - 1;
        }
        if (n2 == this.maxTerms) {
            n2 = this.maxTerms - 1;
        }
        for (n4 = 1; n4 != this.maxTerms; ++n4) {
            for (n3 = 1; n3 != this.maxTerms; ++n3) {
                this.magcoef[n4][n3] = Math.sin(this.step * (double)n4 * (double)n) * Math.sin(this.step * (double)n3 * (double)n2) / ((double)(n4 * n4 * this.maxTerms * this.maxTerms) + (double)(n3 * n3 * this.maxTerms * this.maxTerms) * this.aspectRatio * this.aspectRatio);
                this.phasecoefadj[n4][n3] = 0.0;
                this.phasecoefcos[n4][n3] = 1.0;
                this.phasecoef[n4][n3] = 0.0;
                d2 += this.magcoef[n4][n3] * Math.sin(this.step * (double)n4 * (double)n) * Math.sin(this.step * (double)n3 * (double)n2);
            }
        }
        double d3 = d / d2;
        for (n4 = 1; n4 != this.maxTerms; ++n4) {
            n3 = 1;
            while (n3 != this.maxTerms) {
                double[] dArray = this.magcoef[n4];
                int n5 = n3++;
                dArray[n5] = dArray[n5] * d3;
            }
        }
        this.dragStop = true;
        if (!this.fixedCheck.getState()) {
            this.genFunc(true);
            this.transform(true);
        }
        this.cv.repaint(this.pause);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.cv.repaint(this.pause);
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.handleResize();
        this.cv.repaint(this.pause);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.sineButton) {
            this.doSine();
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.blankButton) {
            this.doBlank();
            this.cv.repaint();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.dampingBar || adjustmentEvent.getSource() == this.speedBar) {
            this.setDamping();
        }
        if (adjustmentEvent.getSource() == this.loadBar) {
            this.setLoadCount();
        }
        if (adjustmentEvent.getSource() == this.aspectBar) {
            this.setLoadCount();
        }
        this.cv.repaint(this.pause);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.applet.destroyFrame();
            return true;
        }
        return super.handleEvent(event);
    }

    void setLoadCount() {
        int n;
        int n2;
        int n3 = this.loadBar.getValue();
        this.sampleCount = 1;
        while (n3-- > 0) {
            this.sampleCount *= 2;
        }
        if (this.sampleCount > this.maxMaxTerms) {
            this.sampleCount = this.maxMaxTerms;
        }
        if (this.sampleCount < 8) {
            this.sampleCount = 8;
        }
        this.maxTerms = this.sampleCount;
        this.step = Math.PI / (double)this.sampleCount;
        this.aspectRatio = (double)this.aspectBar.getValue() / 10.0;
        this.viewDistance = 50.0 + (this.aspectRatio > 1.0 ? this.aspectRatio * (double)this.sampleCount / 2.0 : (double)(this.sampleCount / 2));
        this.data = new double[this.maxTerms * this.maxTerms * 2 * 4];
        this.omega = new double[this.maxTerms][this.maxTerms];
        for (n2 = 0; n2 != this.maxTerms; ++n2) {
            for (n = 0; n != this.maxTerms; ++n) {
                this.omega[n2][n] = Math.sqrt((double)(n2 * n2) / (this.aspectRatio * this.aspectRatio) + (double)(n * n));
            }
        }
        double d = 1.0 / this.omega[1][1];
        for (n2 = 0; n2 != this.maxTerms; ++n2) {
            n = 0;
            while (n != this.maxTerms) {
                double[] dArray = this.omega[n2];
                int n4 = n++;
                dArray[n4] = dArray[n4] * d;
            }
        }
        if (this.magcoef != null) {
            for (n2 = 0; n2 != this.maxMaxTerms; ++n2) {
                for (n = this.maxTerms; n != this.maxMaxTerms; ++n) {
                    this.magcoef[n][n2] = 0.0;
                    this.magcoef[n2][n] = 0.0;
                }
            }
        }
        if (this.func != null) {
            for (n2 = 0; n2 <= this.maxTerms; ++n2) {
                this.funci[this.maxTerms][n2] = 0.0;
                this.funci[n2][this.maxTerms] = 0.0;
                this.func[this.maxTerms][n2] = 0.0;
                this.func[n2][this.maxTerms] = 0.0;
            }
        }
        this.setDamping();
        this.setupDisplay();
    }

    double getMode(int n, int n2, int n3, int n4) {
        if (this.fixedCheck.getState()) {
            return Math.sin(this.step * (double)n3 * (double)n) * Math.sin(this.step * (double)n4 * (double)n2);
        }
        return Math.cos(this.step * (double)n3 * (double)n) * Math.cos(this.step * (double)n4 * (double)n2);
    }

    void setDamping() {
        this.dampcoef = new double[this.maxTerms][this.maxTerms];
        double d = (double)this.speedBar.getValue() / 40.0;
        for (int i = 0; i != this.maxTerms; ++i) {
            for (int j = 0; j != this.maxTerms; ++j) {
                if (i == 0 && j == 0) continue;
                double d2 = this.dampingBar.getValue() / 10;
                d2 = Math.exp(d2) - 1.0;
                double d3 = this.omega[i][j] * Math.sqrt(Math.sqrt(1.0 + d2 * d2 / (this.omega[i][j] * this.omega[i][j])) - 1.0);
                this.dampcoef[i][j] = Math.exp(-d3 * d * 0.002);
            }
        }
    }

    void findGridPoint2D(int n, int n2) {
        int n3;
        this.selectedGridX = (n - this.view2d.x) / this.cell2dWidth;
        this.selectedGridY = (n2 - this.view2d.y) / this.cell2dHeight;
        int n4 = n3 = this.fixedCheck.getState() ? 1 : 0;
        if (this.selectedGridX < n3) {
            this.selectedGridX = n3;
        }
        if (this.selectedGridY < n3) {
            this.selectedGridY = n3;
        }
        if (this.selectedGridX > this.sampleCount - n3) {
            this.selectedGridX = this.sampleCount - n3;
        }
        if (this.selectedGridY > this.sampleCount - n3) {
            this.selectedGridY = this.sampleCount - n3;
        }
        if (this.view2dSwap) {
            int n5 = this.selectedGridX;
            this.selectedGridX = this.selectedGridY;
            this.selectedGridY = n5;
        }
        if (this.view2dReflectX) {
            this.selectedGridX = this.maxTerms - this.selectedGridX;
        }
        if (this.view2dReflectY) {
            this.selectedGridY = this.maxTerms - this.selectedGridY;
        }
        this.selectedGridFunc = this.func[this.selectedGridX][this.selectedGridY];
    }

    void findGridPoint3D(int n, int n2) {
        int n3 = this.sampleCount / 2;
        int n4 = 3600;
        this.selectedGridY = -1;
        this.selectedGridX = -1;
        for (int i = 1; i < this.sampleCount; ++i) {
            for (int j = 1; j < this.sampleCount; ++j) {
                this.map3d(j - n3, i - n3, this.func[j][i], this.xpoints, this.ypoints, 0);
                int n5 = this.xpoints[0] - n;
                int n6 = this.ypoints[0] - n2;
                int n7 = n5 * n5 + n6 * n6;
                if (n7 >= n4) continue;
                n4 = n7;
                this.selectedGridX = j;
                this.selectedGridY = i;
            }
        }
        if (this.selectedGridX != -1) {
            this.selectedGridFunc = this.func[this.selectedGridX][this.selectedGridY];
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dragging = true;
        this.edit(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.dragging) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.dragX = n;
        this.dragY = n2;
        int n3 = this.getPanelHeight();
        int n4 = this.selectedCoefX;
        int n5 = this.selectedCoefY;
        this.selectedCoefX = -1;
        this.selectedCoefY = -1;
        this.selection = 0;
        if (this.view2d != null && this.view2d.inside(n, n2)) {
            this.selection = 2;
        } else if (this.view3d != null && this.view3d.inside(n, n2)) {
            this.selection = 1;
            this.findGridPoint3D(n, n2);
        } else if (this.viewFreq != null && this.viewFreq.inside(n, n2)) {
            int n6 = this.getTermWidth();
            this.selectedCoefX = (n - this.viewFreq.x) / n6;
            this.selectedCoefY = (n2 - this.viewFreq.y) / n6;
            if (this.selectedCoefX >= this.maxTerms) {
                this.selectedCoefY = -1;
                this.selectedCoefX = -1;
            }
            if (this.selectedCoefY >= this.maxTerms) {
                this.selectedCoefY = -1;
                this.selectedCoefX = -1;
            }
            if (this.selectedCoefX == 0 && this.fixedCheck.getState()) {
                this.selectedCoefX = 1;
            }
            if (this.selectedCoefY == 0 && this.fixedCheck.getState()) {
                this.selectedCoefY = 1;
            }
            if (this.selectedCoefX != -1 && this.selectedCoefY != -1) {
                this.selection = 3;
            }
        }
        if (this.selectedCoefX != n4 || this.selectedCoefY != n5) {
            this.cv.repaint(this.pause);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.selection == 3) {
            this.editMagClick();
        }
        if (mouseEvent.getClickCount() == 2 && this.selectedCoefX != -1) {
            for (int i = 0; i != this.maxTerms; ++i) {
                for (int j = 0; j != this.maxTerms; ++j) {
                    if (this.selectedCoefX == i && this.selectedCoefY == j) continue;
                    this.magcoef[i][j] = 0.0;
                }
            }
            this.magcoef[this.selectedCoefX][this.selectedCoefY] = 1.0;
            this.cv.repaint(this.pause);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.dragging && this.selectedCoefX != -1) {
            this.selectedCoefY = -1;
            this.selectedCoefX = -1;
            this.cv.repaint(this.pause);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if (this.selection == 2) {
            this.findGridPoint2D(mouseEvent.getX(), mouseEvent.getY());
        }
        this.dragStartX = mouseEvent.getX();
        this.dragStartY = mouseEvent.getY();
        if (this.selectedCoefX != -1) {
            this.magDragStart = this.magcoef[this.selectedCoefX][this.selectedCoefY];
        }
        this.viewAngleDragStart = this.viewAngle;
        this.viewHeightDragStart = this.viewHeight;
        this.viewZoomDragStart = this.viewZoom;
        this.dragging = true;
        this.edit(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        this.showMode = false;
        this.dragStop = false;
        this.editingFunc = false;
        this.dragging = false;
        this.dragClear = false;
        this.dragSet = false;
        this.mouseMoved(mouseEvent);
        this.cv.repaint(this.pause);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.stoppedCheck) {
            this.cv.repaint(this.pause);
            return;
        }
        if (itemEvent.getItemSelectable() == this.displayChooser || itemEvent.getItemSelectable() == this.freqCheck) {
            this.setupDisplay();
            this.cv.repaint(this.pause);
        }
        if (itemEvent.getItemSelectable() == this.display2Chooser || itemEvent.getItemSelectable() == this.colorCheck) {
            this.cv.repaint(this.pause);
        }
        if (itemEvent.getItemSelectable() == this.fixedCheck) {
            if (this.fixedCheck.getState()) {
                for (int i = 0; i != this.sampleCount; ++i) {
                    this.magcoef[0][i] = 0.0;
                    this.magcoef[i][0] = 0.0;
                }
            }
            this.transform(true);
            this.cv.repaint(this.pause);
        }
        if (itemEvent.getItemSelectable() == this.soundCheck) {
            if (this.soundCheck.getState()) {
                this.speedBar.setValue(200);
                this.dampingBar.setValue(75);
                this.setDamping();
                this.baseFreqBar.enable();
                this.doPlay();
            } else {
                this.baseFreqBar.disable();
            }
        }
    }

    void ndfft(double[] dArray, int[] nArray, int n, int n2) {
        int n3;
        int n4 = 1;
        int n5 = 1;
        double d = (double)(n2 * 2) * Math.PI;
        for (n3 = 0; n3 < n; ++n3) {
            n4 *= nArray[n3];
        }
        for (n3 = 0; n3 < n; ++n3) {
            int n6;
            int n7;
            int n8 = nArray[n3];
            int n9 = n4 / (n8 * n5);
            int n10 = 2 * n5;
            int n11 = n10 * n8;
            int n12 = n11 * n9;
            int n13 = 0;
            for (n7 = 0; n7 < n11; n7 += n10) {
                if (n7 < n13) {
                    for (int i = n7; i < n7 + n10; i += 2) {
                        for (int j = i; j < n12; j += n11) {
                            int n14 = n13 + j - n7;
                            double d2 = dArray[j];
                            double d3 = dArray[j + 1];
                            dArray[j] = dArray[n14];
                            dArray[j + 1] = dArray[n14 + 1];
                            dArray[n14] = d2;
                            dArray[n14 + 1] = d3;
                        }
                    }
                }
                for (n6 = n11 / 2; n6 > n10 && n13 > n6 - 1; n13 -= n6, n6 /= 2) {
                }
                n13 += n6;
            }
            int n15 = n10;
            while (n15 < n11) {
                n6 = 2 * n15;
                double d4 = d / ((double)n6 / (double)n10);
                double d5 = 1.0;
                double d6 = 0.0;
                double d7 = Math.sin(0.5 * d4);
                d7 *= d7 * -2.0;
                double d8 = Math.sin(d4);
                for (int i = 0; i < n15; i += n10) {
                    for (int j = i; j < i + n10; j += 2) {
                        for (n7 = j; n7 < n12; n7 += n6) {
                            int n16 = n7 + 1;
                            int n17 = n7 + n15;
                            int n18 = n17 + 1;
                            double d9 = d5 * dArray[n17] - d6 * dArray[n18];
                            double d10 = d5 * dArray[n18] + d6 * dArray[n17];
                            dArray[n17] = dArray[n7] - d9;
                            dArray[n18] = dArray[n16] - d10;
                            int n19 = n7;
                            dArray[n19] = dArray[n19] + d9;
                            int n20 = n16;
                            dArray[n20] = dArray[n20] + d10;
                        }
                    }
                    double d11 = d5;
                    d5 += d5 * d7 - d6 * d8;
                    d6 += d6 * d7 + d11 * d8;
                }
                n15 = n6;
            }
            n5 *= n8;
        }
    }

    void doPlay() {
        this.skew = 0;
        this.sndmin = -1.0;
        this.sndmax = 1.0;
        MembraneAudioDataStream membraneAudioDataStream = new MembraneAudioDataStream(this);
        AudioPlayer.player.start((InputStream)((Object)membraneAudioDataStream));
    }

    AudioDataStream getAudioData() {
        boolean bl;
        if (!this.soundCheck.getState()) {
            return null;
        }
        int n = 400;
        byte[] byArray = new byte[n];
        double d = 62.83185307179586 * (double)this.baseFreqBar.getValue() / 8000.0;
        double d2 = Math.PI / d;
        if (this.dragStop || this.editingFunc) {
            d2 = 0.0;
        }
        int n2 = this.maxTerms > 16 ? 16 : this.maxTerms;
        do {
            double d3;
            bl = false;
            double d4 = d3 = -this.sndmin > this.sndmax ? -this.sndmin : this.sndmax;
            if (d3 < 0.02) {
                d3 = 0.02;
            }
            double d5 = 127.0 / d3;
            this.sndmax = 0.0;
            this.sndmin = 0.0;
            for (int i = 0; i != n; ++i) {
                double d6 = 0.0;
                double d7 = (double)(i + this.skew) * d;
                for (int j = 0; j != n2; ++j) {
                    for (int k = 0; k != n2; ++k) {
                        if (!(this.omega[j][k] < d2)) continue;
                        d6 += this.magcoef[j][k] * Math.sin(d7 * this.omega[j][k]) * d5;
                    }
                }
                if (d6 < this.sndmin) {
                    this.sndmin = d6;
                }
                if (d6 > this.sndmax) {
                    this.sndmax = d6;
                }
                int n3 = (int)d6;
                try {
                    byArray[i] = (byte)to_ulaw[n3 + 128];
                    continue;
                }
                catch (Exception exception) {
                    bl = true;
                }
            }
            this.sndmin /= d5;
            this.sndmax /= d5;
        } while (bl);
        this.skew += n;
        return new AudioDataStream(new AudioData(byArray));
    }
}

