/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.InputStream;
import java.util.Random;
import sun.audio.AudioData;
import sun.audio.AudioDataStream;
import sun.audio.AudioPlayer;

class FourierFrame
extends Frame
implements ComponentListener,
ActionListener,
AdjustmentListener,
MouseMotionListener,
MouseListener {
    Thread engine = null;
    Dimension winSize;
    Image dbimage;
    Random random;
    public static final int sampleCount = 720;
    public static final int halfSampleCount = 360;
    public static final double halfSampleCountFloat = 360.0;
    Fourier applet;
    Button sineButton;
    Button rectButton;
    Button fullRectButton;
    Button triangleButton;
    Button sawtoothButton;
    Button squareButton;
    Button noiseButton;
    Button blankButton;
    Button clipButton;
    Button resampleButton;
    Button quantizeButton;
    Button playButton;
    Scrollbar termBar;
    Scrollbar freqBar;
    double[] magcoef;
    double[] phasecoef;
    static final double pi = Math.PI;
    static final double step = Math.PI / 360;
    double[] func;
    int maxTerms = 160;
    int selectedCoef;
    static final int SEL_NONE = 0;
    static final int SEL_FUNC = 1;
    static final int SEL_MAG = 2;
    static final int SEL_PHASE = 3;
    int selection;
    int dragX;
    int dragY;
    boolean dragging;
    static final int[] to_ulaw = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 30, 30, 31, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 49, 51, 53, 55, 57, 59, 61, 63, 66, 70, 74, 78, 84, 92, 104, 254, 231, 219, 211, 205, 201, 197, 193, 190, 188, 186, 184, 182, 180, 178, 176, 175, 174, 173, 172, 171, 170, 169, 168, 167, 166, 165, 164, 163, 162, 161, 160, 159, 159, 158, 158, 157, 157, 156, 156, 155, 155, 154, 154, 153, 153, 152, 152, 151, 151, 150, 150, 149, 149, 148, 148, 147, 147, 146, 146, 145, 145, 144, 144, 143, 143, 143, 143, 142, 142, 142, 142, 141, 141, 141, 141, 140, 140, 140, 140, 139, 139, 139, 139, 138, 138, 138, 138, 137, 137, 137, 137, 136, 136, 136, 136, 135, 135, 135, 135, 134, 134, 134, 134, 133, 133, 133, 133, 132, 132, 132, 132, 131, 131, 131, 131, 130, 130, 130, 130, 129, 129, 129, 129, 128, 128, 128, 128};
    FourierCanvas cv;
    static int[] freqs = new int[]{25, 32, 40, 50, 64, 80, 100, 125, 160, 200, 250, 320, 400, 500, 800, 1000, 1600, 2000};

    public String getAppletInfo() {
        return "Fourier Series by Paul Falstad";
    }

    FourierFrame(Fourier fourier) {
        super("Fourier Series Applet");
        this.applet = fourier;
    }

    int getrand(int n) {
        int n2 = this.random.nextInt();
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2 % n;
    }

    public void init() {
        this.selectedCoef = -1;
        this.magcoef = new double[this.maxTerms];
        this.phasecoef = new double[this.maxTerms];
        this.func = new double[721];
        this.setLayout(new FourierLayout());
        this.cv = new FourierCanvas(this);
        this.cv.addComponentListener(this);
        this.cv.addMouseMotionListener(this);
        this.cv.addMouseListener(this);
        this.add(this.cv);
        this.sineButton = new Button("Sine");
        this.add(this.sineButton);
        this.sineButton.addActionListener(this);
        this.triangleButton = new Button("Triangle");
        this.add(this.triangleButton);
        this.triangleButton.addActionListener(this);
        this.sawtoothButton = new Button("Sawtooth");
        this.add(this.sawtoothButton);
        this.sawtoothButton.addActionListener(this);
        this.squareButton = new Button("Square");
        this.add(this.squareButton);
        this.squareButton.addActionListener(this);
        this.noiseButton = new Button("Noise");
        this.add(this.noiseButton);
        this.noiseButton.addActionListener(this);
        this.clipButton = new Button("Clip");
        this.add(this.clipButton);
        this.clipButton.addActionListener(this);
        this.resampleButton = new Button("Resample");
        this.add(this.resampleButton);
        this.resampleButton.addActionListener(this);
        this.quantizeButton = new Button("Quantize");
        this.add(this.quantizeButton);
        this.quantizeButton.addActionListener(this);
        this.rectButton = new Button("Rectify");
        this.add(this.rectButton);
        this.rectButton.addActionListener(this);
        this.fullRectButton = new Button("Full Rectify");
        this.add(this.fullRectButton);
        this.fullRectButton.addActionListener(this);
        this.playButton = new Button("Play");
        this.add(this.playButton);
        this.playButton.addActionListener(this);
        this.blankButton = new Button("Clear");
        this.add(this.blankButton);
        this.blankButton.addActionListener(this);
        this.add(new Label("Number of Terms", 1));
        this.termBar = new Scrollbar(0, 30, 1, 1, this.maxTerms);
        this.add(this.termBar);
        this.termBar.addAdjustmentListener(this);
        this.add(new Label("Playing Frequency", 1));
        this.freqBar = new Scrollbar(0, 50, 1, 0, 100);
        this.add(this.freqBar);
        this.freqBar.addAdjustmentListener(this);
        this.add(new Label("http://www.falstad.com", 1));
        this.random = new Random();
        this.reinit();
        this.cv.setBackground(Color.black);
        this.cv.setForeground(Color.lightGray);
        this.resize(500, 500);
        this.handleResize();
        this.show();
    }

    void reinit() {
        this.doSawtooth();
    }

    void handleResize() {
        Dimension dimension = this.winSize = this.cv.getSize();
        if (this.winSize.width == 0) {
            return;
        }
        this.dbimage = this.createImage(dimension.width, dimension.height);
    }

    void doSawtooth() {
        int n = 0;
        while (n != 720) {
            this.func[n] = (double)(n - 360) / 360.0;
            ++n;
        }
        this.func[720] = this.func[0];
        this.transform();
    }

    void doTriangle() {
        int n = 0;
        while (n != 360) {
            this.func[n] = (double)(n * 2 - 360) / 360.0;
            this.func[n + 360] = (double)((360 - n) * 2 - 360) / 360.0;
            ++n;
        }
        this.func[720] = this.func[0];
        this.transform();
    }

    void doSine() {
        int n = 0;
        while (n != 720) {
            this.func[n] = Math.sin((double)(n - 360) * (Math.PI / 360));
            ++n;
        }
        this.func[720] = this.func[0];
        this.transform();
    }

    void doRect() {
        int n = 0;
        while (n != 720) {
            if (this.func[n] < 0.0) {
                this.func[n] = 0.0;
            }
            ++n;
        }
        this.func[720] = this.func[0];
        this.transform();
    }

    void doFullRect() {
        int n = 0;
        while (n != 720) {
            if (this.func[n] < 0.0) {
                this.func[n] = -this.func[n];
            }
            ++n;
        }
        this.func[720] = this.func[0];
        this.transform();
    }

    void doSquare() {
        int n = 0;
        while (n != 360) {
            this.func[n] = -1.0;
            this.func[n + 360] = 1.0;
            ++n;
        }
        this.func[720] = this.func[0];
        this.transform();
    }

    void doNoise() {
        int n = 3;
        int n2 = 0;
        while (n2 != 720 / n) {
            double d = Math.random() * 2.0 - 1.0;
            int n3 = 0;
            while (n3 != n) {
                this.func[n2 * n + n3] = d;
                ++n3;
            }
            ++n2;
        }
        this.func[720] = this.func[0];
        this.transform();
    }

    void doBlank() {
        int n = 0;
        while (n <= 720) {
            this.func[n] = 0.0;
            ++n;
        }
        this.transform();
    }

    void doSetFunc() {
        int n = this.winSize.width / 3;
        int n2 = 0;
        while (n2 != 721) {
            int n3 = n * n2 / 720;
            double d = 0.0;
            int n4 = this.termBar.getValue();
            int n5 = 0;
            while (n5 != n4) {
                d += this.magcoef[n5] * Math.cos(Math.PI / 360 * (double)(n2 - 360) * (double)n5 + this.phasecoef[n5]);
                ++n5;
            }
            this.func[n2] = d;
            ++n2;
        }
        this.transform();
    }

    void doClip() {
        double d = 1.2;
        int n = 0;
        while (n != 720) {
            int n2 = n;
            this.func[n2] = this.func[n2] * d;
            if (this.func[n] > 1.0) {
                this.func[n] = 1.0;
            }
            if (this.func[n] < -1.0) {
                this.func[n] = -1.0;
            }
            ++n;
        }
        this.func[720] = this.func[0];
        this.transform();
    }

    void doResample() {
        int n = 60;
        int n2 = 0;
        while (n2 != 720) {
            int n3 = 1;
            while (n3 != n) {
                this.func[n2 + n3] = this.func[n2];
                ++n3;
            }
            n2 += n;
        }
        this.func[720] = this.func[0];
        this.transform();
    }

    void doQuantize() {
        int n = 0;
        while (n != 720) {
            this.func[n] = (double)Math.round(this.func[n] * 2.0) / 2.0;
            ++n;
        }
        this.func[720] = this.func[0];
        this.transform();
    }

    int getFreq() {
        return (int)(27.5 * Math.exp((double)this.freqBar.getValue() * 0.04158883084));
    }

    void doPlay() {
        this.doSetFunc();
        byte[] byArray = new byte[16000];
        double d = 0.0;
        int n = 0;
        while (n != 720) {
            if (this.func[n] > d) {
                d = this.func[n];
            }
            if (this.func[n] < -d) {
                d = -this.func[n];
            }
            ++n;
        }
        double d2 = 127.0 / d;
        int n2 = 8000 / this.getFreq();
        double d3 = 720.0 / (double)n2;
        n = 0;
        while (n != 16000) {
            int n3 = (int)(0.5 + this.func[(int)((double)(n % n2) * d3)] * d2);
            byArray[n] = (byte)to_ulaw[n3 + 128];
            ++n;
        }
        AudioDataStream audioDataStream = new AudioDataStream(new AudioData(byArray));
        AudioPlayer.player.start((InputStream)audioDataStream);
        this.cv.repaint();
    }

    void transform() {
        double d = 1.0E-5;
        int n = 0;
        while (n != this.maxTerms) {
            double d2 = 0.0;
            int n2 = 0;
            while (n2 != 721) {
                int n3 = n2 == 0 || n2 == 720 ? 1 : ((n2 & 1) + 1) * 2;
                double d3 = Math.cos(Math.PI / 360 * (double)(n2 - 360) * (double)n);
                d2 += d3 * this.func[n2] * (double)n3;
                ++n2;
            }
            double d4 = d2 * 9.25925925925926E-4;
            d2 = 0.0;
            n2 = 0;
            while (n2 != 721) {
                int n4 = n2 == 0 || n2 == 720 ? 1 : ((n2 & 1) + 1) * 2;
                double d5 = Math.sin(Math.PI / 360 * (double)(n2 - 360) * (double)n);
                d2 += d5 * this.func[n2] * (double)n4;
                ++n2;
            }
            double d6 = d2 * 9.25925925925926E-4;
            if (d4 < d && d4 > -d) {
                d4 = 0.0;
            }
            if (d6 < d && d6 > -d) {
                d6 = 0.0;
            }
            if (n == 0) {
                this.magcoef[0] = d4 / 2.0;
                this.phasecoef[0] = 0.0;
            } else {
                this.magcoef[n] = Math.sqrt(d4 * d4 + d6 * d6);
                this.phasecoef[n] = Math.atan2(-d6, d4);
            }
            ++n;
        }
    }

    int getPanelHeight() {
        return this.winSize.height / 3;
    }

    void centerString(Graphics graphics, String string, int n) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, (this.winSize.width - fontMetrics.stringWidth(string)) / 2, n);
    }

    public void paint(Graphics graphics) {
        this.cv.repaint();
    }

    public void updateFourier(Graphics graphics) {
        int n;
        int n2;
        int n3;
        Graphics graphics2 = this.dbimage.getGraphics();
        if (this.winSize == null || this.winSize.width == 0) {
            return;
        }
        Color color = new Color(76, 76, 76);
        Color color2 = new Color(127, 127, 127);
        graphics2.setColor(this.cv.getBackground());
        graphics2.fillRect(0, 0, this.winSize.width, this.winSize.height);
        graphics2.setColor(this.cv.getForeground());
        int n4 = -1;
        int n5 = -1;
        int n6 = this.getPanelHeight();
        int n7 = n6 / 2;
        int n8 = n6 / 2;
        int n9 = this.winSize.width / 3;
        double d = 0.75 * (double)n8;
        int n10 = -1;
        while (n10 <= 1) {
            graphics2.setColor(n10 == 0 ? color2 : color);
            graphics2.drawLine(0, n7 + n10 * (int)d, this.winSize.width, n7 + n10 * (int)d);
            ++n10;
        }
        n10 = 2;
        while (n10 <= 4) {
            graphics2.setColor(n10 == 3 ? color2 : color);
            graphics2.drawLine(n9 * n10 / 2, n7 - (int)d, n9 * n10 / 2, n7 + (int)d);
            ++n10;
        }
        graphics2.setColor(Color.white);
        if (!this.dragging || this.selection == 1) {
            n10 = 0;
            while (n10 != 721) {
                n3 = n9 * n10 / 720;
                n2 = n7 - (int)(d * this.func[n10]);
                if (n4 != -1) {
                    graphics2.drawLine(n4, n5, n3, n2);
                    graphics2.drawLine(n4 + n9, n5, n3 + n9, n2);
                    graphics2.drawLine(n4 + n9 * 2, n5, n3 + n9 * 2, n2);
                }
                n4 = n3;
                n5 = n2;
                ++n10;
            }
        }
        n3 = this.termBar.getValue();
        if (!this.dragging || this.selection != 1) {
            graphics2.setColor(Color.red);
            n4 = -1;
            n10 = 0;
            while (n10 != 721) {
                n2 = n9 * n10 / 720;
                double d2 = 0.0;
                n = 0;
                while (n != n3) {
                    d2 += this.magcoef[n] * Math.cos(Math.PI / 360 * (double)(n10 - 360) * (double)n + this.phasecoef[n]);
                    ++n;
                }
                int n11 = n7 - (int)(d * d2);
                if (n4 != -1) {
                    graphics2.drawLine(n4, n5, n2, n11);
                    graphics2.drawLine(n4 + n9, n5, n2 + n9, n11);
                    graphics2.drawLine(n4 + n9 * 2, n5, n2 + n9 * 2, n11);
                }
                n4 = n2;
                n5 = n11;
                ++n10;
            }
        }
        if (this.selectedCoef != -1 && !this.dragging) {
            graphics2.setColor(Color.yellow);
            n4 = -1;
            d *= this.magcoef[this.selectedCoef];
            double d3 = this.phasecoef[this.selectedCoef];
            double d4 = (double)(this.selectedCoef * 2) * Math.PI / (double)n9;
            int n12 = n9 / 2;
            n10 = 0;
            while (n10 != 721) {
                int n13 = n9 * n10 / 720;
                double d5 = Math.cos(Math.PI / 360 * (double)(n10 - 360) * (double)this.selectedCoef + d3);
                int n14 = n7 - (int)(d * d5);
                if (n4 != -1) {
                    graphics2.drawLine(n4, n5, n13, n14);
                    graphics2.drawLine(n4 + n9, n5, n13 + n9, n14);
                    graphics2.drawLine(n4 + n9 * 2, n5, n13 + n9 * 2, n14);
                }
                n4 = n13;
                n5 = n14;
                ++n10;
            }
            if (this.selectedCoef > 0) {
                int n15 = this.getFreq() * this.selectedCoef;
                this.centerString(graphics2, this.getFreq() * this.selectedCoef + (n15 > 4000 ? " Hz (aliased)" : " Hz"), n6);
            }
        }
        int n16 = this.getTermWidth();
        d = 1.2 * (double)n8;
        n7 = n6 * 3 / 2 + (int)d / 2;
        graphics2.setColor(Color.white);
        this.centerString(graphics2, "Magnitudes", (int)((double)n6 * 1.16));
        this.centerString(graphics2, "Phases", (int)((double)n6 * 2.1));
        graphics2.setColor(color2);
        graphics2.drawLine(0, n7, this.winSize.width, n7);
        graphics2.setColor(color);
        graphics2.drawLine(0, n7 - (int)d, this.winSize.width, n7 - (int)d);
        n = n16 - 3;
        n10 = 0;
        while (n10 != n3) {
            int n17 = n16 * n10 + n16 / 2;
            int n18 = n7 - (int)(this.magcoef[n10] * d);
            graphics2.setColor(n10 == this.selectedCoef ? Color.yellow : Color.white);
            graphics2.drawLine(n17, n7, n17, n18);
            graphics2.fillOval(n17 - n / 2, n18 - n / 2, n, n);
            ++n10;
        }
        d = 0.75 * (double)n8;
        n7 = n6 * 5 / 2;
        n10 = -2;
        while (n10 <= 2) {
            graphics2.setColor(n10 == 0 ? color2 : color);
            graphics2.drawLine(0, n7 + n10 * (int)d / 2, this.winSize.width, n7 + n10 * (int)d / 2);
            ++n10;
        }
        d /= Math.PI;
        n10 = 0;
        while (n10 != n3) {
            int n19 = n16 * n10 + n16 / 2;
            int n20 = n7 - (int)(this.phasecoef[n10] * d);
            graphics2.setColor(n10 == this.selectedCoef ? Color.yellow : Color.white);
            graphics2.drawLine(n19, n7, n19, n20);
            graphics2.fillOval(n19 - n / 2, n20 - n / 2, n, n);
            ++n10;
        }
        graphics.drawImage(this.dbimage, 0, 0, this);
    }

    int getTermWidth() {
        int n;
        int n2 = this.termBar.getValue();
        int n3 = this.winSize.width / n2;
        if (n3 > (n = this.winSize.width / 30)) {
            n3 = n;
        }
        return n3 &= 0xFFFFFFFE;
    }

    void edit(MouseEvent mouseEvent) {
        if (this.selection == 0) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        switch (this.selection) {
            case 2: {
                this.editMag(n, n2);
                break;
            }
            case 1: {
                this.editFunc(n, n2);
                break;
            }
            case 3: {
                this.editPhase(n, n2);
            }
        }
    }

    void editMag(int n, int n2) {
        if (this.selectedCoef == -1) {
            return;
        }
        int n3 = this.getPanelHeight();
        double d = 1.2 * (double)n3 / 2.0;
        double d2 = n3 * 3 / 2 + (int)d / 2;
        double d3 = -((double)n2 - d2) / d;
        if (this.selectedCoef > 0) {
            if (d3 < 0.0) {
                d3 = 0.0;
            }
        } else if (d3 < -1.0) {
            d3 = -1.0;
        }
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if (this.magcoef[this.selectedCoef] == d3) {
            return;
        }
        this.magcoef[this.selectedCoef] = d3;
        this.cv.repaint();
    }

    void editFunc(int n, int n2) {
        if (this.dragX == n) {
            this.editFuncPoint(n, n2);
            this.dragY = n2;
        } else {
            int n3 = n < this.dragX ? n : this.dragX;
            int n4 = n < this.dragX ? n2 : this.dragY;
            int n5 = n > this.dragX ? n : this.dragX;
            int n6 = n > this.dragX ? n2 : this.dragY;
            this.dragX = n;
            this.dragY = n2;
            n = n3;
            while (n <= n5) {
                n2 = n4 + (n6 - n4) * (n - n3) / (n5 - n3);
                this.editFuncPoint(n, n2);
                ++n;
            }
        }
    }

    void editFuncPoint(int n, int n2) {
        int n3 = this.getPanelHeight();
        int n4 = n3 / 2;
        int n5 = n3 / 2;
        int n6 = this.winSize.width / 3;
        double d = 0.75 * (double)n5;
        int n7 = n % n6 * 720 / n6;
        int n8 = (n % n6 + 1) * 720 / n6 - 1;
        double d2 = (double)(n4 - n2) / d;
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if (d2 < -1.0) {
            d2 = -1.0;
        }
        while (n7 <= n8) {
            this.func[n7] = d2;
            ++n7;
        }
        this.func[720] = this.func[0];
        this.cv.repaint();
    }

    void editPhase(int n, int n2) {
        double d;
        if (this.selectedCoef == -1) {
            return;
        }
        int n3 = this.getPanelHeight();
        double d2 = n3 * 5 / 2;
        double d3 = -((double)n2 - d2) * Math.PI / (d = 0.75 * (double)n3 / 2.0);
        if (d3 < -Math.PI) {
            d3 = -Math.PI;
        }
        if (d3 > Math.PI) {
            d3 = Math.PI;
        }
        if (this.phasecoef[this.selectedCoef] == d3) {
            return;
        }
        this.phasecoef[this.selectedCoef] = d3;
        this.cv.repaint();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.cv.repaint();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.handleResize();
        this.cv.repaint(100L);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.triangleButton) {
            this.doTriangle();
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.sineButton) {
            this.doSine();
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.rectButton) {
            this.doRect();
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.fullRectButton) {
            this.doFullRect();
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.squareButton) {
            this.doSquare();
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.noiseButton) {
            this.doNoise();
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.blankButton) {
            this.doBlank();
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.sawtoothButton) {
            this.doSawtooth();
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.clipButton) {
            this.doClip();
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.quantizeButton) {
            this.doQuantize();
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.resampleButton) {
            this.doResample();
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.playButton) {
            this.doPlay();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.termBar) {
            this.cv.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dragging = true;
        this.edit(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.dragX = n;
        this.dragY = n2;
        int n3 = this.getPanelHeight();
        int n4 = this.selectedCoef;
        this.selectedCoef = -1;
        this.selection = 0;
        if (n2 < n3) {
            this.selection = 1;
        }
        if (n2 >= n3 && n2 < n3 * 3) {
            int n5 = this.getTermWidth();
            this.selectedCoef = n / n5;
            if (this.selectedCoef > this.termBar.getValue()) {
                this.selectedCoef = -1;
            }
            if (this.selectedCoef != -1) {
                int n6 = this.selection = n2 >= n3 * 2 ? 3 : 2;
            }
        }
        if (this.selectedCoef != n4) {
            this.cv.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0 && this.selectedCoef != -1) {
            this.termBar.setValue(this.selectedCoef + 1);
            this.cv.repaint();
        }
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        this.dragging = true;
        this.edit(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        this.dragging = false;
        if (this.selection == 1) {
            this.transform();
        } else if (this.selection != 0) {
            this.doSetFunc();
        }
        this.cv.repaint();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.applet.destroyFrame();
            return true;
        }
        return super.handleEvent(event);
    }
}

