/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import sun.audio.AudioData;
import sun.audio.AudioDataStream;
import sun.audio.AudioPlayer;

class BarWavesFrame
extends Frame
implements ComponentListener,
ActionListener,
AdjustmentListener,
MouseMotionListener,
MouseListener,
ItemListener {
    Thread engine = null;
    Dimension winSize;
    Image dbimage;
    Random random;
    int maxTerms = 50;
    int modeCount;
    int maxMaxTerms = 90;
    int sampleCount;
    double[][] modeTable;
    double[] modeNorms;
    public static final double epsilon = 1.0E-7;
    public static final double epsilon2 = 0.003;
    Button sineButton;
    Button blankButton;
    Checkbox stoppedCheck;
    Checkbox soundCheck;
    Choice modeChooser;
    Choice setupChooser;
    Vector setupList;
    Setup setup;
    Choice displayChooser;
    Scrollbar dampingBar;
    Scrollbar speedBar;
    Scrollbar loadBar;
    Scrollbar baseFreqBar;
    Scrollbar stiffnessBar;
    double[] magcoef;
    double[] dampcoef;
    double[] phasecoef;
    double[] phasecoefcos;
    double[] phasecoefadj;
    double[] omega;
    static final double pi = Math.PI;
    double step;
    double[] func;
    double[] funci;
    int[] thickness;
    int[] xpoints;
    int[] ypoints;
    int selectedCoef;
    int magnitudesY;
    static final int SEL_NONE = 0;
    static final int SEL_FUNC = 1;
    static final int SEL_MAG = 2;
    static final int MODE_SHAPE = 0;
    static final int MODE_FORCE = 1;
    static final int MODE_THICKNESS = 2;
    static final int DISP_PHASE = 0;
    static final int DISP_PHASECOS = 1;
    static final int DISP_MODES = 2;
    static final int BOUND_HINGED = 0;
    static final int BOUND_FREE = 1;
    static final int BOUND_CLAMPED = 2;
    int selection;
    int dragX;
    int dragY;
    boolean dragging;
    double t;
    int pause;
    Color gray1 = new Color(76, 76, 76);
    Color gray2 = new Color(127, 127, 127);
    BarWavesCanvas cv;
    BarWaves applet;
    double logep2 = 0.0;
    static final int[] to_ulaw = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 30, 30, 31, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 49, 51, 53, 55, 57, 59, 61, 63, 66, 70, 74, 78, 84, 92, 104, 254, 231, 219, 211, 205, 201, 197, 193, 190, 188, 186, 184, 182, 180, 178, 176, 175, 174, 173, 172, 171, 170, 169, 168, 167, 166, 165, 164, 163, 162, 161, 160, 159, 159, 158, 158, 157, 157, 156, 156, 155, 155, 154, 154, 153, 153, 152, 152, 151, 151, 150, 150, 149, 149, 148, 148, 147, 147, 146, 146, 145, 145, 144, 144, 143, 143, 143, 143, 142, 142, 142, 142, 141, 141, 141, 141, 140, 140, 140, 140, 139, 139, 139, 139, 138, 138, 138, 138, 137, 137, 137, 137, 136, 136, 136, 136, 135, 135, 135, 135, 134, 134, 134, 134, 133, 133, 133, 133, 132, 132, 132, 132, 131, 131, 131, 131, 130, 130, 130, 130, 129, 129, 129, 129, 128, 128, 128, 128};
    double sndmin;
    double sndmax;

    public String getAppletInfo() {
        return "BarWaves by Paul Falstad";
    }

    int getrand(int n) {
        int n2 = this.random.nextInt();
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2 % n;
    }

    BarWavesFrame(BarWaves barWaves) {
        super("Bar Waves Applet");
        this.applet = barWaves;
    }

    public void init() {
        this.setupList = new Vector();
        Setup setup = new FreeBarSetup();
        while (setup != null) {
            this.setupList.addElement(setup);
            setup = ((Setup)setup).createNext();
        }
        this.selectedCoef = -1;
        this.setLayout(new BarWavesLayout());
        this.cv = new BarWavesCanvas(this);
        this.cv.addComponentListener(this);
        this.cv.addMouseMotionListener(this);
        this.cv.addMouseListener(this);
        this.add(this.cv);
        this.setupChooser = new Choice();
        int n = 0;
        while (n != this.setupList.size()) {
            this.setupChooser.add("Setup: " + ((Setup)this.setupList.elementAt(n)).getName());
            ++n;
        }
        this.setup = (Setup)this.setupList.elementAt(0);
        this.setupChooser.addItemListener(this);
        this.add(this.setupChooser);
        this.sineButton = new Button("Fundamental");
        this.add(this.sineButton);
        this.sineButton.addActionListener(this);
        this.blankButton = new Button("Clear");
        this.add(this.blankButton);
        this.blankButton.addActionListener(this);
        this.stoppedCheck = new Checkbox("Stopped");
        this.stoppedCheck.addItemListener(this);
        this.add(this.stoppedCheck);
        this.soundCheck = new Checkbox("Sound", false);
        this.soundCheck.addItemListener(this);
        this.add(this.soundCheck);
        this.modeChooser = new Choice();
        this.modeChooser.add("Mouse = Shape bar");
        this.modeChooser.add("Mouse = Apply static force");
        this.modeChooser.addItemListener(this);
        this.add(this.modeChooser);
        this.displayChooser = new Choice();
        this.displayChooser.add("Display Phases");
        this.displayChooser.add("Display Phase Cosines");
        this.displayChooser.add("Display Modes");
        this.displayChooser.addItemListener(this);
        this.add(this.displayChooser);
        this.add(new Label("Simulation Speed", 1));
        this.speedBar = new Scrollbar(0, 166, 1, 24, 300);
        this.add(this.speedBar);
        this.speedBar.addAdjustmentListener(this);
        this.add(new Label("Damping", 1));
        this.dampingBar = new Scrollbar(0, 10, 1, 0, 400);
        this.add(this.dampingBar);
        this.dampingBar.addAdjustmentListener(this);
        this.add(new Label("Resolution", 1));
        this.loadBar = new Scrollbar(0, this.maxTerms, 1, 40, this.maxMaxTerms);
        this.add(this.loadBar);
        this.loadBar.addAdjustmentListener(this);
        this.setLoadCount();
        this.add(new Label("Base Frequency", 1));
        this.baseFreqBar = new Scrollbar(0, 84, 12, 30, 168);
        this.add(this.baseFreqBar);
        this.baseFreqBar.addAdjustmentListener(this);
        this.baseFreqBar.disable();
        this.add(new Label("String Stiffness", 1));
        this.stiffnessBar = new Scrollbar(0, 10, 1, 0, 100);
        this.add(this.stiffnessBar);
        this.stiffnessBar.addAdjustmentListener(this);
        this.stiffnessBar.disable();
        try {
            String string = this.applet.getParameter("PAUSE");
            if (string != null) {
                this.pause = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.magcoef = new double[this.maxMaxTerms];
        this.phasecoef = new double[this.maxMaxTerms];
        this.phasecoefcos = new double[this.maxMaxTerms];
        this.phasecoefadj = new double[this.maxMaxTerms];
        this.func = new double[this.maxMaxTerms + 1];
        this.funci = new double[this.maxMaxTerms + 1];
        this.xpoints = new int[4];
        this.ypoints = new int[4];
        this.random = new Random();
        this.setDamping();
        this.reinit();
        this.cv.setBackground(Color.black);
        this.cv.setForeground(Color.lightGray);
        this.resize(500, 500);
        this.handleResize();
        this.show();
    }

    void reinit() {
        this.doFundamental();
    }

    void handleResize() {
        Dimension dimension = this.winSize = this.cv.getSize();
        if (this.winSize.width == 0) {
            return;
        }
        this.dbimage = this.createImage(dimension.width, dimension.height);
    }

    void doFundamental() {
        this.doBlank();
        this.magcoef[0] = 1.0;
        if (this.soundCheck.getState()) {
            this.doPlay();
        }
    }

    void doBlank() {
        int n = 0;
        while (n <= this.sampleCount) {
            this.func[n] = 0.0;
            ++n;
        }
        this.transform(true);
    }

    void transform(boolean bl) {
        this.t = 0.0;
        int n = 0;
        while (n != this.modeCount) {
            double d;
            double d2;
            double d3 = 0.0;
            double d4 = 0.0;
            int n2 = 1;
            while (n2 != this.sampleCount) {
                d3 += this.modeTable[n2][n] * this.func[n2];
                d4 -= this.modeTable[n2][n] * this.funci[n2];
                ++n2;
            }
            d3 /= this.modeNorms[n];
            d4 /= this.omega[n] * this.modeNorms[n];
            if (d3 < 1.0E-7 && d3 > -1.0E-7) {
                d3 = 0.0;
            }
            if (d4 < 1.0E-7 && d4 > -1.0E-7) {
                d4 = 0.0;
            }
            if (bl) {
                d4 = 0.0;
            }
            this.magcoef[n] = d2 = Math.sqrt(d3 * d3 + d4 * d4);
            this.phasecoefadj[n] = d = Math.atan2(d4, d3);
            this.phasecoef[n] = d;
            ++n;
        }
    }

    int getPanelHeight() {
        return this.winSize.height / 3;
    }

    void centerString(Graphics graphics, String string, int n) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, (this.winSize.width - fontMetrics.stringWidth(string)) / 2, n);
    }

    public void paint(Graphics graphics) {
        this.cv.repaint();
    }

    public void updateBarWaves(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.winSize == null || this.winSize.width == 0) {
            return;
        }
        Graphics graphics2 = this.dbimage.getGraphics();
        boolean bl = true;
        if (!this.stoppedCheck.getState()) {
            n5 = this.speedBar.getValue() - 100;
            double d = Math.exp((double)n5 / 20.0) * 0.002;
            this.t += (d *= 1.0 + (double)this.getrand(300) * 0.00191171);
        }
        graphics2.setColor(this.cv.getBackground());
        graphics2.fillRect(0, 0, this.winSize.width, this.winSize.height);
        graphics2.setColor(this.cv.getForeground());
        int n6 = this.getPanelHeight();
        int n7 = n6 / 2;
        int n8 = n6 / 2;
        double d = 0.75 * (double)n8;
        n5 = -1;
        while (n5 <= 1) {
            graphics2.setColor(n5 == 0 ? this.gray2 : this.gray1);
            graphics2.drawLine(0, n7 + n5 * (int)d, this.winSize.width, n7 + n5 * (int)d);
            ++n5;
        }
        graphics2.setColor(this.gray2);
        graphics2.drawLine(this.winSize.width / 2, n7 - (int)d, this.winSize.width / 2, n7 + (int)d);
        int n9 = this.setup.leftBoundary() == 1 ? 1 : 0;
        int n10 = this.sampleCount - (this.setup.rightBoundary() == 1 ? 1 : 0);
        if (this.dragging && this.selection == 1) {
            graphics2.setColor(Color.cyan);
            bl = true;
            n5 = n9;
            while (n5 <= n10) {
                int n11 = this.winSize.width * n5 / this.sampleCount;
                int n12 = n7 - (int)(d * this.func[n5]);
                this.drawBarPiece(graphics2, n11, n12, n5, n9);
                ++n5;
            }
        }
        if (!this.stoppedCheck.getState() && !this.dragging) {
            n5 = 0;
            while (n5 != this.modeCount) {
                int n13 = n5;
                this.magcoef[n13] = this.magcoef[n13] * this.dampcoef[n5];
                ++n5;
            }
        }
        double[] dArray = this.magcoef;
        double[] dArray2 = this.phasecoef;
        double[] dArray3 = this.phasecoefcos;
        if (!this.dragging || this.selection != 1) {
            graphics2.setColor(Color.white);
            n4 = 0;
            while (n4 != this.modeCount) {
                if (this.magcoef[n4] < 1.0E-7 && this.magcoef[n4] > -1.0E-7) {
                    this.phasecoefadj[n4] = 0.0;
                    this.phasecoef[n4] = 0.0;
                    this.magcoef[n4] = 0.0;
                } else {
                    bl = false;
                    this.phasecoef[n4] = (this.omega[n4] * this.t + this.phasecoefadj[n4]) % (Math.PI * 2);
                    if (this.phasecoef[n4] > Math.PI) {
                        int n14 = n4;
                        this.phasecoef[n14] = this.phasecoef[n14] - Math.PI * 2;
                    } else if (this.phasecoef[n4] < -Math.PI) {
                        int n15 = n4;
                        this.phasecoef[n15] = this.phasecoef[n15] + Math.PI * 2;
                    }
                    this.phasecoefcos[n4] = Math.cos(this.phasecoef[n4]);
                }
                ++n4;
            }
            n5 = n9;
            while (n5 <= n10) {
                n3 = this.winSize.width * n5 / this.sampleCount;
                double d2 = 0.0;
                n4 = 0;
                while (n4 != this.modeCount) {
                    d2 += dArray[n4] * this.modeTable[n5][n4] * dArray3[n4];
                    ++n4;
                }
                this.func[n5] = d2;
                n2 = n7 - (int)(d * d2);
                this.drawBarPiece(graphics2, n3, n2, n5, n9);
                ++n5;
            }
            if (this.setup.getThickness() == 0) {
                if (this.setup.leftBoundary() == 1) {
                    this.drawPin(graphics2, 1, n7, d);
                }
                if (this.setup.rightBoundary() == 1) {
                    this.drawPin(graphics2, this.sampleCount - 1, n7, d);
                }
            }
        }
        if (this.selectedCoef != -1 && !this.dragging && (dArray[this.selectedCoef] > 0.04 || dArray[this.selectedCoef] < -0.04)) {
            graphics2.setColor(Color.yellow);
            d *= dArray[this.selectedCoef];
            n5 = n9;
            while (n5 <= n10) {
                n4 = this.winSize.width * n5 / this.sampleCount;
                double d3 = this.modeTable[n5][this.selectedCoef] * dArray3[this.selectedCoef];
                n = n7 - (int)(d * d3);
                this.drawBarPiece(graphics2, n4, n, n5, n9);
                ++n5;
            }
        }
        if (this.selectedCoef != -1) {
            n4 = this.getFreq(this.selectedCoef);
            graphics2.setColor(Color.yellow);
            this.centerString(graphics2, n4 + " Hz", n6);
        } else if (this.soundCheck.getState()) {
            n4 = this.getFreq(0);
            graphics2.setColor(Color.white);
            this.centerString(graphics2, "Fundamental = " + n4 + " Hz", n6);
        }
        n4 = this.getTermWidth();
        d = 0.6 * (double)n8;
        graphics2.setColor(Color.white);
        this.magnitudesY = this.displayChooser.getSelectedIndex() == 0 || this.displayChooser.getSelectedIndex() == 1 ? n6 : n6 * 2;
        n7 = this.magnitudesY + n6 / 2 + (int)d / 2;
        graphics2.setColor(this.gray2);
        graphics2.drawLine(0, n7, this.winSize.width, n7);
        graphics2.setColor(this.gray1);
        graphics2.drawLine(0, n7 - (int)d, this.winSize.width, n7 - (int)d);
        graphics2.drawLine(0, n7 + (int)d, this.winSize.width, n7 + (int)d);
        graphics2.drawLine(0, n7 - (int)d / 4, this.winSize.width, n7 - (int)d / 4);
        graphics2.drawLine(0, n7 + (int)d / 4, this.winSize.width, n7 + (int)d / 4);
        n3 = n4 - 3;
        if (n3 < 3) {
            n3 = 3;
        }
        n5 = 0;
        while (n5 != this.modeCount) {
            int n16 = n4 * n5 + n4 / 2;
            n = n7 - (int)(this.logcoef(dArray[n5]) * d);
            graphics2.setColor(n5 == this.selectedCoef ? Color.yellow : Color.white);
            graphics2.drawLine(n16, n7, n16, n);
            graphics2.fillOval(n16 - n3 / 2, n - n3 / 2, n3, n3);
            ++n5;
        }
        if (this.displayChooser.getSelectedIndex() == 0 || this.displayChooser.getSelectedIndex() == 1) {
            graphics2.setColor(Color.white);
            boolean bl2 = this.displayChooser.getSelectedIndex() == 1;
            d = 0.75 * (double)n8;
            n7 = n6 * 5 / 2;
            n5 = -2;
            while (n5 <= 2) {
                if (!bl2 || n5 != 1 && n5 != -1) {
                    graphics2.setColor(n5 == 0 ? this.gray2 : this.gray1);
                    graphics2.drawLine(0, n7 + n5 * (int)d / 2, this.winSize.width, n7 + n5 * (int)d / 2);
                }
                ++n5;
            }
            if (!bl2) {
                d /= Math.PI;
            }
            n5 = 0;
            while (n5 != this.modeCount) {
                double d4;
                n = n4 * n5 + n4 / 2;
                double d5 = d4 = bl2 ? dArray3[n5] : dArray2[n5];
                if (this.magcoef[n5] > -7.5E-4 && dArray[n5] < 7.5E-4) {
                    d4 = 0.0;
                }
                int n17 = n7 - (int)(d4 * d);
                graphics2.setColor(n5 == this.selectedCoef ? Color.yellow : Color.white);
                graphics2.drawLine(n, n7, n, n17);
                graphics2.fillOval(n - n3 / 2, n17 - n3 / 2, n3, n3);
                ++n5;
            }
        } else if (this.displayChooser.getSelectedIndex() == 2) {
            int n18 = (this.winSize.width - 25) / 3;
            n = (int)((double)n18 / Math.PI);
            n2 = n6;
            int n19 = 0;
            int n20 = -1;
            n5 = 0;
            while (n5 != this.modeCount) {
                if (dArray[n5] > 0.06 || dArray[n5] < -0.06) {
                    graphics2.setColor(this.gray2);
                    int n21 = n19 + n18 / 2;
                    int n22 = n2 + n / 2;
                    graphics2.drawLine(n19, n22, n19 + n18, n22);
                    graphics2.drawLine(n21, n2, n21, n2 + n);
                    graphics2.setColor(n5 == this.selectedCoef ? Color.yellow : Color.white);
                    graphics2.drawRect(n19, n2, n18, n);
                    int n23 = -1;
                    d = (double)n * 0.5 * dArray[n5];
                    int n24 = n9;
                    while (n24 <= n10) {
                        int n25 = n19 + n18 * n24 / this.sampleCount;
                        double d6 = this.modeTable[n24][n5] * dArray3[n5];
                        int n26 = n22 - (int)(d * d6);
                        if (n23 != -1) {
                            graphics2.drawLine(n23, n20, n25, n26);
                        }
                        n23 = n25;
                        n20 = n26;
                        ++n24;
                    }
                    if ((n19 += n18 + 10) + n18 > this.winSize.width) {
                        n19 = 0;
                        if ((n2 += n + 10) + n > n6 * 2) break;
                    }
                }
                ++n5;
            }
        }
        graphics.drawImage(this.dbimage, 0, 0, this);
        if (!this.stoppedCheck.getState() && !bl) {
            this.cv.repaint(this.pause);
        }
    }

    void drawPin(Graphics graphics, int n, int n2, double d) {
        int n3 = this.winSize.width * n / this.sampleCount;
        graphics.setColor(this.gray2);
        graphics.drawLine(n3, (int)((double)n2 - d), n3, (int)((double)n2 + d));
        graphics.setColor(Color.white);
        graphics.fillOval(n3 - 2, n2 - (int)(this.func[n] * d) - 2, 5, 5);
    }

    int getTermWidth() {
        int n = this.winSize.width / this.modeCount;
        int n2 = this.winSize.width / 30;
        if (n > n2) {
            n = n2;
        }
        return n &= 0xFFFFFFFE;
    }

    void getVelocities() {
        int n = 0;
        while (n != this.sampleCount) {
            double d = 0.0;
            int n2 = 0;
            while (n2 != this.modeCount) {
                d += this.magcoef[n2] * this.modeTable[n][n2] * Math.sin(this.phasecoef[n2]) * this.omega[n2];
                ++n2;
            }
            this.funci[n] = -d;
            ++n;
        }
    }

    void drawBarPiece(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.setup.getThickness();
        this.xpoints[0] = this.xpoints[3];
        this.ypoints[0] = this.ypoints[3];
        this.xpoints[1] = this.xpoints[2];
        this.ypoints[1] = this.ypoints[2];
        this.xpoints[2] = n;
        this.ypoints[2] = n2 - n5;
        this.xpoints[3] = n;
        this.ypoints[3] = n2 + n5;
        if (n3 != n4) {
            if (n5 == 0) {
                graphics.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[2], this.ypoints[2]);
            } else {
                graphics.fillPolygon(this.xpoints, this.ypoints, 4);
            }
        }
    }

    void edit(MouseEvent mouseEvent) {
        if (this.selection == 0) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        switch (this.selection) {
            case 2: {
                this.editMag(n, n2);
                break;
            }
            case 1: {
                this.editFunc(n, n2);
            }
        }
    }

    void editMag(int n, int n2) {
        if (this.selectedCoef == -1) {
            return;
        }
        int n3 = this.getPanelHeight();
        double d = 0.6 * (double)n3 / 2.0;
        double d2 = this.magnitudesY + n3 / 2 + (int)d / 2;
        double d3 = -((double)n2 - d2) / d;
        if ((d3 = this.unlogcoef(d3)) < -1.0) {
            d3 = -1.0;
        }
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if (this.magcoef[this.selectedCoef] == d3) {
            return;
        }
        this.magcoef[this.selectedCoef] = d3;
        this.cv.repaint(this.pause);
    }

    void editFunc(int n, int n2) {
        if (this.modeChooser.getSelectedIndex() == 1) {
            this.editFuncForce(n, n2);
            return;
        }
        if (this.dragX == n) {
            this.editFuncPoint(n, n2);
            this.dragY = n2;
        } else {
            int n3 = n < this.dragX ? n : this.dragX;
            int n4 = n < this.dragX ? n2 : this.dragY;
            int n5 = n > this.dragX ? n : this.dragX;
            int n6 = n > this.dragX ? n2 : this.dragY;
            this.dragX = n;
            this.dragY = n2;
            n = n3;
            while (n <= n5) {
                n2 = n4 + (n6 - n4) * (n - n3) / (n5 - n3);
                this.editFuncPoint(n, n2);
                ++n;
            }
        }
    }

    double logcoef(double d) {
        double d2;
        if (d >= 0.25 || d <= -0.25) {
            return d;
        }
        int n = (d *= 4.0) < 0.0 ? -1 : 1;
        if ((d *= (double)n) < (d2 = 0.003)) {
            return 0.0;
        }
        if (this.logep2 == 0.0) {
            this.logep2 = -Math.log(2.0 * d2);
        }
        return 0.25 * (double)n * (Math.log(d + d2) + this.logep2) / this.logep2;
    }

    double unlogcoef(double d) {
        if (d >= 0.25 || d <= -0.25) {
            return d;
        }
        double d2 = 0.003;
        int n = d < 0.0 ? -1 : 1;
        return 0.25 * (double)n * (Math.exp(4.0 * d * (double)n * this.logep2 - this.logep2) - d2);
    }

    void editFuncPoint(int n, int n2) {
        int n3 = this.getPanelHeight();
        int n4 = n3 / 2;
        int n5 = n3 / 2;
        int n6 = this.winSize.width;
        double d = 0.75 * (double)n5;
        int n7 = n * this.sampleCount / n6;
        int n8 = ((n + 1) * this.sampleCount - 1) / n6;
        double d2 = (double)(n4 - n2) / d;
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if (d2 < -1.0) {
            d2 = -1.0;
        }
        if (n7 < 1) {
            n7 = 1;
        }
        if (n8 >= this.sampleCount) {
            n8 = this.sampleCount - 1;
        }
        while (n7 <= n8) {
            if (this.modeChooser.getSelectedIndex() == 2) {
                int n9 = this.thickness[n7] = n4 < n2 ? (n2 - n4) * 2 : (n4 - n2) * 2;
                if (this.thickness[n7] == 0) {
                    this.thickness[n7] = 1;
                }
            } else {
                this.func[n7] = d2;
                this.funci[n7] = 0.0;
            }
            ++n7;
        }
        this.func[this.sampleCount] = this.func[0];
        this.cv.repaint(this.pause);
        if (!this.soundCheck.getState()) {
            this.transform(false);
        }
    }

    void editFuncForce(int n, int n2) {
        double d;
        int n3 = this.getPanelHeight();
        int n4 = n3 / 2;
        int n5 = n3 / 2;
        int n6 = this.winSize.width;
        double d2 = 0.75 * (double)n5;
        int n7 = n * this.sampleCount / n6;
        double d3 = (double)(n4 - n2) / d2;
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if (d3 < -1.0) {
            d3 = -1.0;
        }
        if (n7 < 1 || n7 >= this.sampleCount) {
            return;
        }
        double[] dArray = new double[this.modeCount];
        int n8 = 0;
        while (n8 != this.modeCount) {
            dArray[n8] = this.modeTable[n7][n8] / (this.omega[n8] * this.omega[n8] * this.modeNorms[n8]);
            ++n8;
        }
        n8 = 0;
        while (n8 != this.sampleCount) {
            d = 0.0;
            int n9 = 0;
            while (n9 != this.modeCount) {
                d += dArray[n9] * this.modeTable[n8][n9];
                ++n9;
            }
            this.func[n8] = d;
            ++n8;
        }
        d = d3 / this.func[n7];
        n8 = 0;
        while (n8 <= this.sampleCount) {
            int n10 = n8;
            this.func[n10] = this.func[n10] * d;
            this.funci[n8] = 0.0;
            ++n8;
        }
        this.cv.repaint(this.pause);
        if (!this.soundCheck.getState()) {
            this.transform(true);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.cv.repaint(this.pause);
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.handleResize();
        this.cv.repaint(this.pause);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.sineButton) {
            this.doFundamental();
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.blankButton) {
            this.doBlank();
            this.cv.repaint();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        System.out.print(((Scrollbar)adjustmentEvent.getSource()).getValue() + "\n");
        if (adjustmentEvent.getSource() == this.dampingBar || adjustmentEvent.getSource() == this.speedBar) {
            this.setDamping();
        }
        if (adjustmentEvent.getSource() == this.loadBar) {
            this.setLoadCount();
        }
        if (adjustmentEvent.getSource() == this.stiffnessBar) {
            this.genModes();
        }
        this.cv.repaint(this.pause);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.applet.destroyFrame();
            return true;
        }
        return super.handleEvent(event);
    }

    void setLoadCount() {
        this.setup = (Setup)this.setupList.elementAt(this.setupChooser.getSelectedIndex());
        this.sampleCount = this.maxTerms = this.loadBar.getValue();
        this.step = Math.PI / (double)this.sampleCount;
        this.thickness = new int[this.sampleCount + 1];
        int n = 0;
        while (n <= this.sampleCount) {
            this.thickness[n] = 5;
            ++n;
        }
        this.genModes();
        this.setDamping();
    }

    void setDamping() {
        this.dampcoef = new double[this.modeCount];
        double d = Math.exp((double)(this.speedBar.getValue() - 100) / 20.0) * 0.002;
        int n = 0;
        while (n != this.modeCount) {
            double d2 = Math.exp(this.dampingBar.getValue() / 40 - 3) * 30.0;
            if (this.dampingBar.getValue() <= 2) {
                d2 = 0.0;
            }
            double d3 = this.omega[n] * Math.sqrt(Math.sqrt(1.0 + d2 * d2 / (this.omega[n] * this.omega[n])) - 1.0);
            this.dampcoef[n] = Math.exp(-d3 * d * 0.004);
            ++n;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dragging = true;
        this.edit(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.dragX = n;
        this.dragY = n2;
        int n3 = this.getPanelHeight();
        int n4 = this.selectedCoef;
        this.selectedCoef = -1;
        this.selection = 0;
        if (n2 < n3) {
            this.selection = 1;
        }
        if (n2 >= this.magnitudesY && n2 < this.magnitudesY + n3) {
            int n5 = this.getTermWidth();
            this.selectedCoef = n / n5;
            if (this.selectedCoef >= this.modeCount) {
                this.selectedCoef = -1;
            }
            if (this.selectedCoef != -1) {
                this.selection = 2;
            }
        }
        if (this.selectedCoef != n4) {
            this.cv.repaint(this.pause);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.selectedCoef != -1) {
            int n = 0;
            while (n != this.modeCount) {
                if (this.selectedCoef != n) {
                    this.magcoef[n] = 0.0;
                }
                ++n;
            }
            this.magcoef[this.selectedCoef] = 1.0;
            this.cv.repaint(this.pause);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.dragging && this.selectedCoef != -1) {
            this.selectedCoef = -1;
            this.cv.repaint(this.pause);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if (this.selection == 1) {
            this.getVelocities();
        }
        this.dragging = true;
        this.edit(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if (this.dragging && this.selection == 1) {
            if (this.modeChooser.getSelectedIndex() == 2) {
                this.genModes();
            } else {
                this.transform(false);
                if (this.soundCheck.getState()) {
                    this.doPlay();
                }
            }
        }
        if (this.dragging && this.selection == 2 && this.soundCheck.getState()) {
            this.doPlay();
        }
        this.dragging = false;
        this.cv.repaint(this.pause);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.stoppedCheck) {
            this.cv.repaint(this.pause);
            return;
        }
        if (itemEvent.getItemSelectable() == this.soundCheck) {
            if (this.soundCheck.getState()) {
                this.speedBar.setValue(250);
                this.dampingBar.setValue(170);
                this.baseFreqBar.enable();
                this.setDamping();
                this.doPlay();
            } else {
                this.baseFreqBar.disable();
            }
        }
        if (itemEvent.getItemSelectable() == this.displayChooser) {
            this.cv.repaint(this.pause);
        }
        if (itemEvent.getItemSelectable() == this.setupChooser) {
            this.setLoadCount();
            if (this.setup instanceof StiffStringSetup) {
                this.stiffnessBar.enable();
            } else {
                this.stiffnessBar.disable();
            }
        }
    }

    void dodiff(double[][] dArray, int n, int n2, int n3, double d) {
        if (n2 < 1 && this.setup.leftBoundary() == 0) {
            return;
        }
        if (n2 > this.sampleCount - 1 && this.setup.rightBoundary() == 0) {
            return;
        }
        if (n3 == 2 && !(this.setup instanceof StringSetup)) {
            if (n2 <= 1 && this.setup.leftBoundary() == 1) {
                return;
            }
            if (n2 >= this.sampleCount - 1 && this.setup.rightBoundary() == 1) {
                return;
            }
        }
        if (n3 > 0) {
            this.dodiff(dArray, n, n2 - 1, n3 - 2, -d);
            this.dodiff(dArray, n, n2 + 1, n3 - 2, -d);
            this.dodiff(dArray, n, n2, n3 - 2, d * 2.0);
            return;
        }
        if (n2 >= 1 && n2 <= this.sampleCount - 1) {
            double[] dArray2 = dArray[n];
            int n4 = n2;
            dArray2[n4] = dArray2[n4] + d;
        }
    }

    void genModes() {
        double d;
        int n = this.sampleCount - 1;
        double[][] dArray = new double[n + 1][n + 1];
        double[] dArray2 = new double[n + 1];
        double[] dArray3 = new double[n + 1];
        int n2 = 1;
        while (n2 <= n) {
            this.setup.doMatrixStep(dArray, n2, n);
            ++n2;
        }
        if (this.setup instanceof StringSetup) {
            if (this.setup.leftBoundary() == 1) {
                double[] dArray4 = dArray[1];
                dArray4[1] = dArray4[1] - 1.0;
            }
            if (this.setup.rightBoundary() == 1) {
                double[] dArray5 = dArray[n];
                int n3 = n;
                dArray5[n3] = dArray5[n3] - 1.0;
            }
        }
        this.tred2(dArray, n, dArray2, dArray3);
        this.tqli(dArray2, dArray3, n, dArray);
        this.modeCount = this.sampleCount - 1;
        this.omega = new double[this.modeCount];
        int[] nArray = new int[this.sampleCount];
        int n4 = 0;
        n2 = 0;
        while (n2 != n) {
            if (dArray2[n2 + 1] < 1.0E-8) {
                --this.modeCount;
            } else {
                this.omega[n4] = Math.sqrt(dArray2[n2 + 1]);
                nArray[n4] = n2;
                ++n4;
            }
            ++n2;
        }
        int n5 = 1;
        while (n5 < this.modeCount) {
            d = this.omega[n5];
            int n6 = nArray[n5];
            int n7 = n5;
            while (this.omega[n7 - 1] > d) {
                this.omega[n7] = this.omega[n7 - 1];
                nArray[n7] = nArray[n7 - 1];
                if (--n7 <= 0) break;
            }
            this.omega[n7] = d;
            nArray[n7] = n6;
            ++n5;
        }
        this.modeTable = new double[this.sampleCount + 1][this.modeCount];
        this.modeNorms = new double[this.modeCount];
        n2 = 0;
        while (n2 != this.modeCount) {
            int n8 = nArray[n2] + 1;
            double d2 = 0.0;
            n4 = 0;
            while (n4 != this.sampleCount) {
                this.modeTable[n4][n2] = dArray[n4][n8];
                if (this.modeTable[n4][n2] > d2) {
                    d2 = this.modeTable[n4][n2];
                }
                if (-this.modeTable[n4][n2] > d2) {
                    d2 = -this.modeTable[n4][n2];
                }
                ++n4;
            }
            this.modeNorms[n2] = 1.0 / (d2 * d2);
            n4 = 0;
            while (n4 != this.sampleCount) {
                double[] dArray6 = this.modeTable[n4];
                int n9 = n2;
                dArray6[n9] = dArray6[n9] / d2;
                ++n4;
            }
            ++n2;
        }
        d = 1.0 / this.omega[0];
        n2 = 0;
        while (n2 != this.modeCount) {
            int n10 = n2++;
            this.omega[n10] = this.omega[n10] * d;
        }
    }

    void tred2(double[][] dArray, int n, double[] dArray2, double[] dArray3) {
        int n2;
        double d;
        int n3;
        int n4;
        int n5 = n;
        while (n5 >= 2) {
            n4 = n5 - 1;
            double d2 = 0.0;
            double d3 = 0.0;
            if (n4 > 1) {
                n3 = 1;
                while (n3 <= n4) {
                    d2 += Math.abs(dArray[n5][n3]);
                    ++n3;
                }
                if (d2 == 0.0) {
                    dArray3[n5] = dArray[n5][n4];
                } else {
                    n3 = 1;
                    while (n3 <= n4) {
                        double[] dArray4 = dArray[n5];
                        int n6 = n3;
                        dArray4[n6] = dArray4[n6] / d2;
                        d3 += dArray[n5][n3] * dArray[n5][n3];
                        ++n3;
                    }
                    double d4 = dArray[n5][n4];
                    d = d4 >= 0.0 ? -Math.sqrt(d3) : Math.sqrt(d3);
                    dArray3[n5] = d2 * d;
                    d3 -= d4 * d;
                    dArray[n5][n4] = d4 - d;
                    d4 = 0.0;
                    n2 = 1;
                    while (n2 <= n4) {
                        dArray[n2][n5] = dArray[n5][n2] / d3;
                        d = 0.0;
                        n3 = 1;
                        while (n3 <= n2) {
                            d += dArray[n2][n3] * dArray[n5][n3];
                            ++n3;
                        }
                        n3 = n2 + 1;
                        while (n3 <= n4) {
                            d += dArray[n3][n2] * dArray[n5][n3];
                            ++n3;
                        }
                        dArray3[n2] = d / d3;
                        d4 += dArray3[n2] * dArray[n5][n2];
                        ++n2;
                    }
                    double d5 = d4 / (d3 + d3);
                    n2 = 1;
                    while (n2 <= n4) {
                        d4 = dArray[n5][n2];
                        dArray3[n2] = d = dArray3[n2] - d5 * d4;
                        n3 = 1;
                        while (n3 <= n2) {
                            double[] dArray5 = dArray[n2];
                            int n7 = n3;
                            dArray5[n7] = dArray5[n7] - (d4 * dArray3[n3] + d * dArray[n5][n3]);
                            ++n3;
                        }
                        ++n2;
                    }
                }
            } else {
                dArray3[n5] = dArray[n5][n4];
            }
            dArray2[n5] = d3;
            --n5;
        }
        dArray2[1] = 0.0;
        dArray3[1] = 0.0;
        n5 = 1;
        while (n5 <= n) {
            n4 = n5 - 1;
            if (dArray2[n5] != 0.0) {
                n2 = 1;
                while (n2 <= n4) {
                    d = 0.0;
                    n3 = 1;
                    while (n3 <= n4) {
                        d += dArray[n5][n3] * dArray[n3][n2];
                        ++n3;
                    }
                    n3 = 1;
                    while (n3 <= n4) {
                        double[] dArray6 = dArray[n3];
                        int n8 = n2;
                        dArray6[n8] = dArray6[n8] - d * dArray[n3][n5];
                        ++n3;
                    }
                    ++n2;
                }
            }
            dArray2[n5] = dArray[n5][n5];
            dArray[n5][n5] = 1.0;
            n2 = 1;
            while (n2 <= n4) {
                dArray[n5][n2] = 0.0;
                dArray[n2][n5] = 0.0;
                ++n2;
            }
            ++n5;
        }
    }

    void tqli(double[] dArray, double[] dArray2, int n, double[][] dArray3) {
        int n2 = 2;
        while (n2 <= n) {
            dArray2[n2 - 1] = dArray2[n2];
            ++n2;
        }
        dArray2[n] = 0.0;
        int n3 = 1;
        while (n3 <= n) {
            int n4;
            int n5 = 0;
            do {
                n4 = n3;
                while (n4 <= n - 1) {
                    double d = Math.abs(dArray[n4]) + Math.abs(dArray[n4 + 1]);
                    if (Math.abs(dArray2[n4]) + d == d) break;
                    ++n4;
                }
                if (n4 == n3) continue;
                if (n5++ == 30) {
                    System.out.print("Too many iterations in tqli\n");
                }
                double d = (dArray[n3 + 1] - dArray[n3]) / (2.0 * dArray2[n3]);
                double d2 = this.pythag(d, 1.0);
                d = dArray[n4] - dArray[n3] + dArray2[n3] / (d + this.SIGN(d2, d));
                double d3 = 1.0;
                double d4 = 1.0;
                double d5 = 0.0;
                n2 = n4 - 1;
                while (n2 >= n3) {
                    double d6 = d4 * dArray2[n2];
                    double d7 = d3 * dArray2[n2];
                    dArray2[n2 + 1] = d2 = this.pythag(d6, d);
                    if (d2 == 0.0) {
                        int n6 = n2 + 1;
                        dArray[n6] = dArray[n6] - d5;
                        dArray2[n4] = 0.0;
                        break;
                    }
                    d4 = d6 / d2;
                    d3 = d / d2;
                    d = dArray[n2 + 1] - d5;
                    d2 = (dArray[n2] - d) * d4 + 2.0 * d3 * d7;
                    d5 = d4 * d2;
                    dArray[n2 + 1] = d + d5;
                    d = d3 * d2 - d7;
                    int n7 = 1;
                    while (n7 <= n) {
                        d6 = dArray3[n7][n2 + 1];
                        dArray3[n7][n2 + 1] = d4 * dArray3[n7][n2] + d3 * d6;
                        dArray3[n7][n2] = d3 * dArray3[n7][n2] - d4 * d6;
                        ++n7;
                    }
                    --n2;
                }
                if (d2 == 0.0 && n2 >= n3) continue;
                int n8 = n3;
                dArray[n8] = dArray[n8] - d5;
                dArray2[n3] = d;
                dArray2[n4] = 0.0;
            } while (n4 != n3);
            ++n3;
        }
    }

    double SIGN(double d, double d2) {
        return d2 >= 0.0 ? Math.abs(d) : -Math.abs(d);
    }

    double SQR(double d) {
        return d * d;
    }

    double pythag(double d, double d2) {
        double d3;
        double d4 = Math.abs(d);
        if (d4 > (d3 = Math.abs(d2))) {
            return d4 * Math.sqrt(1.0 + this.SQR(d3 / d4));
        }
        return d3 == 0.0 ? 0.0 : d3 * Math.sqrt(1.0 + this.SQR(d4 / d3));
    }

    int getFreq(int n) {
        double d = Math.log(2.0) / 12.0;
        double d2 = Math.exp((double)this.baseFreqBar.getValue() * d);
        return (int)(d2 * this.omega[n]);
    }

    void doPlay() {
        byte[] byArray = new byte[8000];
        double d = Math.log(2.0) / 12.0;
        double d2 = Math.exp((double)this.baseFreqBar.getValue() * d);
        double d3 = Math.PI * 2 * d2 / 8000.0;
        double d4 = Math.PI / (d3 /= this.omega[0]);
        int n = this.modeCount;
        while (n > 0 && this.omega[n - 1] > d4) {
            --n;
        }
        if (n == 0) {
            return;
        }
        int n2 = 0;
        double d5 = 125.66370614359172 / (8000.0 * d3);
        while (n2 < n && this.omega[n2] < d5) {
            ++n2;
        }
        if (n2 == n) {
            return;
        }
        int n3 = 200;
        int n4 = 0;
        double d6 = 1000.0;
        double[] dArray = new double[this.modeCount];
        int n5 = 0;
        while (n5 != this.modeCount) {
            dArray[n5] = this.magcoef[n5];
            ++n5;
        }
        while (true) {
            double d7;
            double d8;
            boolean bl = false;
            double d9 = d8 = -this.sndmin > this.sndmax ? -this.sndmin : this.sndmax;
            if (d8 < 0.02) {
                d8 = 0.02;
            }
            if ((d7 = 126.0 / d8) > d6) {
                d7 = d6;
            }
            this.sndmax = 0.0;
            this.sndmin = 0.0;
            n5 = 0;
            while (n5 != n3) {
                double d10 = 0.0;
                int n6 = n5 + n4;
                int n7 = n2;
                while (n7 != n) {
                    d10 += dArray[n7] * Math.sin((double)n6 * d3 * this.omega[n7]) * d7;
                    ++n7;
                }
                if (d10 < this.sndmin) {
                    this.sndmin = d10;
                }
                if (d10 > this.sndmax) {
                    this.sndmax = d10;
                }
                if (d10 < -127.0 || d10 > 127.0) {
                    bl = true;
                } else {
                    byArray[n6] = (byte)to_ulaw[128 + (int)d10];
                }
                ++n5;
            }
            this.sndmin /= d7;
            this.sndmax /= d7;
            if (bl) continue;
            n4 += n3;
            n5 = 0;
            while (n5 != this.modeCount) {
                int n8 = n5;
                dArray[n8] = dArray[n8] * this.dampcoef[n5];
                ++n5;
            }
            if (n4 >= 8000) break;
        }
        AudioDataStream audioDataStream = new AudioDataStream(new AudioData(byArray));
        AudioPlayer.player.start((InputStream)audioDataStream);
        this.cv.repaint();
    }

    class StiffStringClampedSetup
    extends StiffStringSetup {
        StiffStringClampedSetup() {
        }

        String getName() {
            return "stiff string, clamped";
        }

        Setup createNext() {
            return null;
        }

        int leftBoundary() {
            return 2;
        }

        int rightBoundary() {
            return 2;
        }
    }

    class StiffStringSetup
    extends StringSetup {
        StiffStringSetup() {
        }

        String getName() {
            return "stiff string, pinned";
        }

        void doMatrixStep(double[][] dArray, int n, int n2) {
            BarWavesFrame.this.dodiff(dArray, n, n, 2, 1.0);
            double d = (double)BarWavesFrame.this.stiffnessBar.getValue() * 0.1;
            BarWavesFrame.this.dodiff(dArray, n, n, 4, d);
        }

        Setup createNext() {
            return new StiffStringClampedSetup();
        }
    }

    class String2FreeSetup
    extends String1FreeSetup {
        String2FreeSetup() {
        }

        String getName() {
            return "string, free/free";
        }

        Setup createNext() {
            return new StiffStringSetup();
        }

        int leftBoundary() {
            return 1;
        }
    }

    class String1FreeSetup
    extends StringSetup {
        String1FreeSetup() {
        }

        String getName() {
            return "string, pinned/free";
        }

        Setup createNext() {
            return new String2FreeSetup();
        }

        int rightBoundary() {
            return 1;
        }
    }

    class StringSetup
    extends Setup {
        StringSetup() {
        }

        String getName() {
            return "string, pinned";
        }

        void doMatrixStep(double[][] dArray, int n, int n2) {
            BarWavesFrame.this.dodiff(dArray, n, n, 2, 1.0);
        }

        Setup createNext() {
            return new String1FreeSetup();
        }

        int leftBoundary() {
            return 0;
        }

        int rightBoundary() {
            return 0;
        }

        int getThickness() {
            return 0;
        }
    }

    class HingedClampedBarSetup
    extends Setup {
        HingedClampedBarSetup() {
        }

        String getName() {
            return "bar, hinged/clamped";
        }

        Setup createNext() {
            return new StringSetup();
        }

        int leftBoundary() {
            return 0;
        }

        int rightBoundary() {
            return 2;
        }
    }

    class ClampedFreeBarSetup
    extends Setup {
        ClampedFreeBarSetup() {
        }

        String getName() {
            return "bar, clamped/free";
        }

        Setup createNext() {
            return new HingedClampedBarSetup();
        }

        int leftBoundary() {
            return 2;
        }

        int rightBoundary() {
            return 1;
        }
    }

    class ClampedBarSetup
    extends Setup {
        ClampedBarSetup() {
        }

        String getName() {
            return "bar, clamped";
        }

        Setup createNext() {
            return new ClampedFreeBarSetup();
        }

        int leftBoundary() {
            return 2;
        }

        int rightBoundary() {
            return 2;
        }
    }

    class HingedBarSetup
    extends Setup {
        HingedBarSetup() {
        }

        String getName() {
            return "bar, hinged";
        }

        Setup createNext() {
            return new ClampedBarSetup();
        }

        int leftBoundary() {
            return 0;
        }

        int rightBoundary() {
            return 0;
        }
    }

    class FreeBarSetup
    extends Setup {
        FreeBarSetup() {
        }

        String getName() {
            return "bar, free";
        }

        Setup createNext() {
            return new HingedBarSetup();
        }

        int leftBoundary() {
            return 1;
        }

        int rightBoundary() {
            return 1;
        }
    }

    abstract class Setup {
        Setup() {
        }

        abstract String getName();

        abstract Setup createNext();

        abstract int leftBoundary();

        abstract int rightBoundary();

        int getThickness() {
            return 3;
        }

        void doMatrixStep(double[][] dArray, int n, int n2) {
            BarWavesFrame.this.dodiff(dArray, n, n, 4, 1.0);
        }
    }
}

