import java.awt.Button;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class P1 extends Frame implements ActionListener{

	private Button buscar, agregar, borrar, cambiar, salir;
	private TextField palabra, significado;
	private Label mensaje;
	private String fileName;
	
	private Diccionario diccionario;
	
	public P1(String fileName) throws IOException
	{
		this.fileName = fileName;
		this.setSize(500, 100);
		this.setLayout(new GridLayout(2,5));
		
		buscar = new Button("Buscar");
		agregar = new Button("Agregar");
		borrar = new Button("Borrar");
		cambiar = new Button("Cambiar");
		salir = new Button("Salir");
		palabra = new TextField("");
		significado = new TextField("");
		mensaje = new Label("");
		
		diccionario = new Diccionario();
		
		this.add(buscar);
		this.add(agregar);
		this.add(borrar);
		this.add(cambiar);
		this.add(salir);
		this.add(new Label("Palabra:"));
		this.add(palabra);
		this.add(new Label("Significado:"));
		this.add(significado);
		this.add(mensaje);
		
		buscar.addActionListener(this);
		agregar.addActionListener(this);
		borrar.addActionListener(this);
		cambiar.addActionListener(this);
		salir.addActionListener(this);
		
		BufferedReader a = new BufferedReader(new FileReader(this.fileName));
		for(String linea = a.readLine(); linea != null; linea = a.readLine())
		{
			diccionario.agregar(linea.substring(0, linea.indexOf(':')),
								linea.substring(linea.indexOf(':') + 1));
		}
		a.close();
	}
	
	public static void main(String[] args) throws IOException
	{
		new P1(args[0]).setVisible(true);
	}

	public void actionPerformed(ActionEvent x)
	{
		String resultadoBusqueda;
		mensaje.setText("");
		if (x.getSource() == buscar)
		{
			if ((resultadoBusqueda = diccionario.buscar(palabra.getText())) != null)
			{
				significado.setText(resultadoBusqueda);
				mensaje.setText("Encontrada");
			}
			else
			{
				mensaje.setText("No existe");
			}
		}
		else if (x.getSource() == agregar)
		{
			if(diccionario.agregar(palabra.getText(), significado.getText()))
			{
				mensaje.setText("Agregada");
			}
			else
			{
				mensaje.setText("Ya existe");
			}
		}
		else if (x.getSource() == borrar)
		{
			if(diccionario.borrar(palabra.getText()))
			{
				mensaje.setText("Borrada");
			}
			else
			{
				mensaje.setText("No existe");
			}
		}
		else if (x.getSource() == cambiar)
		{
			if(diccionario.cambiar(palabra.getText(), significado.getText()))
			{
				mensaje.setText("Cambiada");
			}
			else
			{
				mensaje.setText("No existe");
			}
		}
		else if (x.getSource() == salir)
		{
			System.exit(0);
		}
	}

}
