public class Diccionario {

	private static final int N=100;
	private int n;
	private Registro[] registros;
	
	public Diccionario()
	{
		this.registros = new Registro[N];
		this.n = 0;
	}
	
	public String buscar(String palabra)
	{
		for (int i=0; i < this.n; ++i)
		{
			if(registros[i].palabra.equals(palabra))
			{
				return registros[i].significado;
			}
		}
		return null;
	}

	public boolean agregar(String palabra, String significado)
	{
		if(this.buscar(palabra) == null && (this.n < N))
		{
			registros[n++] = new Registro(palabra, significado);
			return true;
		}
		else
		{
			return false;
		}
	}

	public boolean borrar(String palabra)
	{
		for (int i=0; i < this.n; ++i)
		{
			if(registros[i].palabra.equals(palabra))
			{
				registros[i].palabra = registros[n-1].palabra;
				registros[i].significado = registros[n-1].significado;
				--n;
				return true;
			}
		}
		return false;
	}

	public boolean cambiar(String palabra, String significado)
	{
		for (int i=0; i < this.n; ++i)
		{
			if(registros[i].palabra.equals(palabra))
			{
				registros[i].significado = significado;
				return true;
			}
		}
		return false;
	}
}