public class Cadena
{

	protected char[]c;
	
	public Cadena(char[]x)
	{
		int n = x.length;
		this.c = new char[n];
		for(int i=0; i<n; ++i)
		{
			this.c[i]=x[i];
		}
	} 
	
	public Cadena(Cadena x)
	{
		this(x.c);
	}
	
	public Cadena(String x)
	{
		int largoX = x.length();
		if(x != null && largoX != 0)
		{
			this.c = new char[largoX];
			for (int i=0; i<largoX; ++i)
			{
				c[i] = x.charAt(i);
			}
		}
		else
		{
			U.println("String nulo o \"\"");
			System.exit(0);
		}
	}
	
	public int length()
	{
		return c.length;
	}
	
	public char charAt(int x)
	{
		return c[x];
	}
	
	public boolean equals(Cadena x)
	{
		int n = c.length;
		if(n != x.c.length)
		{
			return false;
		}
		for(int i=0; i<n; ++i)
		{
			if(c[i] != x.c[i])
			{
				return false;
			}
		}
		return true;
	}
	
	public int compareTo(Cadena x)
	{
		int min = Math.min(c.length, x.c.length);
		for(int i=0; i<min; ++i)
		{
			if(c[i] != x.c[i])
			{
				return c[i]-x.c[i];
			}
		}
		return c.length - x.c.length;
	}
	
	public String toString()
	{
		String s = "";
		for(int i=0;i<c.length; ++i)
		{
			s += c[i];
		}
		return s;
	}
	
	public Cadena subCadena(int x,int y)
	{
		Cadena s = new Cadena(new char[y-x]);
		for(int i=x; i<y; ++i)
		{
			s.c[i-x]=c[i];
		}
		return s;
	}
	
	public static void main(String[] args)
	{
		char[] caracteres = {'h', 'o', 'l', 'a', 'm', 'u', 'n', 'd', 'o'};
		Cadena cadenaArregloChar = new Cadena(caracteres);
		Cadena cadenaCadena = new Cadena(cadenaArregloChar);
		Cadena cadenaString = new Cadena("holamundo");
		U.println(cadenaArregloChar.subCadena(0, 4).toString() +
					" " +
					cadenaArregloChar.subCadena(4, 9).toString() +
					"!");
		U.println(cadenaCadena.subCadena(0, 4).toString() +
				" " +
				cadenaCadena.subCadena(4, 9).toString() +
				"!");
		U.println(cadenaString.subCadena(0, 4).toString() +
				" " +
				cadenaString.subCadena(4, 9).toString() +
				"!");
	}
}