/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Random;

class CircOscFrame
extends Frame
implements ComponentListener,
ActionListener,
AdjustmentListener,
MouseMotionListener,
MouseListener,
ItemListener {
    Thread engine = null;
    Dimension winSize;
    Image dbimage;
    Random random;
    int maxSampleCount = 36;
    int sampleCountR;
    int sampleCountTh;
    int modeCountR;
    int modeCountTh;
    public static final double epsilon = 1.0E-5;
    public static final double epsilon2 = 0.003;
    Button sineButton;
    Button blankButton;
    Checkbox stoppedCheck;
    Checkbox soundCheck;
    Checkbox freqCheck;
    Choice modeChooser;
    Choice displayChooser;
    Choice display2Chooser;
    Checkbox colorCheck;
    Scrollbar dampingBar;
    Scrollbar brightnessBar;
    Scrollbar speedBar;
    Scrollbar forceBar;
    Scrollbar loadBar;
    Scrollbar baseFreqBar;
    Rectangle view3d;
    Rectangle view2d;
    Rectangle viewFreq;
    boolean editingFunc;
    boolean dragStop;
    double[][] magcoef;
    double[][] dampcoef;
    double[][] phasecoef;
    double[][] phasecoefcos;
    double[][] phasecoefadj;
    double[] xformbuf;
    double[][] omega;
    static final double pi = Math.PI;
    double step;
    double[][] func;
    double[][] funci;
    int[] xpoints;
    int[] ypoints;
    double[][][] modeFuncs;
    double[][] angleFuncs;
    int selectedCoefX;
    int selectedCoefY;
    double selectedGridX;
    double selectedGridY;
    static final int SEL_NONE = 0;
    static final int SEL_FUNC_3D = 1;
    static final int SEL_FUNC_2D = 2;
    static final int SEL_MAG = 3;
    static final int MODE_PLUCK = 0;
    static final int MODE_STRIKE = 1;
    static final int MODE_VIEW_ROTATE = 2;
    static final int MODE_VIEW_ZOOM = 3;
    static final int DISP_3D_2D = 0;
    static final int DISP_3D = 1;
    static final int DISP_2D = 2;
    static final int DISP2_SOLID = 0;
    static final int DISP2_WIRE_XY = 1;
    static final int DISP2_WIRE_X = 2;
    static final int DISP2_WIRE_Y = 3;
    static final int COLOR_HEIGHT = 0;
    static final int COLOR_VEL = 1;
    static final int COLOR_NONE = 2;
    int selection;
    int dragX;
    int dragY;
    int dragStartX;
    int dragStartY;
    boolean dragSet;
    boolean dragClear;
    double viewAngle;
    double viewAngleDragStart;
    double viewZoom = 1.0;
    double viewZoomDragStart;
    double scaleHeight = 6.0;
    double viewAngleCos = 1.0;
    double viewAngleSin = 0.0;
    double viewHeight = -14.0;
    double viewHeightDragStart;
    double viewDistance;
    double magDragStart;
    boolean dragging;
    double t;
    int pause;
    double scalex;
    double scaley;
    int centerX3d;
    int centerY3d;
    double topz = 3.0;
    CircOscCanvas cv;
    CircOsc applet;
    int[] displayOrder;
    double logep2 = 0.0;

    public String getAppletInfo() {
        return "CircOsc Series by Paul Falstad";
    }

    int getrand(int n) {
        int n2 = this.random.nextInt();
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2 % n;
    }

    CircOscFrame(CircOsc circOsc) {
        super("Circular Membrane Applet");
        this.applet = circOsc;
    }

    public void init() {
        this.selectedCoefY = -1;
        this.selectedCoefX = -1;
        this.setLayout(new CircOscLayout());
        this.cv = new CircOscCanvas(this);
        this.cv.addComponentListener(this);
        this.cv.addMouseMotionListener(this);
        this.cv.addMouseListener(this);
        this.add(this.cv);
        this.sineButton = new Button("Fundamental");
        this.add(this.sineButton);
        this.sineButton.addActionListener(this);
        this.blankButton = new Button("Clear");
        this.add(this.blankButton);
        this.blankButton.addActionListener(this);
        this.stoppedCheck = new Checkbox("Stopped");
        this.stoppedCheck.addItemListener(this);
        this.add(this.stoppedCheck);
        this.freqCheck = new Checkbox("Show Frequencies", true);
        this.freqCheck.addItemListener(this);
        this.add(this.freqCheck);
        this.colorCheck = new Checkbox("Color", true);
        this.colorCheck.addItemListener(this);
        this.add(this.colorCheck);
        this.soundCheck = new Checkbox("Sound", false);
        this.soundCheck.addItemListener(this);
        this.add(this.soundCheck);
        this.soundCheck.disable();
        this.modeChooser = new Choice();
        this.modeChooser.add("Mouse = Poke membrane");
        this.modeChooser.add("Mouse = Strike membrane");
        this.modeChooser.add("Mouse = Adjust view angle");
        this.modeChooser.add("Mouse = Adjust view zoom");
        this.modeChooser.addItemListener(this);
        this.add(this.modeChooser);
        this.modeChooser.select(2);
        this.displayChooser = new Choice();
        this.displayChooser.add("Display 3d+2d");
        this.displayChooser.add("Display 3d only");
        this.displayChooser.add("Display 2d only");
        this.displayChooser.addItemListener(this);
        this.add(this.displayChooser);
        this.displayChooser.select(1);
        this.display2Chooser = new Choice();
        this.display2Chooser.add("3d view = Solid");
        this.display2Chooser.add("3d view = Wireframe");
        this.display2Chooser.add("3d view = Wireframe th");
        this.display2Chooser.add("3d view = Wireframe r");
        this.display2Chooser.addItemListener(this);
        this.add(this.display2Chooser);
        this.add(new Label("Simulation Speed", 1));
        this.speedBar = new Scrollbar(0, 20, 1, 1, 200);
        this.add(this.speedBar);
        this.speedBar.addAdjustmentListener(this);
        this.add(new Label("Damping", 1));
        this.dampingBar = new Scrollbar(0, 0, 5, 0, 100);
        this.add(this.dampingBar);
        this.dampingBar.addAdjustmentListener(this);
        this.add(new Label("Brightness", 1));
        this.brightnessBar = new Scrollbar(0, 10, 1, 0, 100);
        this.add(this.brightnessBar);
        this.brightnessBar.addAdjustmentListener(this);
        this.add(new Label("Resolution", 1));
        this.loadBar = new Scrollbar(0, 5, 1, 2, this.maxSampleCount / 2);
        this.add(this.loadBar);
        this.loadBar.addAdjustmentListener(this);
        this.add(new Label("Base Frequency", 1));
        this.baseFreqBar = new Scrollbar(0, 44, 1, 10, 100);
        this.add(this.baseFreqBar);
        this.baseFreqBar.addAdjustmentListener(this);
        this.baseFreqBar.disable();
        this.setLoadCount();
        try {
            String string = this.applet.getParameter("PAUSE");
            if (string != null) {
                this.pause = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.random = new Random();
        this.setDamping();
        this.reinit();
        this.cv.setBackground(Color.black);
        this.cv.setForeground(Color.lightGray);
        this.resize(500, 500);
        this.handleResize();
        this.show();
    }

    void reinit() {
        this.doSine();
    }

    void handleResize() {
        Dimension dimension = this.winSize = this.cv.getSize();
        if (this.winSize.width == 0) {
            return;
        }
        this.dbimage = this.createImage(dimension.width, dimension.height);
        this.setupDisplay();
    }

    void setupDisplay() {
        int n;
        this.viewFreq = null;
        this.view2d = null;
        this.view3d = null;
        this.displayOrder = null;
        switch (this.displayChooser.getSelectedIndex()) {
            case 1: {
                if (!this.freqCheck.getState()) {
                    this.view3d = new Rectangle(this.winSize);
                    break;
                }
                this.view3d = new Rectangle(0, 0, this.winSize.width, this.winSize.height / 2);
                this.viewFreq = new Rectangle(0, this.winSize.height / 2, this.winSize.width, this.winSize.height / 2);
                break;
            }
            case 2: {
                if (!this.freqCheck.getState()) {
                    this.view2d = new Rectangle(this.winSize);
                    break;
                }
                this.view2d = new Rectangle(0, 0, this.winSize.width, this.winSize.height / 2);
                this.viewFreq = new Rectangle(0, this.winSize.height / 2, this.winSize.width, this.winSize.height / 2);
                break;
            }
            default: {
                if (!this.freqCheck.getState()) {
                    this.view3d = new Rectangle(0, 0, this.winSize.width, this.winSize.height / 2);
                    this.view2d = new Rectangle(0, this.winSize.height / 2, this.winSize.width, this.winSize.height / 2);
                    break;
                }
                this.view3d = new Rectangle(0, 0, this.winSize.width / 2, this.winSize.height / 2);
                this.view2d = new Rectangle(this.winSize.width / 2, 0, this.winSize.width / 2, this.winSize.height / 2);
                this.viewFreq = new Rectangle(0, this.winSize.height / 2, this.winSize.width, this.winSize.height / 2);
            }
        }
        if (this.viewFreq != null) {
            this.viewFreq.x = (this.winSize.width - this.viewFreq.height) / 2;
            this.viewFreq.width -= this.viewFreq.x * 2;
            n = this.getTermWidth();
            int n2 = n * (this.modeCountR + 1);
            int n3 = this.viewFreq.height - n2;
            if (n3 > 0) {
                this.viewFreq.y += n3;
                this.viewFreq.height -= n3;
                if (this.view3d != null) {
                    this.view3d.height += n3;
                }
                if (this.view2d != null) {
                    this.view2d.height += n3;
                }
            }
        }
        if (this.view2d != null) {
            n = this.view2d.width < this.view2d.height ? this.view2d.width : this.view2d.height;
            this.view2d.x += (this.view2d.width - n) / 2;
            this.view2d.y += (this.view2d.height - n) / 2;
            this.view2d.width = n;
            this.view2d.height = n;
            this.brightnessBar.enable();
        } else {
            this.brightnessBar.disable();
        }
    }

    void doSine() {
        this.doBlank();
        this.magcoef[0][0] = 1.0;
        this.t = 0.0;
    }

    void doPluck(double d) {
        d *= 5.0;
        double d2 = Math.sqrt(this.selectedGridX * this.selectedGridX + this.selectedGridY * this.selectedGridY);
        double d3 = 1.0E8;
        double d4 = 0.0;
        double d5 = 1.0E8;
        if (d2 > 0.0) {
            d5 = d2 == 0.0 ? 1.0E8 : 1.0 / d2;
            d3 = this.selectedGridX * d5 / d2;
            d4 = this.selectedGridY * d5 / d2;
        }
        double d6 = Math.log(1.0 - d2) - Math.log(d5 - 1.0);
        double d7 = 1.0E-4;
        double d8 = d / (Math.log(d7) - Math.log(d5 + d7) - d6);
        int n = 0;
        while (n != this.sampleCountR) {
            int n2 = 0;
            while (n2 != this.sampleCountTh) {
                double d9;
                double d10 = (double)(n2 * 2) * Math.PI / (double)this.sampleCountTh - this.viewAngle;
                double d11 = -Math.cos(d10) * (double)n / (double)this.sampleCountR;
                double d12 = -Math.sin(d10) * (double)n / (double)this.sampleCountR;
                double d13 = d11 - this.selectedGridX;
                double d14 = d11 - d3;
                double d15 = d12 - this.selectedGridY;
                double d16 = d12 - d4;
                double d17 = Math.sqrt(d15 * d15 + d13 * d13);
                double d18 = Math.sqrt(d16 * d16 + d14 * d14);
                this.func[n2][n] = d9 = (Math.log(d17 + d7) - Math.log(d18 + d7) - d6) * d8;
                ++n2;
            }
            ++n;
        }
        this.transform();
        this.cv.repaint(this.pause);
    }

    void transform() {
        int n;
        this.t = 0.0;
        int n2 = 0;
        while (n2 != this.modeCountTh) {
            n = 0;
            while (n != this.modeCountR) {
                this.phasecoef[n2][n] = 0.0;
                this.magcoef[n2][n] = 0.0;
                ++n;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 <= this.sampleCountR) {
            int n4 = 0;
            while (n4 != this.sampleCountTh * 2) {
                this.xformbuf[n4] = 0.0;
                ++n4;
            }
            n4 = 0;
            while (n4 != this.sampleCountTh) {
                this.xformbuf[n4 * 2] = this.func[n4][n3] * (double)n3;
                ++n4;
            }
            this.four1(this.xformbuf, this.sampleCountTh, -1);
            n = 0;
            while (n != this.modeCountR) {
                double[] dArray = this.magcoef[0];
                int n5 = n;
                dArray[n5] = dArray[n5] + this.modeFuncs[0][n][n3] * this.xformbuf[0];
                double[] dArray2 = this.phasecoef[0];
                int n6 = n;
                dArray2[n6] = dArray2[n6] + this.modeFuncs[0][n][n3] * this.modeFuncs[0][n][n3] * (double)n3 * (double)this.sampleCountTh;
                ++n;
            }
            int n7 = this.sampleCountTh * 2;
            int n8 = n7 - 1;
            n2 = 1;
            while (n2 < this.modeCountTh) {
                n = 0;
                while (n != this.modeCountR) {
                    int n9 = n2 + 1;
                    double[] dArray = this.magcoef[n2];
                    int n10 = n;
                    dArray[n10] = dArray[n10] + this.modeFuncs[n2][n][n3] * 0.5 * (this.xformbuf[n9] + this.xformbuf[n8 & -n9]);
                    double[] dArray3 = this.magcoef[n2 + 1];
                    int n11 = n;
                    dArray3[n11] = dArray3[n11] - this.modeFuncs[n2][n][n3] * 0.5 * (this.xformbuf[n9 + 1] - this.xformbuf[n8 & -n9 + 1]);
                    double[] dArray4 = this.phasecoef[n2];
                    int n12 = n;
                    dArray4[n12] = dArray4[n12] + this.modeFuncs[n2][n][n3] * this.modeFuncs[n2][n][n3] * (double)n3 * (double)this.sampleCountTh * 0.5;
                    this.phasecoef[n2 + 1][n] = this.phasecoef[n2][n];
                    ++n;
                }
                n2 += 2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 != this.modeCountTh) {
            n = 0;
            while (n != this.modeCountR) {
                double[] dArray = this.magcoef[n2];
                int n13 = n;
                dArray[n13] = dArray[n13] / this.phasecoef[n2][n];
                this.phasecoefadj[n2][n] = 0.0;
                this.phasecoef[0][n] = 0.0;
                ++n;
            }
            ++n2;
        }
    }

    void doStrike(double d) {
        d *= 10.0;
        double d2 = 0.2;
        int n = 0;
        while (n != this.sampleCountR) {
            int n2 = 0;
            while (n2 != this.sampleCountTh) {
                double d3 = (double)(n2 * 2) * Math.PI / (double)this.sampleCountTh - this.viewAngle;
                double d4 = -Math.cos(d3) * (double)n / (double)this.sampleCountR - this.selectedGridX;
                double d5 = -Math.sin(d3) * (double)n / (double)this.sampleCountR - this.selectedGridY;
                double d6 = Math.sqrt(d5 * d5 + d4 * d4);
                double d7 = 0.0;
                if (d6 < d2) {
                    d7 = d * (d2 - d6);
                }
                this.func[n2][n] = d7;
                ++n2;
            }
            ++n;
        }
        this.transform();
        this.cv.repaint(this.pause);
    }

    void doBlank() {
        int n = 0;
        while (n != this.modeCountTh) {
            int n2 = 0;
            while (n2 != this.modeCountR) {
                this.magcoef[n][n2] = 0.0;
                ++n2;
            }
            ++n;
        }
    }

    int getPanelHeight() {
        return this.winSize.height / 3;
    }

    void centerString(Graphics graphics, String string, int n) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, (this.winSize.width - fontMetrics.stringWidth(string)) / 2, n);
    }

    public void paint(Graphics graphics) {
        this.cv.repaint();
    }

    public void updateCircOsc(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        double d;
        double d2;
        int n6;
        int n7;
        int n8;
        Graphics graphics2 = this.dbimage.getGraphics();
        if (this.winSize == null || this.winSize.width == 0 || this.dbimage == null) {
            return;
        }
        boolean bl = true;
        if (!this.stoppedCheck.getState()) {
            int n9 = this.speedBar.getValue();
            double d3 = (double)n9 * 0.00625;
            this.t += (d3 += (double)(n9 * this.getrand(20)) * 2.7279275E-5);
            bl = false;
        }
        Color color = new Color(76, 76, 76);
        Color color2 = new Color(127, 127, 127);
        graphics2.setColor(this.cv.getBackground());
        graphics2.fillRect(0, 0, this.winSize.width, this.winSize.height);
        graphics2.setColor(this.cv.getForeground());
        if (this.dragStop) {
            this.t = 0.0;
        }
        int n10 = 0;
        while (n10 != this.modeCountTh) {
            n8 = 0;
            while (n8 != this.modeCountR) {
                if (this.magcoef[n10][n8] < 1.0E-5 && this.magcoef[n10][n8] > -1.0E-5) {
                    this.phasecoefadj[n10][n8] = 0.0;
                    this.phasecoef[n10][n8] = 0.0;
                    this.magcoef[n10][n8] = 0.0;
                } else {
                    double[] dArray = this.magcoef[n10];
                    int n11 = n8;
                    dArray[n11] = dArray[n11] * this.dampcoef[n10][n8];
                    this.phasecoef[n10][n8] = (this.omega[n10][n8] * this.t + this.phasecoefadj[n10][n8]) % (Math.PI * 2);
                    this.phasecoefcos[n10][n8] = Math.cos(this.phasecoef[n10][n8]);
                }
                ++n8;
            }
            ++n10;
        }
        this.genFunc();
        double d4 = (double)this.brightnessBar.getValue() / 10.0;
        int n12 = this.sampleCountTh / 2;
        if (this.view3d != null) {
            this.scaleworld();
            if (this.display2Chooser.getSelectedIndex() == 0) {
                this.xpoints = new int[4];
                this.ypoints = new int[4];
                if (this.displayOrder == null) {
                    this.displayOrder = this.getDisplayOrder();
                }
                int n13 = this.sampleCountR * this.sampleCountTh;
                n10 = 0;
                while (n10 != n13) {
                    int n14 = this.displayOrder[n10];
                    n7 = n14 % this.sampleCountTh;
                    n6 = n14 / this.sampleCountTh;
                    this.map3d(n7 - n12, n6, this.func[n7][n6], this.xpoints, this.ypoints, 0);
                    this.map3d(n7 + 1 - n12, n6, this.func[n7 + 1][n6], this.xpoints, this.ypoints, 1);
                    this.map3d(n7 - n12, n6 + 1, this.func[n7][n6 + 1], this.xpoints, this.ypoints, 3);
                    this.map3d(n7 + 1 - n12, n6 + 1, this.func[n7 + 1][n6 + 1], this.xpoints, this.ypoints, 2);
                    double d5 = this.func[n7 + 1][n6] - this.func[n7][n6];
                    d2 = this.func[n7][n6 + 1] - this.func[n7][n6];
                    d = (d5 + d2 + 1.0) * 0.5780346820809249 / Math.sqrt(d5 * d5 + d2 * d2 + 1.0);
                    graphics2.setColor(this.computeColor(n7, n6, d));
                    graphics2.fillPolygon(this.xpoints, this.ypoints, 4);
                    ++n10;
                }
            } else {
                n5 = this.display2Chooser.getSelectedIndex() != 3 ? 1 : 0;
                n4 = this.display2Chooser.getSelectedIndex() != 2 ? 1 : 0;
                n6 = 0;
                while (n6 <= this.sampleCountR) {
                    n7 = 0;
                    while (n7 <= this.sampleCountTh) {
                        graphics2.setColor(this.computeColor(n7, n6, 0.0));
                        this.map3d(n7 - n12, n6, this.func[n7][n6], this.xpoints, this.ypoints, 0);
                        if (n7 < this.sampleCountTh && n5 != 0) {
                            this.map3d(n7 + 1 - n12, n6, this.func[n7 + 1][n6], this.xpoints, this.ypoints, 1);
                            graphics2.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[1], this.ypoints[1]);
                        }
                        if (n6 < this.sampleCountR && n4 != 0) {
                            this.map3d(n7 - n12, n6 + 1, this.func[n7][n6 + 1], this.xpoints, this.ypoints, 2);
                            graphics2.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[2], this.ypoints[2]);
                        }
                        ++n7;
                    }
                    ++n6;
                }
            }
        }
        if (this.view2d != null) {
            n5 = 65536;
            n4 = 256;
            n3 = this.view2d.x + this.view2d.width / 2;
            n2 = this.view2d.y + this.view2d.height / 2;
            n = this.view2d.width / 2;
            n6 = 0;
            while (n6 != this.sampleCountR) {
                double d6 = -n * n6 / this.sampleCountR;
                double d7 = -n * (n6 + 1) / this.sampleCountR;
                n7 = 0;
                while (n7 != this.sampleCountTh) {
                    int n15 = (int)(255.0 * d4 * this.func[n7][n6]);
                    if (n15 < -255) {
                        n15 = -255;
                    }
                    if (n15 > 255) {
                        n15 = 255;
                    }
                    if (n15 < 0) {
                        graphics2.setColor(new Color(-16777216 + n5 * -n15));
                    } else {
                        graphics2.setColor(new Color(-16777216 + n4 * n15));
                    }
                    d2 = Math.PI * 2 * (double)n7 / (double)this.sampleCountTh - this.viewAngle;
                    d = Math.PI * 2 * (double)(n7 + 1) / (double)this.sampleCountTh - this.viewAngle + 0.001;
                    this.xpoints[0] = (int)((double)n3 + d6 * Math.cos(d2));
                    this.ypoints[0] = (int)((double)n2 - d6 * Math.sin(d2));
                    this.xpoints[1] = (int)((double)n3 + d6 * Math.cos(d));
                    this.ypoints[1] = (int)((double)n2 - d6 * Math.sin(d));
                    this.xpoints[2] = (int)((double)n3 + d7 * Math.cos(d));
                    this.ypoints[2] = (int)((double)n2 - d7 * Math.sin(d));
                    this.xpoints[3] = (int)((double)n3 + d7 * Math.cos(d2));
                    this.ypoints[3] = (int)((double)n2 - d7 * Math.sin(d2));
                    graphics2.fillPolygon(this.xpoints, this.ypoints, 4);
                    ++n7;
                }
                ++n6;
            }
            graphics2.setColor(Color.white);
            graphics2.drawOval(this.view2d.x, this.view2d.y, this.view2d.width, this.view2d.height);
        }
        if (this.viewFreq != null) {
            n5 = this.getTermWidth();
            graphics2.setColor(Color.white);
            n10 = n4 = 0;
            while (n10 <= this.modeCountR) {
                n7 = n10 * n5;
                graphics2.drawLine(this.viewFreq.x + n4 * n5, n7 + this.viewFreq.y, this.viewFreq.x + n5 * this.modeCountTh, n7 + this.viewFreq.y);
                ++n10;
            }
            n10 = 0;
            while (n10 <= this.modeCountTh) {
                n7 = n10 * n5;
                graphics2.drawLine(this.viewFreq.x + n7, this.viewFreq.y + n4 * n5, this.viewFreq.x + n7, this.viewFreq.y + n5 * this.modeCountR);
                ++n10;
            }
            n3 = 65536;
            n2 = 256;
            n10 = n4;
            while (n10 != this.modeCountTh) {
                n8 = n4;
                while (n8 != this.modeCountR) {
                    n7 = this.viewFreq.x + n10 * n5;
                    n6 = this.viewFreq.y + n8 * n5;
                    n = this.logcoef(this.magcoef[n10][n8]);
                    if (n < -255) {
                        n = -255;
                    }
                    if (n > 255) {
                        n = 255;
                    }
                    if (n < 0) {
                        graphics2.setColor(new Color(-16777216 + n3 * -n));
                    } else {
                        graphics2.setColor(new Color(-16777216 + n2 * n));
                    }
                    graphics2.fillRect(n7 + 1, n6 + 1, n5 - 1, n5 - 1);
                    int n16 = (int)(this.phasecoefadj[n10][n8] * (double)n5 * 0.15915494309189535);
                    if (n16 > 0) {
                        graphics2.setColor(Color.blue);
                        graphics2.drawLine(n7 + n16, n6 + 1, n7 + n16, n6 + n5);
                    }
                    if (this.selectedCoefX != -1 && this.omega[this.selectedCoefX][this.selectedCoefY] == this.omega[n10][n8]) {
                        graphics2.setColor(Color.yellow);
                        graphics2.drawRect(n7, n6, n5, n5);
                    }
                    ++n8;
                }
                ++n10;
            }
        }
        graphics.drawImage(this.dbimage, 0, 0, this);
        if (this.dragStop) {
            bl = true;
        }
        if (!this.stoppedCheck.getState() && !bl) {
            this.cv.repaint(this.pause);
        }
    }

    Color computeColor(int n, int n2, double d) {
        double d2;
        double d3 = this.func[n][n2];
        if (!this.colorCheck.getState()) {
            d3 = 0.0;
            if (this.display2Chooser.getSelectedIndex() != 0) {
                return Color.white;
            }
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        d = 0.5 + d * 0.5;
        double d4 = d3 < 0.0 ? -d3 : 0.0;
        double d5 = d2 = d3 > 0.0 ? d3 : 0.0;
        if (d4 > 1.0) {
            d4 = 1.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d4 < 0.0) {
            d4 = 0.0;
        }
        double d6 = (1.0 - (d4 + d2)) * d;
        double d7 = 0.6;
        return new Color((int)((d * d4 + d7 * d6) * 255.0), (int)((d * d2 + d7 * d6) * 255.0), (int)(d7 * d6 * 255.0));
    }

    void genFunc() {
        int n = this.sampleCountTh * 2;
        int n2 = n - 1;
        int n3 = 0;
        while (n3 <= this.sampleCountR) {
            int n4 = 0;
            while (n4 != n) {
                this.xformbuf[n4] = 0.0;
                ++n4;
            }
            double d = 0.0;
            int n5 = 0;
            while (n5 != this.modeCountR) {
                d += this.modeFuncs[0][n5][n3] * this.magcoef[0][n5] * this.phasecoefcos[0][n5];
                ++n5;
            }
            this.xformbuf[0] = d;
            n4 = 1;
            while (n4 < this.modeCountTh) {
                double d2 = 0.0;
                double d3 = 0.0;
                int n6 = (n4 + 1) / 2;
                n5 = 0;
                while (n5 != this.modeCountR) {
                    d2 += this.modeFuncs[n4][n5][n3] * this.magcoef[n4][n5] * this.phasecoefcos[n4][n5];
                    d3 += this.modeFuncs[n4][n5][n3] * this.magcoef[n4 + 1][n5] * this.phasecoefcos[n4 + 1][n5];
                    ++n5;
                }
                this.xformbuf[n6 * 2] = 0.5 * d2;
                this.xformbuf[n2 & n - n6 * 2] = 0.5 * d2;
                this.xformbuf[n6 * 2 + 1] = -0.5 * d3;
                this.xformbuf[n2 & n - n6 * 2 + 1] = 0.5 * d3;
                n4 += 2;
            }
            this.four1(this.xformbuf, this.sampleCountTh, 1);
            n4 = 0;
            while (n4 != this.sampleCountTh) {
                this.func[n4][n3] = this.xformbuf[n4 * 2];
                ++n4;
            }
            this.func[this.sampleCountTh][n3] = this.func[0][n3];
            ++n3;
        }
    }

    int logcoef(double d) {
        double d2;
        int n;
        if ((d *= (double)(n = d < 0.0 ? -1 : 1)) < (d2 = 0.003)) {
            return 0;
        }
        if (this.logep2 == 0.0) {
            this.logep2 = -Math.log(2.0 * d2);
        }
        return (int)((double)(255 * n) * (Math.log(d + d2) + this.logep2) / this.logep2);
    }

    void map3d(double d, double d2, double d3, int[] nArray, int[] nArray2, int n) {
        double d4 = (d2 *= 16.0 / (double)this.sampleCountR) * Math.cos(d *= 2.0 * this.step);
        double d5 = d2 * Math.sin(d);
        double d6 = d4 * this.viewAngleCos + d5 * this.viewAngleSin;
        double d7 = (d3 *= -this.scaleHeight) - this.viewHeight;
        double d8 = d5 * this.viewAngleCos - d4 * this.viewAngleSin + this.viewDistance;
        nArray[n] = this.centerX3d + (int)(this.scalex * d6 / d8);
        nArray2[n] = this.centerY3d - (int)(this.scaley * d7 / d8);
    }

    void scaleworld() {
        this.scalex = this.viewZoom * (double)(this.view3d.width / 4) * this.viewDistance / 9.0;
        this.scaley = -this.scalex;
        int n = (int)(this.scaley * this.viewHeight / this.viewDistance);
        this.centerX3d = this.view3d.x + this.view3d.width / 2;
        this.centerY3d = this.view3d.y + this.view3d.height / 2 - n;
    }

    int getTermWidth() {
        int n = this.viewFreq.width / this.modeCountTh;
        int n2 = this.viewFreq.height / this.modeCountR;
        return n < n2 ? n : n2;
    }

    int[] getDisplayOrder() {
        int n = this.sampleCountTh * this.sampleCountR;
        int[] nArray = new int[n];
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 != n) {
            nArray[n2] = n2;
            int n3 = n2 % this.sampleCountTh;
            int n4 = n2 / this.sampleCountTh;
            double d = 2.0 * this.step * (double)n3;
            double d2 = (double)n4 * Math.cos(d);
            double d3 = (double)n4 * Math.sin(d);
            dArray[n2] = d3 * this.viewAngleCos - d2 * this.viewAngleSin;
            ++n2;
        }
        this.qsort(nArray, dArray, 0, n - 1);
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    void qsort(int[] var1_1, double[] var2_2, int var3_3, int var4_4) {
        block5: {
            var5_5 = var3_3;
            var6_6 = var4_4;
            if (var4_4 <= var3_3) break block5;
            var7_7 = (var3_3 + var4_4) / 2;
            var8_8 = var2_2[var1_1[var7_7]];
            ** GOTO lbl19
            {
                ++var5_5;
                do {
                    if (var5_5 < var4_4 && var2_2[var1_1[var5_5]] < var8_8) continue block0;
                    while (var6_6 > var3_3 && var2_2[var1_1[var6_6]] > var8_8) {
                        --var6_6;
                    }
                    if (var5_5 > var6_6) continue;
                    var10_9 = var1_1[var5_5];
                    var1_1[var5_5] = var1_1[var6_6];
                    var1_1[var6_6] = var10_9;
                    ++var5_5;
                    --var6_6;
lbl19:
                    // 3 sources

                } while (var5_5 <= var6_6);
            }
            if (var3_3 < var6_6) {
                this.qsort(var1_1, var2_2, var3_3, var6_6);
            }
            if (var5_5 < var4_4) {
                this.qsort(var1_1, var2_2, var5_5, var4_4);
            }
        }
    }

    void edit(MouseEvent mouseEvent) {
        if (this.selection == 0) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        switch (this.selection) {
            case 3: {
                this.editMag(n, n2);
                break;
            }
            case 2: {
                this.editFunc2D(n, n2);
                break;
            }
            case 1: {
                this.editFunc3D(n, n2);
            }
        }
    }

    void editMag(int n, int n2) {
        double d;
        if (this.selectedCoefX == -1) {
            return;
        }
        double d2 = (double)(this.dragStartY - n2) / 20.0 + this.magDragStart;
        if (d2 < -1.0) {
            d2 = -1.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if ((d = (double)(n - this.dragStartX) / 10.0) < 0.0) {
            d = 0.0;
        }
        if (d > Math.PI * 2) {
            d = Math.PI * 2;
        }
        if (this.magcoef[this.selectedCoefX][this.selectedCoefY] == d2 && this.phasecoefadj[this.selectedCoefX][this.selectedCoefY] == d) {
            return;
        }
        this.magcoef[this.selectedCoefX][this.selectedCoefY] = d2;
        this.phasecoefadj[this.selectedCoefX][this.selectedCoefY] = d;
        this.cv.repaint(this.pause);
    }

    int sign(int n) {
        return n < 0 ? -1 : (n == 0 ? 0 : 1);
    }

    int abs(int n) {
        return n < 0 ? -n : n;
    }

    void editMagClick() {
        if (this.selectedCoefX == -1) {
            return;
        }
        this.magcoef[this.selectedCoefX][this.selectedCoefY] = this.magDragStart < 0.5 ? 1.0 : 0.0;
        this.phasecoefadj[this.selectedCoefX][this.selectedCoefY] = 0.0;
        this.cv.repaint(this.pause);
    }

    void editFunc2D(int n, int n2) {
        this.findGridPoint2D(n, n2);
        this.dragStop = true;
        this.editingFunc = true;
        if (this.modeChooser.getSelectedIndex() == 1) {
            this.doStrike(1.0);
        } else {
            this.doPluck(1.0);
        }
    }

    void editFunc3D(int n, int n2) {
        if (this.modeChooser.getSelectedIndex() == 2) {
            this.viewAngle = (double)(this.dragStartX - n) / 40.0 + this.viewAngleDragStart;
            while (this.viewAngle < 0.0) {
                this.viewAngle += Math.PI * 2;
            }
            while (this.viewAngle >= Math.PI * 2) {
                this.viewAngle -= Math.PI * 2;
            }
            this.viewAngleCos = Math.cos(this.viewAngle);
            this.viewAngleSin = Math.sin(this.viewAngle);
            this.viewHeight = (double)(this.dragStartY - n2) / 10.0 + this.viewHeightDragStart;
            this.displayOrder = null;
            this.cv.repaint(this.pause);
            return;
        }
        if (this.modeChooser.getSelectedIndex() == 3) {
            this.viewZoom = (double)(n - this.dragStartX) / 40.0 + this.viewZoomDragStart;
            if (this.viewZoom < 0.1) {
                this.viewZoom = 0.1;
            }
            this.cv.repaint(this.pause);
            return;
        }
        double d = 1.0 + (double)(this.dragStartY - n2) / 40.0;
        if (d < -1.0) {
            d = -1.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        this.dragStop = true;
        this.editingFunc = true;
        if (this.modeChooser.getSelectedIndex() == 0) {
            this.doPluck(d);
            return;
        }
        this.doStrike(d);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.cv.repaint(this.pause);
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.handleResize();
        this.cv.repaint(this.pause);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.sineButton) {
            this.doSine();
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.blankButton) {
            this.doBlank();
            this.cv.repaint();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.dampingBar || adjustmentEvent.getSource() == this.speedBar) {
            this.setDamping();
        }
        if (adjustmentEvent.getSource() == this.loadBar && this.loadBar.getValue() != this.modeCountR) {
            this.setLoadCount();
        }
        this.cv.repaint(this.pause);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.applet.destroyFrame();
            return true;
        }
        return super.handleEvent(event);
    }

    void setLoadCount() {
        int n;
        int n2;
        this.modeCountR = this.sampleCountR = this.loadBar.getValue();
        this.sampleCountR *= 4;
        int n3 = this.loadBar.getValue() * 2;
        this.sampleCountTh = 1;
        while (this.sampleCountTh < n3) {
            this.sampleCountTh *= 2;
        }
        this.modeCountTh = this.sampleCountTh + 1;
        this.sampleCountTh *= 2;
        this.magcoef = new double[this.modeCountTh][this.modeCountR];
        this.phasecoef = new double[this.modeCountTh][this.modeCountR];
        this.phasecoefcos = new double[this.modeCountTh][this.modeCountR];
        this.phasecoefadj = new double[this.modeCountTh][this.modeCountR];
        this.xformbuf = new double[this.sampleCountTh * 2];
        this.func = new double[this.sampleCountTh + 1][this.sampleCountR + 1];
        this.funci = new double[this.sampleCountTh + 1][this.sampleCountR + 1];
        System.out.print("grid: " + this.sampleCountTh + " " + this.sampleCountR + " " + this.sampleCountTh * this.sampleCountR + "\n");
        this.scaleHeight = 6.0;
        this.step = Math.PI / (double)this.sampleCountTh;
        this.viewDistance = 50.0;
        this.displayOrder = null;
        this.omega = new double[this.modeCountTh][this.modeCountR];
        double d = this.step * 2.0;
        System.out.print("calc omegas...\n");
        int n4 = 0;
        while (n4 != this.modeCountTh) {
            n2 = 0;
            while (n2 != this.modeCountR) {
                int n5 = (n4 + 1) / 2;
                this.omega[n4][n2] = this.zeroj(n5, n2 + 1) / (double)this.sampleCountR;
                ++n2;
            }
            ++n4;
        }
        System.out.print("calc omegas...done\n");
        double[] dArray = new double[this.modeCountTh + 1];
        this.modeFuncs = new double[this.modeCountTh][this.modeCountR][this.sampleCountR + 1];
        this.angleFuncs = new double[this.modeCountTh][this.sampleCountTh + 1];
        System.out.print("calc modes...\n");
        n4 = 0;
        while (n4 != this.modeCountTh) {
            n = (n4 + 1) / 2;
            n2 = 0;
            while (n2 != this.modeCountR) {
                double d2 = 0.0;
                int n6 = 0;
                while (n6 <= this.sampleCountR) {
                    if (n6 == 0) {
                        dArray[n + 1] = n == 0 ? 1.0 : 0.0;
                    } else {
                        this.bess(n, (double)n6 * this.omega[n4][n2], dArray);
                    }
                    double d3 = dArray[n + 1];
                    this.modeFuncs[n4][n2][n6] = d3;
                    double d4 = d3;
                    if (d4 > d2) {
                        d2 = d4;
                    }
                    if (d4 < -d2) {
                        d2 = -d4;
                    }
                    ++n6;
                }
                n6 = 0;
                while (n6 <= this.sampleCountR) {
                    double[] dArray2 = this.modeFuncs[n4][n2];
                    int n7 = n6++;
                    dArray2[n7] = dArray2[n7] / d2;
                }
                ++n2;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 != this.modeCountTh) {
            n = (n4 + 1) / 2;
            int n8 = 0;
            while (n8 <= this.sampleCountTh) {
                this.angleFuncs[n4][n8] = n4 == 0 ? 1.0 : ((n4 & 1) == 1 ? Math.cos((double)(n * n8) * d) : Math.sin((double)(n * n8) * d));
                ++n8;
            }
            ++n4;
        }
        double d5 = 1.0 / this.omega[0][0];
        int n9 = 0;
        while (n9 != this.modeCountTh) {
            int n10 = 0;
            while (n10 != this.modeCountR) {
                double[] dArray3 = this.omega[n9];
                int n11 = n10++;
                dArray3[n11] = dArray3[n11] * d5;
            }
            ++n9;
        }
        this.setDamping();
        System.out.print("calc modes...done\n");
    }

    double zeroj(int n, int n2) {
        double d = ((double)n2 + 0.5 * (double)n - 0.25) * 3.141592654;
        double d2 = 4 * n * n;
        double d3 = 8.0 * d;
        double d4 = d - (d2 - 1.0) / d3 - 4.0 * (d2 - 1.0) * (7.0 * d2 - 31.0) / (3.0 * d3 * d3 * d3);
        double[] dArray = new double[n + 3];
        int n3 = 1;
        while (n3 <= 5) {
            this.bess(n + 1, d4, dArray);
            double d5 = -dArray[n + 2] + (double)n / d4 * dArray[n + 1];
            d4 -= dArray[n + 1] / d5;
            ++n3;
        }
        return d4;
    }

    void bess(int n, double d, double[] dArray) {
        int n2 = (double)n > d ? n : (int)d;
        int n3 = 2 * ((n2 + 15) / 2 + 1);
        double[] dArray2 = new double[n3 + 2];
        dArray2[n3 + 1] = 0.0;
        dArray2[n3] = 1.0;
        double d2 = 1.0E-16;
        int n4 = n3 - 2;
        while (n4 >= 0) {
            dArray2[n4 + 1] = (double)(2 * (n4 + 1)) / (d + d2) * dArray2[n4 + 2] - dArray2[n4 + 3];
            --n4;
        }
        double d3 = dArray2[1];
        n4 = 2;
        while (n4 <= n3) {
            d3 += 2.0 * dArray2[n4 + 1];
            n4 += 2;
        }
        n4 = 0;
        while (n4 <= n) {
            dArray[n4 + 1] = dArray2[n4 + 1] / d3;
            ++n4;
        }
    }

    void setDamping() {
        this.dampcoef = new double[this.modeCountTh][this.modeCountR];
        double d = (double)this.speedBar.getValue() / 40.0;
        int n = 0;
        while (n != this.modeCountTh) {
            int n2 = 0;
            while (n2 != this.modeCountR) {
                double d2 = this.dampingBar.getValue() / 10;
                d2 = Math.exp(d2) - 1.0;
                double d3 = this.omega[n][n2] * Math.sqrt(Math.sqrt(1.0 + d2 * d2 / (this.omega[n][n2] * this.omega[n][n2])) - 1.0);
                this.dampcoef[n][n2] = Math.exp(-d3 * d * 0.002);
                ++n2;
            }
            ++n;
        }
    }

    void findGridPoint2D(int n, int n2) {
        int n3 = this.view2d.x + this.view2d.width / 2;
        int n4 = this.view2d.y + this.view2d.height / 2;
        int n5 = this.view2d.width / 2;
        this.selectedGridX = (double)(n - n3) / (double)n5;
        this.selectedGridY = (double)(-(n2 - n4)) / (double)n5;
        double d = Math.sqrt(this.selectedGridX * this.selectedGridX + this.selectedGridY * this.selectedGridY);
        if (d > 1.0) {
            this.selectedGridX /= d;
            this.selectedGridY /= d;
        }
    }

    void findGridPoint3D(int n, int n2) {
        int n3 = 3600;
        this.selectedGridY = 0.0;
        this.selectedGridX = 0.0;
        int n4 = 0;
        while (n4 <= this.sampleCountR) {
            int n5 = 0;
            while (n5 <= this.sampleCountTh) {
                this.map3d(n5, n4, this.func[n5][n4], this.xpoints, this.ypoints, 0);
                int n6 = this.xpoints[0] - n;
                int n7 = this.ypoints[0] - n2;
                int n8 = n6 * n6 + n7 * n7;
                if (n8 < n3) {
                    n3 = n8;
                    double d = (double)(n5 * 2) * Math.PI / (double)this.sampleCountTh - this.viewAngle;
                    this.selectedGridX = (double)n4 * Math.cos(d) / (double)this.sampleCountR;
                    this.selectedGridY = (double)n4 * Math.sin(d) / (double)this.sampleCountR;
                }
                ++n5;
            }
            ++n4;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dragging = true;
        this.edit(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.dragging) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.dragX = n;
        this.dragY = n2;
        int n3 = this.getPanelHeight();
        int n4 = this.selectedCoefX;
        int n5 = this.selectedCoefY;
        this.selectedCoefX = -1;
        this.selectedCoefY = -1;
        this.selection = 0;
        if (this.view2d != null && this.view2d.inside(n, n2)) {
            this.selection = 2;
        } else if (this.view3d != null && this.view3d.inside(n, n2)) {
            this.selection = 1;
        } else if (this.viewFreq != null && this.viewFreq.inside(n, n2)) {
            int n6 = this.getTermWidth();
            this.selectedCoefX = (n - this.viewFreq.x) / n6;
            this.selectedCoefY = (n2 - this.viewFreq.y) / n6;
            if (this.selectedCoefX >= this.modeCountTh) {
                this.selectedCoefY = -1;
                this.selectedCoefX = -1;
            }
            if (this.selectedCoefY >= this.modeCountR) {
                this.selectedCoefY = -1;
                this.selectedCoefX = -1;
            }
            if (this.selectedCoefX != -1 && this.selectedCoefY != -1) {
                this.selection = 3;
            }
        }
        if (this.selectedCoefX != n4 || this.selectedCoefY != n5) {
            this.cv.repaint(this.pause);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.selection == 3) {
            this.editMagClick();
        }
        if (mouseEvent.getClickCount() == 2 && this.selectedCoefX != -1) {
            int n = 0;
            while (n != this.modeCountTh) {
                int n2 = 0;
                while (n2 != this.modeCountR) {
                    if (this.selectedCoefX != n || this.selectedCoefY != n2) {
                        this.magcoef[n][n2] = 0.0;
                    }
                    ++n2;
                }
                ++n;
            }
            this.magcoef[this.selectedCoefX][this.selectedCoefY] = 1.0;
            this.cv.repaint(this.pause);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.dragging && this.selectedCoefX != -1) {
            this.selectedCoefY = -1;
            this.selectedCoefX = -1;
            this.cv.repaint(this.pause);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if (this.selection == 1) {
            this.findGridPoint3D(mouseEvent.getX(), mouseEvent.getY());
        }
        this.dragStartX = mouseEvent.getX();
        this.dragStartY = mouseEvent.getY();
        if (this.selectedCoefX != -1) {
            this.magDragStart = this.magcoef[this.selectedCoefX][this.selectedCoefY];
        }
        this.viewAngleDragStart = this.viewAngle;
        this.viewHeightDragStart = this.viewHeight;
        this.viewZoomDragStart = this.viewZoom;
        this.dragging = true;
        this.edit(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        this.dragStop = false;
        this.editingFunc = false;
        this.dragging = false;
        this.dragClear = false;
        this.dragSet = false;
        this.mouseMoved(mouseEvent);
        this.cv.repaint(this.pause);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.stoppedCheck) {
            this.cv.repaint(this.pause);
            return;
        }
        if (itemEvent.getItemSelectable() == this.displayChooser || itemEvent.getItemSelectable() == this.freqCheck) {
            this.setupDisplay();
            this.cv.repaint(this.pause);
        }
        if (itemEvent.getItemSelectable() == this.display2Chooser || itemEvent.getItemSelectable() == this.colorCheck) {
            this.cv.repaint(this.pause);
        }
        if (itemEvent.getItemSelectable() == this.soundCheck) {
            if (this.soundCheck.getState()) {
                this.speedBar.setValue(200);
                this.dampingBar.setValue(75);
                this.setDamping();
                this.baseFreqBar.enable();
            } else {
                this.baseFreqBar.disable();
            }
        }
    }

    void four1(double[] dArray, int n, int n2) {
        int n3;
        double d;
        int n4 = n << 1;
        int n5 = 1;
        int n6 = 1;
        while (n6 < n4) {
            if (n5 > n6) {
                d = dArray[n5 - 1];
                dArray[n5 - 1] = dArray[n6 - 1];
                dArray[n6 - 1] = d;
                d = dArray[n5];
                dArray[n5] = dArray[n6];
                dArray[n6] = d;
            }
            n3 = n4 >> 1;
            while (n3 >= 2 && n5 > n3) {
                n5 -= n3;
                n3 >>= 1;
            }
            n5 += n3;
            n6 += 2;
        }
        int n7 = 2;
        while (n4 > n7) {
            int n8 = 2 * n7;
            double d2 = 6.28318530717959 / (double)(n2 * n7);
            double d3 = Math.sin(0.5 * d2);
            double d4 = -2.0 * d3 * d3;
            double d5 = Math.sin(d2);
            double d6 = 1.0;
            double d7 = 0.0;
            n3 = 1;
            while (n3 < n7) {
                n6 = n3;
                while (n6 <= n4) {
                    n5 = n6 + n7;
                    d = d6 * dArray[n5 - 1] - d7 * dArray[n5];
                    double d8 = d6 * dArray[n5] + d7 * dArray[n5 - 1];
                    dArray[n5 - 1] = dArray[n6 - 1] - d;
                    dArray[n5] = dArray[n6] - d8;
                    int n9 = n6 - 1;
                    dArray[n9] = dArray[n9] + d;
                    int n10 = n6;
                    dArray[n10] = dArray[n10] + d8;
                    n6 += n8;
                }
                d3 = d6;
                d6 = d3 * d4 - d7 * d5 + d6;
                d7 = d7 * d4 + d3 * d5 + d7;
                n3 += 2;
            }
            n7 = n8;
        }
    }
}

