      program main

      use       msflib
      character datafl*512,outfl*512,str*512
      real      sum,sqsum
      integer   test,num
      logical   testfl
      data      lin/1/
c
c Declare dynamic arrays:
c
      real,allocatable :: mean(:),var(:)
	integer,allocatable :: order(:)
c
c Get the name of the parameter file - try the default name if no input:
c
      do i=1,512
            str(i:i) = ' '
      end do
      call getarg(1,str)
      if(str(1:1).eq.' ')then
            write(*,*) 'Which parameter file do you want to use?'
            read (*,'(a)') str
      end if
      if(str(1:1).eq.' ') str(1:20) = 'rank.par         '
      inquire(file=str,exist=testfl)
      if(.not.testfl) then
            write(*,*) 'ERROR - the parameter file does not exist,'
            write(*,*) '        check for the file and try again  '
            write(*,*)
            if(str(1:20).eq.'rank.par         ') then
                  write(*,*) '        creating a blank parameter file'
                  call makepar
                  write(*,*)
            end if
            stop
      endif
      open(lin,file=str,status='OLD')
c
c Find Start of Parameters:
c
 1    read(lin,'(a4)',end=97) str(1:4)
      if(str(1:4).ne.'STAR') go to 1
c
c Read Input Parameters:
c
      read(lin,'(a512)',err=97) datafl
      call chknam(datafl,512)
      write(*,*) ' data file with simulations = ',datafl(1:40)

      read(lin,*,err=97) nsim
      write(*,*) ' number of simulations = ',nsim

      read(lin,*,err=97) nx,ny,nz
      write(*,*) ' grid size (nx,ny,nz) = ',nx,ny,nz
	nxyz=nx*ny*nz
c
c Find the parameters, then allocate the needed memory.
c
      allocate(var(nsim),stat = test)
      if(test.ne.0)then
            write(*,*)'ERROR: Allocation failed due to',
     +                ' insufficient memory.',test
            stop
      end if
      allocate(mean(nsim),stat = test)
      if(test.ne.0)then
            write(*,*)'ERROR: Allocation failed due to',
     +                ' insufficient memory.',test
            stop
      end if
      allocate(order(nsim),stat = test)
      if(test.ne.0)then
            write(*,*)'ERROR: Allocation failed due to',
     +                ' insufficient memory.',test
            stop
      end if

      read(lin,'(a512)',err=97) outfl
      call chknam(outfl,512)
      write(*,*) ' output file = ',outfl(1:40)

      close(lin)

      open(1,file=datafl)
      read(1,*)
      read(1,*)
      read(1,*)
      open(2,file=outfl)
      write(2,*) ' Ranked Realizations based on Mean'
      write(2,*) ' 4'
      write(2,*) ' Rank Number'
      write(2,*) ' Realization Number'
      write(2,*) ' Mean'
      write(2,*) ' Variance'
      do isim=1,nsim
	      write(*,*) ' Reading Simulation :',int(isim)
            sum=0
            sqsum=0
            num=0
            do ix=1,nx
            do iy=1,ny
            do iz=1,nz
                  read(1,*) sim
                  sum=sum+sim
                  sqsum=sqsum+sim*sim
                  num=num+1
            end do
            end do
            end do
            order(isim)=isim
            mean(isim)=sum/num
            var(isim)=sqsum/num-mean(isim)**2
      end do
      call sortem(1,nsim,mean,2,order,var,d,e,f,g,h)
      do isim=1,nsim
            write(2,100) isim,order(isim),mean(isim),var(isim)
      end do
100   format(i5,i5,f15.5,f15.5)
      close(1)
      close(2)
	write(*,*) 'RANK - Program Finished'
	stop
97    stop ' Error in parameter file!'
      end


      subroutine makepar
c-----------------------------------------------------------------------
c
c                      Write a Parameter File
c                      **********************
c
c
c
c-----------------------------------------------------------------------
      lun = 99
      open(lun,file='rank.par',status='UNKNOWN')
      write(lun,10)
 10   format('                  Parameters for RANK',/,
     +       '                  *******************',/,/,
     +       'START OF PARAMETERS:')

      write(lun,11)
 11   format('sgsim.out                        ',
     +       '-file with simulated realizations')
      write(lun,12)
 12   format('50                               ',
     +       '-   number of realizations')
      write(lun,14)
 14   format('20   20   1                      ',
     +       '-nx, ny, nz')
      write(lun,15)
 15   format('rank.out                         ',
     +       '-file for output array(s)')

      close(lun)
      return
      end
