      program main

      use       msflib
      character datafl*512,outfl*512,str*512
      logical   testfl
      data      lin/1/
c
c Get the name of the parameter file - try the default name if no input:
c
      do i=1,512
            str(i:i) = ' '
      end do
      call getarg(1,str)
      if(str(1:1).eq.' ')then
            write(*,*) 'Which parameter file do you want to use?'
            read (*,'(a)') str
      end if
      if(str(1:1).eq.' ') str(1:20) = 'getsim.par          '
      inquire(file=str,exist=testfl)
      if(.not.testfl) then
            write(*,*) 'ERROR - the parameter file does not exist,'
            write(*,*) '        check for the file and try again  '
            write(*,*)
            if(str(1:20).eq.'getsim.par       ') then
                  write(*,*) '        creating a blank parameter file'
                  call makepar
                  write(*,*)
            end if
            stop
      endif
      open(lin,file=str,status='OLD')
c
c Find Start of Parameters:
c
 1    read(lin,'(a4)',end=97) str(1:4)
      if(str(1:4).ne.'STAR') go to 1
c
c Read Input Parameters:
c
      read(lin,'(a512)',err=97) datafl
      call chknam(datafl,512)
      write(*,*) ' binary file with simulations = ',datafl(1:40)

      read(lin,*,err=97) fall 
      write(*,*) ' extract all? = ',int(fall)

      read(lin,*,err=97) simnum
      if(fall.eq.0) then
      write(*,*) ' extract realization number = ',int(simnum)
	end if

      read(lin,'(a512)',err=97) outfl
      call chknam(outfl,512)
      write(*,*) ' output file = ',outfl(1:40)

      close(lin)
c
c Read data
c
      open(1,file=datafl,form='UNFORMATTED')
      read(1)  title
      read(1)  nx,ny,nz,nsim
	if (nsim.lt.simnum) then
	      write(*,*) ' ERROR - The file has ',int(nsim),
     +      ' realizations'
	      write(*,*) '         You asked for realization number ',
     +      int(simnum)
	      goto 97
	end if
      open(2,file=outfl)
      write(2,*) ' Realization(s) extracted from ',datafl(1:40)
      write(2,*) ' 1'
      write(2,*) ' Value'
	if (fall.eq.1) then
      do isim=1,nsim
	      write(*,*) ' Writing Simulation :',int(isim)
            do ix=1,nx
            do iy=1,ny
            do iz=1,nz
                  read(1) sim
	            write(2,*) sim
            end do
            end do
            end do
      end do
      else
	do isim=1,simnum-1
	      write(*,*) ' Reading Simulation :',int(isim)
            do ix=1,nx
            do iy=1,ny
            do iz=1,nz
                  read(1) sim
            end do
            end do
            end do
      end do
	write(*,*) ' Writing Simulation :',int(isim)
      do ix=1,nx
      do iy=1,ny
      do iz=1,nz
            read(1) sim
            write(2,*) sim
      end do
      end do
      end do
      end if
      close(1)
      close(2)
	write(*,*) 'GETSIM - Program Finished'
	stop
97    stop ' Error in parameter file!'
      end


      subroutine makepar
c-----------------------------------------------------------------------
c
c                      Write a Parameter File
c                      **********************
c
c
c
c-----------------------------------------------------------------------
      lun = 99
      open(lun,file='getsim.par',status='UNKNOWN')
      write(lun,10)
 10   format('                  Parameters for GETSIM',/,
     +       '                  *********************',/,/,
     +       'START OF PARAMETERS:')

      write(lun,11)
 11   format('sgsim_pw.out                     ',
     +       '-binary file with simulated realizations')
      write(lun,12)
 12   format('0                                ',
     +       '-extract all realizations(1=yes,0=no)')
      write(lun,13)
 13   format('1                                ',
     +       '-  realization to extract (if 0)')
      write(lun,15)
 15   format('getsim.out                       ',
     +       '-ascii file to output realization')

      close(lun)
      return
      end
