#!/usr/bin/python
#-*- coding: iso-8859-1 -*-

import matplotlib.pyplot as plt
from math import cos, sin, pi

def sqrt(x,seed=1,n=2,eps=1e-3):
	x0=complex(seed)
	dif=1		#dif=(x0**n-x)/(n*x0**(n-1))
	for i in range(int(n)):
		dif=dif*x0
	dif=dif-x
	for i in range(int(n-1)):
		dif=dif/x0
	dif=dif/n
	cont=0
	while abs(dif)>eps:
		x0=x0-dif
		dif=1		#dif=(x0**n-x)/(n*x0**(n-1))
		for i in range(int(n)):
			dif=dif*x0
		dif=dif-x
		for i in range(int(n-1)):
			dif=dif/x0
		dif=dif/n
		cont+=1
		if cont>200:
			return 0
	return x0		

X1=[]
Y1=[]
X2=[]
Y2=[]
X3=[]
Y3=[]

raiz1=1+0j
raiz2=cos(2*pi/3.0)+sin(2*pi/3.0)*(1j)
raiz3=cos(4*pi/3.0)+sin(4*pi/3.0)*(1j)

n=200.0
eps=1e-1
for i in range(int(2*n)):
	for j in range(int(2*n)):
		try:
			seed=(i-n)/(2*n)+(1j)*(j-n)/(2*n)
			com=sqrt(1,seed=seed,n=3)
			if abs(com-raiz1)<eps:
				X1.append((i-n)/(2*n))
				Y1.append((j-n)/(2*n))
			elif abs(com-raiz2)<eps:
				X2.append((i-n)/(2*n))
				Y2.append((j-n)/(2*n))
			elif abs(com-raiz3)<eps:
				X3.append((i-n)/(2*n))
				Y3.append((j-n)/(2*n))
		except:
			pass


color=["r"]*len(X1)
color=color+["g"]*len(X2)
color=color+["b"]*len(X3)

X=X1+X2+X3
Y=Y1+Y2+Y3

plt.scatter(X,Y,color=color)
plt.show()
