%% prog metodo de euler control 01 parte 3.2

clearvars;
close all;
clc;

%% incializacion

%ecuacion diferencial
% y'' + delta*y' + beta*y^3 + w0*y = gama*cos(w*t + phi0)

%uso de variable auxiliar
% y' = u 
% u = y'
% y'' = -delta*y' - beta*y^3 - w0*y + gama*cos(w*t + phi0) 
% u' = -delta*y' - beta*y^3 - w0*y + gama*cos(w*t + phi0) 

%datos
delta = 1.0;
beta  = 1.0;
w0    = -1.0;
gama  = 1.0;
phi0  = 0.0;
w     = 0.1;

%tiempo incial/final
tini =  0;
tfin =  200;

%valores inciales%
y0 = 0.5;     %posicin incial
u0 = -0.5;    %velocidad incial u(0) = y'(0)

%incrementos
deltat = 0.0001;

%valores de xn por prelocalizacin
tn = tini:deltat:tfin;	%valores de tn
Nn = length(tn);        %tamanho de tn

%valores yn por prelocalizacin
yn = zeros(1,Nn);     %incialmente lleno de ceros

%valores un por prelocalizacin
un = zeros(1,Nn);     %incialmente lleno de ceros

%condicion incial de desplazamiento
yn(1) = y0;         %condicion incial desplazamiento

%condicion inicial de velocidad
un(1) = u0;         %condicion incial velocidad u(0) = y'(0)


%% solucion numrica
for n = 1:Nn-1
    yn(n+1) = yn(n) + deltat*un(n);
    un(n+1) = un(n) + deltat*( -delta*un(n) - beta*yn(n)^3 - w0*yn(n) + gama*cos(w*tn(n) + phi0) );
end;

%% espacio de fase

%desplazamiento
Lyini = -1.1*max(abs(yn));
Lyfin =  1.1*max(abs(yn));
dy = 0.01;

%velocidad
Luini = -1.1*max(abs(un));
Lufin =  1.1*max(abs(un));
du = 0.01;

%tiempo
Tini = -1.1*max(abs(un));
Tfin =  1.1*max(abs(un));
dt0 = 0.01;

%espacio de estados inciales
[y0,u0] = meshgrid(Lyini:dy:Lyfin,Luini:du:Lufin);

%tiempo
t0 = meshgrid(Lyini:dy:Lyfin,Luini:du:Lufin);

%aceleracion
v0 = -delta*u0 - beta*y0.^3 - w0*y0 + gama*cos(w*t0 + phi0);

%vector
figure(1)
quiver(y0,u0,u0,v0,'r');          %dibuja flechas 2D 
title('espacio de fase');
xlabel('y(t) (m) ');
ylabel('dy(t)/dt (m/s)')
legend('espfase');
daspect([1 1 1]);
axis([ -1.1*max(abs(yn)) 1.1*max(abs(yn)) 1.1*min(un) 1.1*max(un) ]); 
grid on;
box on;

%% resultados

figure(2)
plot(tn,yn,'k')
title('solucion euler desplazamiento');
xlabel('t (s) ')
ylabel('y(t) (m)');
legend(['y(t) \Deltat = ' num2str(deltat)])
axis([ tini tfin -1.1*max(abs(yn)) 1.1*max(abs(yn))]); 
grid on;
box on;

figure(3)
plot(tn,un,'k')
title('solucion euler velocidad');
xlabel('t (s)')
ylabel('dy(t)/dt (m/s)')
legend(['dy(t)/dt \Deltat = ' num2str(deltat)])
axis([ tini tfin 1.1*min(un) 1.1*max(un) ]); 
grid on;
box on;

figure(4)
plot(yn,un,'k')
title('diagrama de fase');
xlabel('y(t) (m) ');
ylabel('dy(t)/dt (m/s) ');
legend(['y(t) vs dy(t)/dt \Deltat = ' num2str(deltat)])
axis([ -1.1*max(abs(yn)) 1.1*max(abs(yn)) 1.1*min(un) 1.1*max(un) ]); 
grid on;
box on;

figure(5)
quiver(y0,u0,u0,v0,'r');          %dibuja flechas 2D 
hold on;
plot(yn,un,'k')
title('espacio de fase y diagrama de fase');
xlabel('y(t) (m)');
ylabel('dy(t)/dt (m/s)');
legend('espfase',['y(t) vs dy(t)/dt \Deltat = ', num2str(deltat)] );
daspect([1 1 1]);
axis([ -1.1*max(abs(yn)) 1.1*max(abs(yn)) 1.1*min(un) 1.1*max(un) ]); 
grid on;
box on;

