%% prog metodo de diferencias centrales control 01 parte 3.1

%este programa resuelve la EDO de segundo orden con condiciones inciales
%usando diferencias finitas

clearvars;
close all;
clc;

%% datos inciales

%matriz de masa
M = [1, 1, 0, 0, 0;
     1, 2, 1, 0, 0;
     0, 1, 3, 1, 0;
     0, 0, 1, 2, 1;
     0, 0, 0, 1, 1];    

%matriz de rigidez 
K = [ 400,-200,   0,   0,   0;
     -200, 400,-200,   0,   0;
        0,-200, 400,-200,   0; 
        0,   0,-200, 400,-200; 
        0,   0,   0,-200, 200];

%matriz de amortiguamiento
C = [20, -10,  0,    0,   0;
    -10,  20, -10,   0,   0;
      0, -10,  20, -10,   0;   
      0,   0, -10,  20, -10;   
      0,   0,   0, -10,  10];



%% tiempo

dt = 0.01;          %intervalo de muestreo
tini = 0;           %tiempo incial 
tfin = 200;         %tiempo final
t = tini:dt:tfin;   %vector de tiempo
N = length(t);      %numero de muestras total

%% condiciones inciales

%% condiciones iniciales
 
x0 = [0;0;0;0;0];     %desplazamiento inicial
v0 = [0;0;0;0;0];     %velocidad inicial

%% fuerza externa

%componentes
f1(1:N) = 0;            %inicialización de fuerza
f2(1:N) = 0;            %inicialización de fuerza
f3(1:N) = 0;            %inicialización de fuerza
f4(1:N) = 0;            %inicialización de fuerza
f5(1:N) = 0;            %inicialización de fuerza
 
tf1 = 10;               %tiempo1
tf2 = 50;               %tiempo2
tf3 = 90;               %tiempo2
nf1 = round(tf1/dt);    %muestra1
nf2 = round(tf2/dt);    %muestra2
nf3 = round(tf3/dt);    %muestra2
 
f1(nf1:nf2)   =  50;
f1(nf2+1:nf3) = -50;


f = [f1;f2;f3;f4;f5];

%% desplazamiento

%inicializamos el desplazamiento
X = zeros(5,N);

%paso 1 determinar la aceleracion

f0 = f(:,1);
a0 = M\(f0 - x0 - v0);

%paso 2 determinar el desplazamiento x1 ubicado en la segunda columna de X
X(:,2) = x0 + v0*dt + (1/2)*a0*dt^2;

%paso 3 determinamos el resultado mediante recurrencia
X(:,1) = x0;


C1 = M/(dt^2) + C/(2*dt);
C2 = K - (2*M)/(dt^2);
C3 = M/(dt^2) - C/(2*dt);

for n = 2:N-1
    X(:,n+1) = C1\( f(:,n) - C2*X(:,n) - C3*X(:,n-1) );
end;

%separamos la solucion por facilidad
x1(1:N) = 0;   %incializacion de desplazamiento
x2(1:N) = 0;   %incializacion de desplazamiento
x3(1:N) = 0;   %incializacion de desplazamiento
x4(1:N) = 0;   %incializacion de desplazamiento
x5(1:N) = 0;   %incializacion de desplazamiento

for n = 1:N
    x1(n) = X(1,n);
    x2(n) = X(2,n);
    x3(n) = X(3,n);
    x4(n) = X(4,n);
    x5(n) = X(5,n);
end; 

%% velocidad

v1(1:N) = 0;   %incializacion de la velocidad
v2(1:N) = 0;   %incializacion de la velocidad
v3(1:N) = 0;   %incializacion de la velocidad
v4(1:N) = 0;   %incializacion de la velocidad
v5(1:N) = 0;   %incializacion de la velocidad

for n = 2:N-1
    v1(n) = ( x1(n+1) - x1(n-1) )/(2*dt);
    v2(n) = ( x2(n+1) - x2(n-1) )/(2*dt);
    v3(n) = ( x3(n+1) - x3(n-1) )/(2*dt);
    v4(n) = ( x4(n+1) - x4(n-1) )/(2*dt);
    v5(n) = ( x5(n+1) - x5(n-1) )/(2*dt);
end;

V = [v1;v2;v3;v4;v5];

%% resultados

figure(1)
plot(t,f1,'r',t,f2,'k',t,f3,'b',t,f4,'g',t,f5,'c');
title('fuerza');
xlabel('tiempo t(s)');
ylabel('fuerza f(t) (N)');
legend('f_1(t)','f_2(t)','f_3(t)','f_4(t)','f_5(t)');
axis([tini, tfin, -1.1*max(abs(f1)), 1.1*max(abs(f1))]);
grid on;
box on;

figure(2)
plot(t,x1,'r',t,x2,'k',t,x3,'b',t,x4,'g',t,x5,'c');
title('desplazamiento diferencias centrales');
xlabel('tiempo t(s)');
ylabel('desplazamiento x(t) (m)');
legend('x_1(t)','x_2(t)','x_3(t)','x_4(t)','x_5(t)');
axis([tini, tfin, -1.1*max(max(abs(X))), 1.1*max(max(abs(X)))]);
grid on;
box on;

figure(3)
plot(t,v1,'r',t,v2,'k',t,v3,'b',t,v4,'g',t,v5,'c');
title('velocidad diferencias centrales');
xlabel('tiempo t(s)');
ylabel('velocidad v(t) (m/s)');
legend('v_1(t)','v_2(t)','v_3(t)','v_4(t)','v_5(t)');
axis([tini, tfin, -1.1*max(max(abs(V))), 1.1*max(max(abs(V)))]);
grid on;
box on;


figure(4)
plot(x1,v1,'r',x2,v2,'k',x3,v3,'b',x4,v4,'g',x5,v5,'c');
title('diagrama de fase diferencias centrales');
xlabel('desplazamiento x(t) (m)');
ylabel('velocidad v(t) (m/s)');
legend('x_1(t) vs v_1(t)','x_2(t) vs v_2(t)','x_3(t) vs v_3(t)','x_4(t) vs v_4(t)','x_5(t) vs v_5(t)');
axis([-1.1*max(max(abs(X))), 1.1*max(max(abs(X))), -1.1*max(max(abs(V))), 1.1*max(max(abs(V)))]);
grid on;
box on;

