%% control 01 parte serie de fourier  2.2

clearvars;
close all;
clc;

%% definiciones
Tmin = 0;
Tmax = 6*pi;
dt = 0.01*pi;

%%tiempo
t = Tmin:dt:Tmax;
Nt = length(t);


%%funcin
f2t = zeros(1,Nt);
y2t = zeros(1,Nt);

%% serie de fourier

figure(1)
plot(t,f2t);
title('serie de fourier');
xlabel('t (s)');
ylabel('f(t) (Pa)');
grid on;
box on;

%sumatoria
N = 50;

for n = 1:N
    nn(n) = n;

    %coeficiente f(t)
    fn(n) = 4/(pi*(2*nn(n) - 1));

    %funcion f(t)
    f2t = f2t + fn(n)*sin( (2*nn(n) - 1)*t );
    
    %coeficiente y(t)
    yn(n) = 4/(pi*(2*nn(n)-1));
    yn(n) = yn(n)/( 4*nn(n)^2-4*nn(n)+16*pi^2+1  );
    
    %funcion y(t)
    y2t = y2t + yn(n)*( 4*pi*sin((2*nn(n)-1)*t)+(1-2*nn(n))*cos((1-2*nn(n))*t) );
    

    figure(1)
    plot(t,f2t);
    title('serie de fourier');
    xlabel('t (s)');
    ylabel('f(t) (Pa)');
    legend(['f(t) n = ',num2str(nn(n))]);
    axis([Tmin,Tmax,-1.5,1.5]);
    grid on;
    box on;

    
    figure(2)
    plot(t,y2t);
    title('serie de fourier');
    xlabel('t (s)');
    ylabel('y(t) (Pa)');
    legend(['y(t) n = ',num2str(nn(n))]);
    axis([Tmin,Tmax,-0.1,0.1]);
    grid on;
    box on;
    
    
    pause(0.05);

end

%% figura final
figure(3)
plot(t,f2t);
title('serie de fourier');
xlabel('t (s)');
ylabel('f_2(t) (Pa)');
legend(['f_2(t) n = ',num2str(nn(n))]);
axis([Tmin,Tmax,-1.5,1.5]);
grid on;
box on;

figure(4)
plot(t,y2t);
title('serie de fourier');
xlabel('t (s)');
ylabel('y(t) (Pa)');
legend(['y(t) n = ',num2str(nn(n))]);
axis([Tmin,Tmax,-0.1,0.1]);
grid on;
box on;
