%% control 01 parte serie de fourier compleja 2.1

%
% f(t) = (t^4 -1) -1 <= t <= 1
%


clearvars;
close all;
clc;

%% definiciones
Tmin = -10;
Tmax =  10;
dt = 0.05;

%%tiempo
t = Tmin:dt:Tmax;
Nt = length(t);


%%funcin
f2t = zeros(1,Nt);

%% serie de fourier

figure(1)
plot(t,f2t);
title('serie de fourier');
xlabel('t (s)');
ylabel('f(t) (Pa)');
grid on;
box on;

%sumatoria
N = 201;

for n = 1:N
    nn(n) = -round(N/2) + n;

    %coeficiente

    %valor c(n)
    if nn(n) ~= 0
       cn(n) = (4/(nn(n)^4*pi^4 ))*(-1)^nn(n)*(nn(n)^2*pi^2 - 6 );
    else
       cn(n) = -8/5;
    end


    %funcion
    f2t = f2t + cn(n)*exp(j*nn(n)*t);

    figure(1)
    plot(t,f2t);
    title('serie de fourier');
    xlabel('t (s)');
    ylabel('f(t) (Pa)');
    legend(['f(t) n = ',num2str(nn(n))]);
    axis([Tmin,Tmax,-2,-0.5]);
    grid on;
    box on;

    pause(0.05);

end

%% figura final
figure(2)
plot(t,f2t);
title('serie de fourier');
xlabel('t (s)');
ylabel('f_2(t) (Pa)');
legend(['f_2(t) n = ',num2str(nn(n))]);
axis([Tmin,Tmax,-2,-0.5]);
grid on;
box on;

%% figura final parte real e imaginaria
figure(3)

subplot(2,1,1)
plot(t,real(f2t));
title('parte real f_2(t)');
xlabel('t');
ylabel('real(f_2(t))');
legend('real(f_2(t))');
axis([Tmin,Tmax,-2,-0.5]);
grid on;
box on;

subplot(2,1,2)
plot(t,imag(f2t));
title('parte imaginaria f_2(t)');
xlabel('n');
ylabel('imag(f_2(t))');
legend('imag(f_2(t))');
axis([Tmin,Tmax,1.1*min(imag(f2t)),1.1*max(imag(f2t))]);
grid on;
box on;

%% figura coeficientes
figure(4)

subplot(2,1,1)
stem(nn,real(cn));
title('coeficientes parte realc_n');
xlabel('n');
ylabel('real(c_n)');
legend('real(c_n)');
grid on;
box on;

subplot(2,1,2)
stem(nn,imag(cn));
title('coeficientes parte imaginaria c_n');
xlabel('n');
ylabel('imag(c_n)');
legend('imag(c_n)');
grid on;
box on;

figure(5)

subplot(2,1,1)
stem(nn,abs(cn));
title('amplitud c_n');
xlabel('n');
ylabel('abs(c_n)');
legend('abs(c_n)');
grid on;
box on;

subplot(2,1,2)
stem(nn,angle(cn));
title('fase c_n');
xlabel('n');
ylabel('fase(c_n)');
legend('fase(c_n)');
grid on;
box on;
