%% prog hexagonal

clear all;
close all;
clc;

%este programa calcula los valores y vectores propios de un hexagono
%con condiciones de contorno de neumann nulas pero sus resultados se
%extenderan para un recinto hexagonal 3D


%% geometría del poligono

%tipo de poligono
ptype = 2;      %dimension 2D
nside = 6;      %cuatro lados

%vector columna de coordenadas x
x(1,1) =  2;
x(2,1) =  4;
x(3,1) =  1;
x(4,1) =  1;
x(5,1) = -4;
x(6,1) = -2;

%vector columna de coordenadas y
y(1,1) = 0;
y(2,1) = 4;
y(3,1) = 7;
y(4,1) = 7;
y(5,1) = 4;
y(6,1) = 0;

%altura del recinto 
Lz = 3;

%informacion del tipo de geometria
gd = [ptype;nside;x;y];

%genera geometria coordenadas y orientacion de la superficie
g = decsg(gd);

%condiciones de contorno de neumann n*grad(u) = 0
xb = [1 ;0 ;1 ;1 ;48 ;48 ;48 ; 48 ; 49 ; 48];

%condiciones de contorno de dirichelet h*u = r = h = 1
xb = [1 ;1 ;1 ;1 ;1 ;1 ;48 ; 48 ; 49 ; 48];

%matriz de condiciones de contorno
b = [xb,xb,xb,xb,xb,xb];

%grafico de geometría 
figure(1)
pdegplot(g);
title('geometria');
xlabel('x (m)');
ylabel('y (m)');
axis([min(x)-1,max(x)+1,min(y)-1,max(y)+1]);
daspect([1,1,1]);
grid on;
box on;

%% malla triangular

%inicializacion de la malla
[p,e,t] = initmesh(g);

%refinamos la malla
[p,e,t] = refinemesh(g,p,e,t);
[p,e,t] = refinemesh(g,p,e,t);


%p son los puntos de los nodos en coordenadas xy
%e son los parametros
%t es la matriz de conectividad

%grafico de malla
figure(2)
pdemesh(p,e,t);
title('malla');
xlabel('x (m)');
ylabel('y (m)');
axis([min(x)-1,max(x)+1,min(y)-1,max(y)+1]);
daspect([1,1,1]);
grid on;
box on;

%% problema de valores propios

%por defecto el pdetool resuelve el problema d valores propios
%-div(c*grad(u)) +a*u = lamda*u
%si c = 1; a = 0; d = 1; f = 0
%es lo mismo que la ecuación de Helmholtz
%laplaciano(u) + k^2*u = 0

%son constantes no tienen  que ver con la velocidad del sonido
c = 1;
a = 0;
d = 1;
f = 0;

%rango de busqueda
r = [0, 10];

%eigensolver - resolucion de valores propios
[phi,lamda] = pdeeig(b,p,e,t,c,a,d,r);

%lamda = k^2 - valor propio entregado como matriz diagonal
%phi vectores propios entregados como matriz

%% frecuencias naturales de un recinto rectangular 3D

kxy = real(sqrt(lamda));
Nxyz = length(kxy);

%valores propios del eje z
kz = zeros(1,Nxyz);

for nz = 1:Nxyz
    kz(nz) = (nz-1)*pi/Lz;
end

n = 1;
c = 344;

%frecuencias naturales angulares
for nxy = 1:Nxyz
    for nz = 1:Nxyz
        wnxnynz(n) = c*sqrt( kxy(nxy)^2 + kz(nz)^2 );
        n = n+1;
    end
end

%frecuencias naturales 
fnxnynz = wnxnynz/2/pi;

%% graficos

figure(3)
subplot(2,2,1)
pdesurf(p,t,phi(:,1)/max(abs(phi(:,1))));
title('primer modo 2D');
xlabel('x (m)');
ylabel('y (m)');
legend(['f_{n_x,n_y,n_z} = ',num2str(fnxnynz(1)),' (Hz)']);
axis([min(x)-1,max(x)+1,min(y)-1,max(y)+1]);
daspect([1,1,1]);
grid on;
box on;
colormap jet;
colorbar;

subplot(2,2,2)
pdesurf(p,t,phi(:,2)/max(abs(phi(:,2))));
title('segundo modo 2D');
xlabel('x (m)');
ylabel('y (m)');
legend(['f_{n_x,n_y,n_z} = ',num2str(fnxnynz(2)),' (Hz)']);
axis([min(x)-1,max(x)+1,min(y)-1,max(y)+1]);
daspect([1,1,1]);
grid on;
box on;
colormap jet;
colorbar;

subplot(2,2,3)
pdesurf(p,t,phi(:,3)/max(abs(phi(:,3))));
title('tercero modo 2D');
xlabel('x (m)');
ylabel('y (m)');
legend(['f_{n_x,n_y,n_z} = ',num2str(fnxnynz(3)),' (Hz)']);
axis([min(x)-1,max(x)+1,min(y)-1,max(y)+1]);
daspect([1,1,1]);
grid on;
box on;
colormap jet;
colorbar;

subplot(2,2,4)
pdesurf(p,t,phi(:,4)/max(abs(phi(:,4))));
title('cuarto modo 2D');
xlabel('x (m)');
ylabel('y (m)');
legend(['f_{n_x,n_y,n_z} = ',num2str(fnxnynz(4)),' (Hz)']);
axis([min(x)-1,max(x)+1,min(y)-1,max(y)+1]);
daspect([1,1,1]);
grid on;
box on;
colormap jet;
colorbar;


figure(4)
subplot(2,2,1)
pdesurf(p,t,phi(:,5)/max(abs(phi(:,5))));
title('quinto modo 2D');
xlabel('x (m)');
ylabel('y (m)');
legend(['f_{n_x,n_y,n_z} = ',num2str(fnxnynz(5)),' (Hz)']);
axis([min(x)-1,max(x)+1,min(y)-1,max(y)+1]);
daspect([1,1,1]);
grid on;
box on;
colormap jet;
colorbar;

subplot(2,2,2)
pdesurf(p,t,phi(:,6)/max(abs(phi(:,6))));
title('sexto modo 2D');
xlabel('x (m)');
ylabel('y (m)');
legend(['f_{n_x,n_y,n_z} = ',num2str(fnxnynz(6)),' (Hz)']);
axis([min(x)-1,max(x)+1,min(y)-1,max(y)+1]);
daspect([1,1,1]);
grid on;
box on;
colormap jet;
colorbar;

subplot(2,2,3)
pdesurf(p,t,phi(:,7)/max(abs(phi(:,7))));
title('septimo modo 2D');
xlabel('x (m)');
ylabel('y (m)');
legend(['f_{n_x,n_y,n_z} = ',num2str(fnxnynz(7)),' (Hz)']);
axis([min(x)-1,max(x)+1,min(y)-1,max(y)+1]);
daspect([1,1,1]);
grid on;
box on;
colormap jet;
colorbar;

subplot(2,2,4)
pdesurf(p,t,phi(:,8)/max(abs(phi(:,8))));
title('octavo modo 2D');
xlabel('x (m)');
ylabel('y (m)');
legend(['f_{n_x,n_y,n_z} = ',num2str(fnxnynz(8)),' (Hz)']);
axis([min(x)-1,max(x)+1,min(y)-1,max(y)+1]);
daspect([1,1,1]);
grid on;
box on;
colormap jet;
colorbar;