%% superposicion coherente

clearvars;
close all;
clc;

%% datos inciales
c = 344;    %velocidad de sonido
f = 1000;   %frecuencia
w = 2*pi*f; %frecuencia angular
l = c/f;    %longitud de onda
k = w/c;    %numero de onda
A = 1.0;    %amplitud
ro = 1.18;  %densidad del aire
P0 = 2e-5;  %presion de referencia

%% malla todos los puntos del plano
Lx = 10;
Ly = 10;
dx = 0.1;
dy = 0.1;

%plano (x,y) en z = 0
[x,y] = meshgrid(-Lx:dx:Lx,-Ly:dy:Ly);
z = 0;

%% posicion de las fuentes

%fuente 1
x1 =  11.00;
y1 =   0.25;
z1 =   0.00;
%fuente 2
x2 =  11.00;
y2 =  -0.25;
z2 =   0.00;

%% distancias
r1 = sqrt( (x-x1).^2 + (y-y1).^2 + (z-z1).^2 );
r2 = sqrt( (x-x2).^2 + (y-y2).^2 + (z-z2).^2 );

%% presiones
t = 0;
p1 = A*exp(j*(w*t - k*r1))./r1;
p2 = A*exp(j*(w*t - k*r2))./r2;

%% presion total
pt = p1 + p2;
P = abs(pt);
Prms = P/sqrt(2);
Lp = 20*log10(Prms/P0);

%% figuras
figure(1)
surf(x,y,Prms,'FaceColor','interp',...
                'EdgeColor','none',...
                'FaceLighting','phong');
title('distribucion de la presion sonora rms total');
xlabel('x (m)');
ylabel('y (m)');
zlabel('Prms (Pa)');
axis([-Lx, Lx,-Ly, Ly, min(min(Prms)), max(max(Prms))]);
view(0,90);
daspect([1,1,1]);
grid on;
box on;
colormap jet;
colorbar;

figure(2)
surf(x,y,Prms,'FaceColor','interp',...
                'EdgeColor','none',...
                'FaceLighting','phong');
title('distribucion de la presion sonora rms total');
xlabel('x (m)');
ylabel('y (m)');
zlabel('Prms (Pa)');
axis([-Lx, Lx,-Ly, Ly, min(min(Prms)), max(max(Prms))]);
daspect([1,1,0.1]);
grid on;
box on;
colormap jet;
colorbar;

%% figuras
figure(3)
surf(x,y,Lp,'FaceColor','interp',...
                'EdgeColor','none',...
                'FaceLighting','phong');
title('distribucion del nivel de presion sonora total');
xlabel('x (m)');
ylabel('y (m)');
zlabel('Lp (dB)');
axis([-Lx, Lx,-Ly, Ly, min(min(Lp)), max(max(Lp))]);
view(0,90);
daspect([1,1,1]);
grid on;
box on;
colormap jet;
colorbar;

figure(4)
surf(x,y,Lp,'FaceColor','interp',...
                'EdgeColor','none',...
                'FaceLighting','phong');
title('distribucion del nivel de presion sonora total');
xlabel('x (m)');
ylabel('y (m)');
zlabel('Lp (sB)');
axis([-Lx, Lx,-Ly, Ly, 0, max(max(Lp))+10]);
daspect([1,1,10]);
grid on;
box on;
colormap jet;
colorbar;

NC = 100;
figure(5)
contour(x,y,Prms,NC);
title('distribucion de la presion sonora rms total');
xlabel('x (m)');
ylabel('y (m)');
zlabel('Prms (Pa)');
axis([-Lx, Lx,-Ly, Ly, min(min(Prms)), max(max(Prms))]);
view(0,90);
daspect([1,1,1]);
grid on;
box on;
colormap jet;
colorbar;

figure(6)
contour3(x,y,Prms,NC);
title('distribucion de la presion sonora rms total');
xlabel('x (m)');
ylabel('y (m)');
zlabel('Prms (Pa)');
axis([-Lx, Lx,-Ly, Ly, min(min(Prms)), max(max(Prms))]);
daspect([1,1,0.1]);
grid on;
box on;
colormap jet;
colorbar;

%% calculo de la velocidad de particulas
%
%               gradient(P)     1   (  dP    dP  )
% u = (ux,uy) = ----------- = ------( ----, ---- )
%                 j*ro*w      j*ro*w(  dx    dy  )
%
dx = 0.2;
dy = 0.2;
[ux,uy] = gradient(P,dx,dy);
ux = -ux/(ro*w);
uy = -uy/(ro*w);
uxy = -sqrt( ux.^2 + uy.^2 );

figure(7)
contour(x,y,Prms,NC);       %contorno 2D
hold on;                    %se usa para no borrar lo dibujado
quiver(x,y,ux,uy);          %dibuja flechas 2D 
title('presion sonora contorno  2D con flechas velocidad de particulas 2D');
xlabel('x (m)');
ylabel('y (m)');
zlabel('P(x,y) (Pa)');
daspect([1 1 1]);
grid on;
box on;
colormap jet;
colorbar;
