%% prog analisis de frecuencia 3
clearvars;
close all;
clc;

%% incializaciacion

%datos
f = 5000;         %frecuencia de sonido
fs = 44100;       %frecuencia de muestreo
dt = 1/fs;        %intervalo de muestreo
A = 1.0;          %amplitud sonido
t = (0:dt:50)';   %tiempo (el signo ' es trasnpuesta cuidado porque conjuga) 
N = length(t);    %longitud de seal y del tiempo

% ejes graficos
tmin = min(t);
tmax = max(t);
Amin = -1.5*A;
Amax =  1.5*A;

%% senhal tiempo

%senoides
x1 = 2*(rand(N,1) - 0.5);       %senhal entrada ruido aleatoreo
x2 = zeros(N,1);                %senhal salida inicializada con ceros

%% filtro pasa bajo

fcpb = 5000;          %frecuencia de corte
Q = 1/sqrt(2);        %factor de calidad o agudeza

K = tan(pi*fcpb/fs);  %factor de normalizacion

%coeficientes del filtro pasa bajo
b0 = (Q*K^2)/(Q*K^2 + Q + K);
b1 = (2*Q*K^2)/(Q*K^2 + Q + K);
b2 = (Q*K^2)/(Q*K^2 + Q + K);
a1 = (2*Q*(K^2-1))/(Q*K^2 + Q + K);
a2 = (Q*K^2 + Q - K)/(Q*K^2 + Q + K);

%prelocalizamos la seal de salida
ypb = zeros(N,1);

%procesamiento principal
for n = 3:N
    x2(n) = b0*x1(n) + b1*x1(n-1) + b2*x1(n-2) - a1*x2(n-1) - a2*x2(n-2);
end;

%% senhal en la frecuencia

%usamos la fuencion fft()
X1 = fft(x1)/N;
X2 = fft(x2)/N;

%datos frecuancia
df = fs/N;
f = ( 0:df:(fs - df))';

% ejes graficos
fmin = min(f);
fmax = max(f);
Amin = -1.5*A;
Amax =  1.5*A;

%% graficos

%figura 1 graficos x1(t) X1(f)
figure(1)

subplot(2,2,1)
plot(t,x1);
title('ruido');
xlabel('t (t)');
ylabel('x_1(t) (Pa)');
legend('x_1(t)');
axis([tmin,tmax,Amin,Amax]);
grid on;
box on;

subplot(2,2,2)
plot(f,real(X1));
title('FFT ruido parte real bilateral');
xlabel('f (Hz)');
ylabel('Re{X_1(f)} (Pa)');
legend('Re{X_1(f)}');
axis([fmin,fmax,Amin,Amax]);
grid on;
box on;

subplot(2,2,3)
plot(f,imag(X1));
title('FFT ruido parte imaginaria bilateral');
xlabel('f (Hz)');
ylabel('Im{X_1(f)} (Pa)');
legend('Im{X_1(f)}');
axis([fmin,fmax,Amin,Amax]);
grid on;
box on;


subplot(2,2,4)
plot(f,abs(X1));
title('FFT ruido modulo bilateral');
xlabel('f (Hz)');
ylabel('|X_1(f)| (Pa)');
legend('|X_1(f)|');
axis([fmin,fmax,-0.1*Amax,Amax]);
grid on;
box on;

figure(2)

subplot(2,1,1)
semilogy(f(1:round(N/2)),[abs(X1(1));2*abs( X1(2:round(N/2)))]);
title('FFT ruido modulo unilateral');
xlabel('f (Hz)');
ylabel('|X_1(f)| (Pa)');
legend('|X_1(f)|');
axis([fmin,round(fmax/2),1e-6*Amax,Amax]);
grid on;
box on;

subplot(2,1,2)
plot(f(1:round(N/2)),angle( X1(1:round(N/2)) ));
title('FFT ruido fase unilateral');
xlabel('f (Hz)');
ylabel('|X_1(f)| (Pa)');
legend('|X_1(f)|');
axis([fmin,round(fmax/2),-1.5*pi,1.5*pi]);
grid on;
box on;



%figura 2 graficos x2(t) X2(f)
figure(3)

subplot(2,2,1)
plot(t,x2);
title('ruido filtrado');
xlabel('t (t)');
ylabel('x_2(t) (Pa)');
legend('x_2(t)');
axis([tmin,tmax,Amin,Amax]);
grid on;
box on;

subplot(2,2,2)
plot(f,real(X2));
title('FFT ruido filtrado parte real bilateral');
xlabel('f (Hz)');
ylabel('Re{X_2(f)} (Pa)');
legend('Re{X_2(f)}');
axis([fmin,fmax,Amin,Amax]);
grid on;
box on;

subplot(2,2,3)
plot(f,imag(X2));
title('FFT ruido filtrado parte imaginaria bilateral');
xlabel('f (Hz)');
ylabel('Im{X_2(f)} (Pa)');
legend('Im{X_2(f)}');
axis([fmin,fmax,Amin,Amax]);
grid on;
box on;


subplot(2,2,4)
plot(f,abs(X2));
title('FFT ruido filtrado modulo bilateral');
xlabel('f (Hz)');
ylabel('|X_2(f)| (Pa)');
legend('|X_2(f)|');
axis([fmin,fmax,-0.1*Amax,Amax]);
grid on;
box on;

figure(4)

subplot(2,1,1)
semilogy(f(1:round(N/2)),[abs(X2(1));2*abs( X2(2:round(N/2)))]);
title('FFT ruido filtrado modulo unilateral');
xlabel('f (Hz)');
ylabel('|X_2(f)| (Pa)');
legend('|X_2(f)|');
axis([fmin,round(fmax/2),1e-6*Amax,Amax]);
grid on;
box on;

subplot(2,1,2)
plot(f(1:round(N/2)),angle( X2(1:round(N/2)) ));
title('FFT ruido filtrado fase unilateral');
xlabel('f (Hz)');
ylabel('|X_2(f)| (Pa)');
legend('|X_2(f)|');
axis([fmin,round(fmax/2),-1.5*pi,1.5*pi]);
grid on;
box on;

%% densidad espectral de potencia

%no se puede determinar la transformada de fourier de una senhal
%aleatorea o de una senhal contaminada por ruido, pero se puede calcular
%la densidad espectral de potencia que es un estimador, es decir determina
%de forma aproximada el mdulo al cuadrado del espectro de una senhal

Nit = 4*4410;
Nov = 0.75;

[Sxx1,fx1] = pwelch(x1,Nit,round(Nov*Nit),Nit,fs);
[Sxx2,fx2] = pwelch(x2,Nit,round(Nov*Nit),Nit,fs);

%densidad espectral cruzada
Sxx12 = cpsd(x1,x2,Nit,round(Nov*Nit),Nit,fs);

%respuesta de frecuencia H1
H1 = Sxx2./Sxx1;

%respuesta de frecuencia H2
H2 = Sxx12./Sxx1;

%respuesta impulsiva
h = ifft(H2);

figure(7)

subplot(3,1,1)
semilogy(fx1,Sxx1);
title('PSD ruido');
xlabel('f (Hz)');
ylabel('Sxx1(f) (Pa)');
legend('Sxx1(f)');
axis([min(fx1),max(fx1),1e-10,max(Sxx1)*100] );
grid on;
box on;

subplot(3,1,2)
semilogy(fx2,Sxx2);
title('PSD ruido filtrado');
xlabel('f (Hz)');
ylabel('Sxx2(f) (Pa)');
legend('Sxx2(f)');
axis([min(fx2),max(fx2),1e-10,max(Sxx2)*100] );
grid on;
box on;

subplot(3,1,3)
semilogy(fx2,H1);
title('modulo respuesta de frecuencia H_1(f)');
xlabel('f (Hz)');
ylabel('H_1(f) (Pa)');
legend('H_1(f)');
axis([min(fx2),max(fx2),1e-10,max(H1)*100] );
grid on;
box on;

figure(8)

subplot(2,1,1)
semilogy(fx2,abs(H2));
title('modulo respuesta de frecuencia H_2(f)');
xlabel('f (Hz)');
ylabel('|H_2(f)| (Pa)');
legend('|X_2(f)|');
axis([min(fx2),max(fx2),1e-10,max(H1)*100]);
grid on;
box on;

subplot(2,1,2)
plot(fx2,angle(H2));
title('fase respuesta de frecuencia H_2(f)');
xlabel('f (Hz)');
ylabel('|H_2(f)| (Pa)');
legend('|H_2(f)|');
axis([min(fx2),max(fx2),-1.5*pi,1.5*pi]);
grid on;
box on;
