%% prog analisis de frecuencia 2
clearvars;
close all;
clc;



%% incializaciacion

%datos
f = 5000;         %frecuencia de sonido
fs = 44100;       %frecuencia de muestreo
dt = 1/fs;        %intervalo de muestreo
A = 1.0;          %amplitud sonido
t = (0:dt:50)';   %tiempo (el signo ' es trasnpuesta cuidado porque conjuga) 
N = length(t);    %longitud de seal y del tiempo

% ejes graficos
tmin = min(t);
tmax = max(t);
Amin = -1.5*A;
Amax =  1.5*A;

%% senhal tiempo

%senoides
x1 = A*sin(2*pi*f*t);           %senhal senoidal
x2 = 2*(rand(N,1) - 0.5);       %senhal ruido aleatoreo
x3 = 0.01*x1 + 0.99*x2;         %senhal + ruido

%% senhal en la frecuencia

%usamos la fuencion fft()
X1 = fft(x1)/N;
X2 = fft(x2)/N;
X3 = fft(x3)/N;

%datos frecuancia
df = fs/N;
f = ( 0:df:(fs - df))';

% ejes graficos
fmin = min(f);
fmax = max(f);
Amin = -1.5*A;
Amax =  1.5*A;

%% graficos

%figura 1 graficos x1(t) X1(f)
figure(1)

subplot(2,2,1)
plot(t,x1);
title('onda senoidal');
xlabel('t (t)');
ylabel('x_1(t) (Pa)');
legend('x_1(t)');
axis([tmin,tmax,Amin,Amax]);
grid on;
box on;

subplot(2,2,2)
plot(f,real(X1));
title('FFT onda senoidal parte real bilateral');
xlabel('f (Hz)');
ylabel('Re{X_1(f)} (Pa)');
legend('Re{X_1(f)}');
axis([fmin,fmax,Amin,Amax]);
grid on;
box on;

subplot(2,2,3)
plot(f,imag(X1));
title('FFT onda senoidal parte imaginaria bilateral');
xlabel('f (Hz)');
ylabel('Im{X_1(f)} (Pa)');
legend('Im{X_1(f)}');
axis([fmin,fmax,Amin,Amax]);
grid on;
box on;


subplot(2,2,4)
plot(f,abs(X1));
title('FFT onda senoidal modulo bilateral');
xlabel('f (Hz)');
ylabel('|X_1(f)1 (Pa)');
legend('|X_1(f)|');
axis([fmin,fmax,-0.1*Amax,Amax]);
grid on;
box on;

figure(2)

subplot(2,1,1)
semilogy(f(1:round(N/2)),[abs(X1(1));2*abs( X1(2:round(N/2)))]);
title('FFT onda senoidal modulo unilateral');
xlabel('f (Hz)');
ylabel('|X_1(f)1 (Pa)');
legend('|X_1(f)|');
axis([fmin,round(fmax/2),1e-6*Amax,Amax]);
grid on;
box on;

subplot(2,1,2)
plot(f(1:round(N/2)),angle( X1(1:round(N/2)) ));
title('FFT onda senoidal fase unilateral');
xlabel('f (Hz)');
ylabel('|X_1(f)1 (Pa)');
legend('|X_1(f)|');
axis([fmin,round(fmax/2),-1.5*pi,1.5*pi]);
grid on;
box on;



%figura 2 graficos x2(t) X2(f)
figure(3)

subplot(2,2,1)
plot(t,x2);
title('ruido');
xlabel('t (t)');
ylabel('x_2(t) (Pa)');
legend('x_2(t)');
axis([tmin,tmax,Amin,Amax]);
grid on;
box on;

subplot(2,2,2)
plot(f,real(X2));
title('FFT ruido parte real bilateral');
xlabel('f (Hz)');
ylabel('Re{X_2(f)} (Pa)');
legend('Re{X_2(f)}');
axis([fmin,fmax,Amin,Amax]);
grid on;
box on;

subplot(2,2,3)
plot(f,imag(X2));
title('FFT ruido parte imaginaria bilateral');
xlabel('f (Hz)');
ylabel('Im{X_2(f)} (Pa)');
legend('Im{X_2(f)}');
axis([fmin,fmax,Amin,Amax]);
grid on;
box on;


subplot(2,2,4)
plot(f,abs(X2));
title('FFT ruido modulo bilateral');
xlabel('f (Hz)');
ylabel('|X_2(f)1 (Pa)');
legend('|X_2(f)|');
axis([fmin,fmax,-0.1*Amax,Amax]);
grid on;
box on;

figure(4)

subplot(2,1,1)
semilogy(f(1:round(N/2)),[abs(X2(1));2*abs( X2(2:round(N/2)))]);
title('FFT ruido modulo unilateral');
xlabel('f (Hz)');
ylabel('|X_2(f)1 (Pa)');
legend('|X_2(f)|');
axis([fmin,round(fmax/2),1e-6*Amax,Amax]);
grid on;
box on;

subplot(2,1,2)
plot(f(1:round(N/2)),angle( X2(1:round(N/2)) ));
title('FFT ruido fase unilateral');
xlabel('f (Hz)');
ylabel('|X_2(f)1 (Pa)');
legend('|X_2(f)|');
axis([fmin,round(fmax/2),-1.5*pi,1.5*pi]);
grid on;
box on;


%figura 3 graficos x3(t) X3(f)
figure(5)

subplot(2,2,1)
plot(t,x3);
title('senhal + ruido');
xlabel('t (t)');
ylabel('x_3(t) (Pa)');
legend('x_3(t)');
axis([tmin,tmax,-1.5*Amax,1.5*Amax]);
grid on;
box on;

subplot(2,2,2)
plot(f,real(X3));
title('FFT senhal + ruido parte real bilateral');
xlabel('f (Hz)');
ylabel('Re{X_3(f)} (Pa)');
legend('Re{X_3(f)}');
axis([fmin,fmax,-1.5*max(abs(X3)),1.5*max(abs(X3))]);
grid on;
box on;

subplot(2,2,3)
plot(f,imag(X3));
title('FFT senhal + ruido parte imaginaria bilateral');
xlabel('f (Hz)');
ylabel('Im{X_3(f)} (Pa)');
legend('Im{X_3(f)}');
axis([fmin,fmax,-1.5*max(abs(X3)),1.5*max(abs(X3))]);
grid on;
box on;


subplot(2,2,4)
plot(f,abs(X3));
title('FFT senhal + ruido modulo bilateral');
xlabel('f (Hz)');
ylabel('|X_3(f)1 (Pa)');
legend('|X_3(f)|');
axis([fmin,fmax,-1.5*max(abs(X3)),1.5*max(abs(X3))]);
grid on;
box on;

figure(6)

subplot(2,1,1)
semilogy(f(1:round(N/2)),[abs(X3(1));2*abs( X3(2:round(N/2)))]);
title('FFT senhal + ruido modulo unilateral');
xlabel('f (Hz)');
ylabel('|X_3(f)1 (Pa)');
legend('|X_3(f)|');
axis([fmin,round(fmax/2),min(abs(X3))/10,max(abs(X3))*10] );
grid on;
box on;

subplot(2,1,2)
plot(f(1:round(N/2)),angle( X3(1:round(N/2)) ));
title('FFT senhal + ruido fase unilateral');
xlabel('f (Hz)');
ylabel('|X_3(f)1 (Pa)');
legend('|X_3(f)|');
axis([fmin,round(fmax/2),-1.5*pi,1.5*pi]);
grid on;
box on;


%% densidad espectral de potencia

%no se puede determinar la transformada de fourier de una senhal
%aleatorea o de una senhal contaminada por ruido, pero se puede calcular
%la densidad espectral de potencia que es un estimador, es decir determina
%de forma aproximada el mdulo al cuadrado del espectro de una senhal

%pkg load signal% incializa en octave el analisis de senhales

Nit = 4*4410;
Nov = 0.75;

[Sxx1,fx1] = pwelch(x1,Nit,round(Nov*Nit),Nit,fs);
[Sxx2,fx2] = pwelch(x2,Nit,round(Nov*Nit),Nit,fs);
[Sxx3,fx3] = pwelch(x1,Nit,round(Nov*Nit),Nit,fs);

figure(7)

subplot(3,1,1)
semilogy(fx1,Sxx1);
title('PSD senhal senoidal');
xlabel('f (Hz)');
ylabel('Sxx1(f) (Pa)');
legend('Sxx1(f)');
axis([min(fx1),max(fx1),1e-10,max(Sxx1)*100] );
grid on;
box on;

subplot(3,1,2)
semilogy(fx2,Sxx2);
title('PSD ruido');
xlabel('f (Hz)');
ylabel('Sxx2(f) (Pa)');
legend('Sxx2(f)');
axis([min(fx2),max(fx2),1e-10,max(Sxx2)*100] );
grid on;
box on;

subplot(3,1,3)
semilogy(fx3,Sxx3);
title('PSD ruido');
xlabel('f (Hz)');
ylabel('Sxx3(f) (Pa)');
legend('Sxx3(f)');
axis([min(fx3),max(fx3),1e-10,max(Sxx3)*100] );
grid on;
box on;
