%% prog analisis de frecuencia
clearvars;
close all;
clc;

%% incializaciacion

%datos
f = 5000;         %frecuencia de sonido
fs = 44100;       %frecuencia de muestreo
dt = 1/fs;        %intervalo de muestreo
A = 1.0;          %amplitud sonido
t = (0:dt:10)';   %tiempo (el signo ' es trasnpuesta cuidado porque conjuga) 
N = length(t);    %longitud de seal y del tiempo

% ejes graficos
tmin = min(t);
tmax = max(t);
Amin = -1.5*A;
Amax =  1.5*A;

%% senhal tiempo

%senoides
x1 = A*sin(2*pi*f*t);    %senhal senoidal
x2 = A*cos(2*pi*f*t);    %senhal cosenoidal

%pulso cuadrado
x3 = zeros(N,1);
x3(1:round(N/1e4)) = 1;

%% senhal en la frecuencia

%usamos la fuencion fft()
X1 = fft(x1)/N;
X2 = fft(x2)/N;
X3 = fft(x3)/N;

%datos frecuancia
df = fs/N;
f = ( 0:df:(fs - df))';

% ejes graficos
fmin = min(f);
fmax = max(f);
Amin = -1.5*A;
Amax =  1.5*A;

%% graficos

%figura 1 graficos x1(t) X1(f)
figure(1)

subplot(2,2,1)
plot(t,x1);
title('onda senoidal');
xlabel('t (t)');
ylabel('x_1(t) (Pa)');
legend('x_1(t)');
axis([tmin,tmax,Amin,Amax]);
grid on;
box on;

subplot(2,2,2)
plot(f,real(X1));
title('FFT onda senoidal parte real bilateral');
xlabel('f (Hz)');
ylabel('Re{X_1(f)} (Pa)');
legend('Re{X_1(f)}');
axis([fmin,fmax,Amin,Amax]);
grid on;
box on;

subplot(2,2,3)
plot(f,imag(X1));
title('FFT onda senoidal parte imaginaria bilateral');
xlabel('f (Hz)');
ylabel('Im{X_1(f)} (Pa)');
legend('Im{X_1(f)}');
axis([fmin,fmax,Amin,Amax]);
grid on;
box on;


subplot(2,2,4)
plot(f,abs(X1));
title('FFT onda senoidal modulo bilateral');
xlabel('f (Hz)');
ylabel('|X_1(f)1 (Pa)');
legend('|X_1(f)|');
axis([fmin,fmax,-0.1*Amax,Amax]);
grid on;
box on;

figure(2)

subplot(2,1,1)
semilogy(f(1:round(N/2)),[abs(X1(1));2*abs( X1(2:round(N/2)))]);
title('FFT onda senoidal modulo unilateral');
xlabel('f (Hz)');
ylabel('|X_1(f)1 (Pa)');
legend('|X_1(f)|');
axis([fmin,round(fmax/2),1e-6*Amax,Amax]);
grid on;
box on;

subplot(2,1,2)
plot(f(1:round(N/2)),angle( X1(1:round(N/2)) ));
title('FFT onda senoidal fase unilateral');
xlabel('f (Hz)');
ylabel('|X_1(f)1 (Pa)');
legend('|X_1(f)|');
axis([fmin,round(fmax/2),-1.5*pi,1.5*pi]);
grid on;
box on;



%figura 2 graficos x2(t) X2(f)
figure(3)

subplot(2,2,1)
plot(t,x2);
title('onda cosenoidal');
xlabel('t (t)');
ylabel('x_2(t) (Pa)');
legend('x_2(t)');
axis([tmin,tmax,Amin,Amax]);
grid on;
box on;

subplot(2,2,2)
plot(f,real(X2));
title('FFT onda cosenoidal parte real bilateral');
xlabel('f (Hz)');
ylabel('Re{X_2(f)} (Pa)');
legend('Re{X_2(f)}');
axis([fmin,fmax,Amin,Amax]);
grid on;
box on;

subplot(2,2,3)
plot(f,imag(X2));
title('FFT onda cosenoidal parte imaginaria bilateral');
xlabel('f (Hz)');
ylabel('Im{X_2(f)} (Pa)');
legend('Im{X_2(f)}');
axis([fmin,fmax,Amin,Amax]);
grid on;
box on;


subplot(2,2,4)
plot(f,abs(X2));
title('FFT onda cosenoidal modulo bilateral');
xlabel('f (Hz)');
ylabel('|X_2(f)1 (Pa)');
legend('|X_2(f)|');
axis([fmin,fmax,-0.1*Amax,Amax]);
grid on;
box on;

figure(4)

subplot(2,1,1)
semilogy(f(1:round(N/2)),[abs(X2(1));2*abs( X2(2:round(N/2)))]);
title('FFT onda cosenoidal modulo unilateral');
xlabel('f (Hz)');
ylabel('|X_2(f)1 (Pa)');
legend('|X_2(f)|');
axis([fmin,round(fmax/2),1e-6*Amax,Amax]);
grid on;
box on;

subplot(2,1,2)
plot(f(1:round(N/2)),angle( X2(1:round(N/2)) ));
title('FFT onda cosenoidal fase unilateral');
xlabel('f (Hz)');
ylabel('|X_2(f)1 (Pa)');
legend('|X_2(f)|');
axis([fmin,round(fmax/2),-1.5*pi,1.5*pi]);
grid on;
box on;


%figura 3 graficos x3(t) X3(f)
figure(5)

subplot(2,2,1)
plot(t,x3);
title('pulso cuadrado');
xlabel('t (t)');
ylabel('x_3(t) (Pa)');
legend('x_3(t)');
axis([tmin,tmax,-0.1,Amax]);
grid on;
box on;

subplot(2,2,2)
plot(f,real(X3));
title('FFT pulso cuadrado parte real bilateral');
xlabel('f (Hz)');
ylabel('Re{X_3(f)} (Pa)');
legend('Re{X_3(f)}');
axis([fmin,fmax,-1.5*max(abs(X3)),1.5*max(abs(X3))]);
grid on;
box on;

subplot(2,2,3)
plot(f,imag(X3));
title('FFT pulso cuadrado parte imaginaria bilateral');
xlabel('f (Hz)');
ylabel('Im{X_3(f)} (Pa)');
legend('Im{X_3(f)}');
axis([fmin,fmax,-1.5*max(abs(X3)),1.5*max(abs(X3))]);
grid on;
box on;


subplot(2,2,4)
plot(f,abs(X3));
title('FFT pulso cuadrado modulo bilateral');
xlabel('f (Hz)');
ylabel('|X_3(f)1 (Pa)');
legend('|X_3(f)|');
axis([fmin,fmax,-1.5*max(abs(X3)),1.5*max(abs(X3))]);
grid on;
box on;

figure(6)

subplot(2,1,1)
semilogy(f(1:round(N/2)),[abs(X3(1));2*abs( X3(2:round(N/2)))]);
title('FFT pulso cuadrado modulo unilateral');
xlabel('f (Hz)');
ylabel('|X_3(f)1 (Pa)');
legend('|X_3(f)|');
axis([fmin,round(fmax/2),min(abs(X3))/10,max(abs(X3))*10] );
grid on;
box on;

subplot(2,1,2)
plot(f(1:round(N/2)),angle( X3(1:round(N/2)) ));
title('FFT pulso cuadrado fase unilateral');
xlabel('f (Hz)');
ylabel('|X_3(f)1 (Pa)');
legend('|X_3(f)|');
axis([fmin,round(fmax/2),-1.5*pi,1.5*pi]);
grid on;
box on;
