%% prog4 diferencias finitas


clear all;
close all;
clc;

%% datos iniciales

m = 1;              %masa (kg)
c = 1;        	    %amortiguador viscoso (kg/s)
k = 4;              %resorte (N/m)
ti = 0;             %tiempo incial (s)
tf = 100;           %tiempo final  (s)
dt = 0.0001;        %intervalo de tiempo (s)
t = ti:dt:tf;       %vector de tiempo (s)
xmin = -2.5;        %minimo
xmax = 2.5;         %maximo

x1 = 1;         %posicion incial (m)
v1 = 0;         %velocidad inicial (m/s)

%dimension tiempo
Nt = length(t);
N = Nt-1; 

%fuerza 

f(1:Nt) = 0;            %fuerza inicializada con ceros

for n = 1:round(Nt/10)
    f(n) = 0.5*t(n);
end;

f(round(Nt/10)+1:round(2*Nt/10))   = f(1:round(Nt/10));

f(round(2*Nt/10)+1:round(3*Nt/10)) = f(1:round(Nt/10));

f(round(3*Nt/10)+1:round(4*Nt/10)) = f(1:round(Nt/10));

f(round(4*Nt/10)+2:round(5*Nt/10)) = f(1:round(Nt/10));

f(round(5*Nt/10)+1:round(6*Nt/10)) = f(1:round(Nt/10));

f(round(6*Nt/10)+1:round(7*Nt/10)) = f(1:round(Nt/10));

f(round(7*Nt/10)+1:round(8*Nt/10)) = f(1:round(Nt/10));

f(round(8*Nt/10)+1:round(9*Nt/10)) = f(1:round(Nt/10));

f(round(9*Nt/10)+1:round(Nt))      = f(1:round(Nt/10));

%% grafico
figure(1)
plot(t,f);
title('fuerza');
xlabel('tiempo t (s)');
ylabel('fuerza f(t) (N)');
axis([t(1) t(Nt) -0.5 5.5]);
grid on;
box on;


%% proceso principal

w0 = sqrt(k/m);
fs = 1/dt;

%inicializacion de la solucion
xn = zeros(1,Nt);   

%posicion inicial t = 0
xn(1) = x1;    

%fuerza inicial t = 0
f1 = f(1);    

%aceleracion inicial t = 0
a1 = ( f1 - c*v1 - k*x1 )/m;

%posicion inicial t = dt
xn(2) = x1 + v1*dt + 1/2*a1*dt^2;

%coeficientes 
cof1 = m/dt/dt + c/2/dt;
cof2 = k - 2*m/dt/dt; 
cof3 = m/dt/dt - c/2/dt;

%loop para los demas puntos
for j = 2:N 

    xn(j+1) = ( f(j) - cof2*xn(j) - cof3*xn(j-1) )/cof1;
        
end;

%% grafico
      
figure(2)
plot(t,xn);
title('solucion');
xlabel('tiempo t (s)');
ylabel('posicion x(t) (m)');
axis([t(1) t(Nt) -0.6 1.4]);
grid on;
box on;

