%% prog006 metodo de euler 02

%originalmente esta es la ecuacin

% dy
%---- + exp(-y)*t = 0
% dt

% con condicion incial
%y(0) = 1


%la cual puede ser acomodada

% dy
%---- = f(t,y) =  - exp(-y)*t
% dt

clearvars;
close all;
clc;

%% incializacion

%valores inciales
tini = 0;
tfin = 3*pi;
y0 = 1;
t0 = tini;

%incremento
deltat = 1/600;

%valores de tn por prelocalizacin
tn = tini:deltat:tfin;      %valores de t
Nn = length(tn);            %tamanho de t

%valores yn por prelocalizacin
yn = zeros(1,Nn);	%incialmente lleno de ceros
yn(1) = y0;         %condicion incial

%% solucion analitica
% adeltat = 1/5000;
% t_analitic = tini:adeltat:tfin;
% y_analitic = exp(-t_analitic.^2);

%% campo direccional y solucion analitica

%espacio de estados inciales
Lt0 = tini;
Lt = tfin;
Ly0 = 0;
Ly = 1.5;
dt = 0.05;
dy = 0.05;

[t0,y0] = meshgrid(Lt0:dt:Lt,Ly0:dy:Ly);

%velocidad incial
v0 = - exp(-y0).*t0; %v0 = dy/dt

%vector
figure(1)
quiver(t0,y0,y0,v0,'r');          %dibuja flechas 2D 
title('campo direccional');
xlabel('t_0 (s)');
ylabel('y_0 (m/s)');
legend('campdir')
axis([Lt0 Lt Ly0 Ly]);
grid on;


%% solucion numerica

%solucion 
for n = 1:Nn-1
    fty = - exp(-y0(n)).*t0(n);
    yn(n+1) = yn(n) + fty*deltat;
end;

%% solucion

figure(2)
quiver(t0,y0,y0,v0,'r');
hold on;
plot(tn,yn,'k -');
hold off;
title('campo direccional y solucion numerica');
xlabel('t_0 (s)');
ylabel('y_0 (m)');
legend('campdir','y(t)_{numeric}');
axis([Lt0 Lt Ly0 Ly]);
grid on;


%este metodo posee muchas limitaciones inclusive para pequeos valores de
%deltat puede traer errores hasta del 35% en pocas iteraciones

