%% prog5 metodo de euler

clearvars;
close all;
clc;

%% incializacion

%ecuacion diferencial no lineal
% y'' + mu*y' - y^2 +a^2 = sin(t)

%uso de variable auxiliar
% y' = u <------------------------------------> u = y'
% y'' = (-mu*y' - y^2 +a^2) + sin(t) <-----------------> u' = sin(t) - mu*(y')^2 + y^2 - a^2

%datos
mu = 1;
a = 2;

%tiempo incial/final
tini =  -1;
tfin =  100;

%valores inciales%
y0 =  2;     %posicin incial
u0 = -1;     %velocidad incial u(0) = y'(0)

%incrementos
deltat = 0.01;

%valores de xn por prelocalizacin
tn = tini:deltat:tfin;	%valores de tn
Nn = length(tn);        %tamanho de tn

%valores yn por prelocalizacin
yn = zeros(1,Nn);     %incialmente lleno de ceros

%valores un por prelocalizacin
un = zeros(1,Nn);     %incialmente lleno de ceros

%condicion incial de desplazamiento
yn(1) = y0;         %condicion incial desplazamiento

%condicion inicial de velocidad
un(1) = u0;         %condicion incial velocidad u(0) = y'(0)


%% solucion numrica
for n = 1:Nn-1
    
    yn(n+1) = yn(n) + deltat*un(n);
    un(n+1) = un(n) + deltat*(sin(tn(n)) - mu*un(n) + yn(n)^2 - a^2 );
                               
end;

%% espacio de fase

Lyini = -1.1*max(abs(yn));
Lyfin =  1.1*max(abs(yn));
dy = 0.05;

Luini = -1.1*max(abs(un));
Lufin =  1.1*max(abs(un));
du = 0.05;

Tini = -1.1*max(abs(un));
Tfin =  1.1*max(abs(un));
dt = 0.05;

%espacio de estados inciales
[y0,u0] = meshgrid(Lyini:dy:Lyfin,Luini:du:Lufin);

%tiempo
t0 = meshgrid(Lyini:dy:Lyfin,Luini:du:Lufin);

%aceleracion
v0 = cos(t0) -mu*u0 + y0.^2 - a^2;
     
%vector
figure(1)
quiver(y0,u0,u0,v0,'r');          %dibuja flechas 2D 
title('espacio de fase');
xlabel('$$ y (m) $$','Interpreter','latex');
ylabel('$$ \frac{dy}{dt}\ (m/s) $$','Interpreter','latex')
legend('espfase');
daspect([1 1 1]);
axis([ -1.1*max(abs(yn)) 1.1*max(abs(yn)) 1.1*min(un) 1.1*max(un) ]); 
grid on;
box on;

%% resultados

figure(2)
plot(tn,yn,'k')
title('solucion euler desplazamiento');
xlabel('$$ t (s) $$','Interpreter','latex')
ylabel('$$ y(t) (m) $$','Interpreter','latex');
legend(['y \Deltat = ', num2str(deltat)])
axis([ tini tfin -1.1*max(abs(yn)) 1.1*max(abs(yn))]); 
grid on;
box on;

figure(3)
plot(tn,un,'k')
title('solucion euler velocidad');
xlabel('$$ t (s) $$','Interpreter','latex')
ylabel('$$ \frac{dy}{dt}\ (m/s) $$','Interpreter','latex')
legend(['dy/dt \Deltat = ' num2str(deltat)])
axis([ tini tfin 1.1*min(un) 1.1*max(un) ]); 
grid on;
box on;

figure(4)
plot(yn,un,'k')
title('diagrama de fase');
xlabel('$$ y(t) (m) $$','Interpreter','latex');
ylabel('$$ \frac{dy}{dt}\ (m/s) $$','Interpreter','latex');
legend(['y vs dy/dt \Deltat = ' num2str(deltat)])
axis([ -1.1*max(abs(yn)) 1.1*max(abs(yn)) 1.1*min(un) 1.1*max(un) ]); 
grid on;
box on;

figure(5)
quiver(y0,u0,u0,v0,'r');          %dibuja flechas 2D 
hold on;
plot(yn,un,'k')
title('espacio de fase y diagrama de fase');
xlabel('$$ y(t) (m) $$','Interpreter','latex');
ylabel('$$ \frac{dy}{dt}\ (m/s) $$','Interpreter','latex');
legend('espfase',['y vs dy/dt \Deltat = ', num2str(deltat)] );
daspect([1 1 1]);
axis([ -1.1*max(abs(yn)) 1.1*max(abs(yn)) 1.1*min(un) 1.1*max(un) ]); 
grid on;
box on;

