%% prog3 diferencias finitas

clear all;
close all;
clc;

%% datos iniciales

m = 1;              %masa (kg)
c = 1;        	    %amortiguador viscoso (kg/s)
k = 16;             %resorte (N/m)
ti = 0;             %tiempo incial (s)
tf = 100;           %tiempo final  (s)
dt = 0.0001;        %intervalo de tiempo (s)
t = ti:dt:tf;       %vector de tiempo (s)
xmin = -2.5;        %minimo
xmax = 2.5;         %maximo

x1 = 1;         %posicion incial (m)
v1 = 0;         %velocidad inicial (m/s)

%dimension tiempo
Nt = length(t);
N = Nt-1; 

%fuerza 

f(1:Nt) = 0;            %fuerza inicializada con ceros
for n = 1:Nt
    
    if (t(n) >= 0) && (t(n) <= 5)
        f(n) = 1;
    end;

    if (t(n) >= 10) && (t(n) <= 15)
        f(n) = 1;
    end;

    if (t(n) >= 20) && (t(n) <= 25)
        f(n) = 1;
    end;

    if (t(n) >= 30) && (t(n) <= 35)
        f(n) = 1;
    end;
    
    if (t(n) >= 40) && (t(n) <= 45)
        f(n) = 1;
    end;

    if (t(n) >= 50) && (t(n) <= 55)
        f(n) = 1;
    end;

    if (t(n) >= 60) && (t(n) <= 65)
        f(n) = 1;
    end;

    if (t(n) >= 70) && (t(n) <= 75)
        f(n) = 1;
    end;

    if (t(n) >= 80) && (t(n) <= 85)
        f(n) = 1;
    end;

    if (t(n) >= 90) && (t(n) <= 95)
        f(n) = 1;
    end;
        
    if (t(n) >= 95) && (t(n) <= 100)
        f(n) = 0;
    end;
    
end;

%% grafico
figure(1)
plot(t,f);
title('fuerza');
xlabel('tiempo t (s)');
ylabel('fuerza f(t) (N)');
axis([t(1) t(Nt) -0.5 1.5]);
grid on;
box on;


%% proceso principal
w0 = sqrt(k/m);
fs = 1/dt;
%inicializacion de la solucion
xn = zeros(1,Nt);   
%posicion inicial t = 0
xn(1) = x1;    
%fuerza inicial t = 0
f1 = f(1);    
%aceleracion inicial t = 0
a1 = ( f1 - c*v1 - k*x1 )/m;
%posicion inicial t = dt
xn(2) = x1 + v1*dt + 1/2*a1*dt^2;
%coeficientes 
cof1 = m/dt/dt + c/2/dt;
cof2 = k - 2*m/dt/dt; 
cof3 = m/dt/dt - c/2/dt;
%loop
for j = 2:N 

    xn(j+1) = ( f(j) - cof2*xn(j) - cof3*xn(j-1) )/cof1;
        
end;

%% grafico
figure(2)
plot(t,xn);
title('solucion');
xlabel('tiempo t (s)');
ylabel('posicion x(t) (m)');
axis([t(1) t(Nt) -0.5 1.5]);
grid on;
box on;