%% prog integral de Reyleygh piston cuadrado

clearvars;
close all;
clc;

%este programa calcula a partir de una aproximacin de la integral de
%reyleigh el campo sonoro producido por un pistn cuadrado/rectangular
%que vibra con una velocidad constante

%% datos inciales

f = 5000;       %frecuencia
c = 344;        %velocidad del sonido
w = 2*pi*f;     %frecuencia angular
la = c/f;       %longitud de onda
k = w/c;        %numero de onda
P0 = 2e-5;      %presion de referencia
ro = 1.18;      %densidad del aire

%% tiempo
t = 0;          %tiempo referencial

%% parametros fuente cuadrada/rectangular

%dimensiones
Ly = 5.0e-1;      %ancho
Lz = 2.5e-1;      %alto
Nfy = 51;       %numero de fuentes en y
Nfz = 51;       %numero de fuentes en z
dy = Ly/Nfy;    %elemento de longitud en y
dz = Lz/Nfy;    %elemento de longitud en z
dS = dy*dz;     %elemento de superficie
U1 = 5e-3;      %velocidad constante en todo el piston

%% posicionamiento de fuentes simples que forman el piston cuadrado/rectangular

%prelocalizacion
x0(1:Nfy*Nfz) = -0.001;
y0(1:Nfy*Nfz) =  0;
z0(1:Nfy*Nfz) =  0;
U0(1:Nfy*Nfz) =  0;

%contador
n = 1;

%posicionamiento de fuentes simples
for ny = 1:Nfy
    for nz = 1:Nfz
        y0(n) = (ny-1)*dy - Ly/2 + dy/2;
        z0(n) = (nz-1)*dz - Lz/2 + dz/2;
        U0(n) = U1*cos(4*pi*y0(n)/Ly).*cos(4*pi*y0(n)/Ly); 
        n = n + 1;
    end;
end;

%elemento de poder de fuente
dQ = dS*U0;     

%amplitud de fuente simple
A = (j*ro*c*dQ*k)/(2*pi);

N = length(y0);

figure(1)
plot(y0,z0,'o');
title('geometria de la fuente');
xlabel('y0 (m)');
ylabel('z0 (m)');
axis([-1.5*Ly/2,1.5*Ly/2,-1.5*Lz/2,1.5*Lz/2]);
daspect([1 1 1]);
grid on;
box on;

figure(2)
plot3(y0,z0,U0,'o');
title('velocidad de la fuente');
xlabel('y0 (m)');
ylabel('z0 (m)');
zlabel('U0 (m/s)');
axis([-1.5*Ly/2,1.5*Ly/2,-1.5*Lz/2,1.5*Lz/2,-1.5*U1,1.5*U1]);
grid on;
box on;


%% plano de recepcion (X,Y,0)        

%dimensiones
xmin = 0;
xmax = 20;
incx = 0.1;

ymin = -10;
ymax =  10;
incy = 0.1;

%grilla plano xy
[x1,y1] = meshgrid(xmin:incx:xmax,ymin:incy:ymax);
z1 = 0;                 %altura plano receptor

%longitud de la grilla
Nx1 = length(x1);       %longitud de la grilla en x1
Ny1 = length(y1);       %longitud de la grilla en y1

%prelocalizacion de las distancias como un arreglo 3D
rn1(1:N,1:Nx1,1:Ny1) = 0; 

%distancias
for n1 = 1:N
    rn1(n1,:,:) = sqrt( (x1-x0(n1)).^2 + (y1-y0(n1)).^2 + (z1-z0(n1)).^2 );
end;

%presion sonora prelocalizacion
P1c(1:Nx1,1:Ny1) = 0; %presion sonora compleja
P1(1:Nx1,1:Ny1) = 0;  %presion sonora en modulo del valor complejo amplitud

for n1 = 1:N
        pn(:,:) =  A(n1)*exp(j*(w*t - k*rn1(n1,:,:) ) )./(rn1(n1,:,:));
        P1c = P1c(:,:) + pn;
end;
P1 = abs(P1c);

%nivel de presion sonora
Lp1 = 20*log10(P1/P0/sqrt(2));

%% graficos plano (X,Y,0)

figure(3)
surf(x1,y1,P1,'FaceColor','interp',...
                'EdgeColor','none',...
                'FaceLighting','phong');
title('presion sonora plano xy z = 0');
xlabel('x (m)');
ylabel('y (m)');
zlabel('p (N/m^2)')
colormap jet
colorbar
grid on;
box on;

figure(4)
surf(x1,y1,Lp1,'FaceColor','interp',...
                'EdgeColor','none',...
                'FaceLighting','phong');
title('nivel de presion sonora plano xy z = 0');
xlabel('x (m)');
ylabel('y (m)');
zlabel('Lp (dB)')
colormap jet
colorbar
grid on;
box on;
  
figure(5)
plot( x1( round(Nx1/2),:),P1( round(Nx1/2),:) );
title('presin sonora axial');
xlabel('x (m)');
ylabel('Pax (N/m^2)');
grid on;
box on;
  
figure(6)
plot( x1( round(Nx1/2),:),Lp1( round(Nx1/2),:) );
title('nivel de presin sonora axial');
xlabel('x (m)');
ylabel('Pax (N/m^2)');
grid on;
box on;

%% plano de recepcion (10,Y,Z)        

%dimensiones
x2 = 10;

ymin = -10;
ymax =  10;
incy = 0.1;

zmin = -10;
zmax =  10;
incz = 0.1;


%grilla plano xy
[y2,z2] = meshgrid(ymin:incy:ymax,zmin:incz:zmax);
z1 = 0;                 %altura plano receptor

%longitud de la grilla
Ny2 = length(y2);       %longitud de la grilla en y2
Nz2 = length(z2);       %longitud de la grilla en z2

%prelocalizacion de las distancias como un arreglo 3D
rn2(1:N,1:Ny2,1:Nz2) = 0; 

%distancias
for n1 = 1:N
    rn2(n1,:,:) = sqrt( (x2-x0(n1)).^2 + (y2-y0(n1)).^2 + (z2-z0(n1)).^2 );
end;

%presion sonora prelocalizacion
P2c(1:Ny2,1:Nz2) = 0; %presion sonora compleja
P2(1:Ny2,1:Nz2) = 0;  %presion sonora en modulo del valor complejo amplitud

for n1 = 1:N
        pn(:,:) =  A(n1)*exp(j*(w*t - k*rn2(n1,:,:) ) )./(rn2(n1,:,:));
        P2c = P2c(:,:) + pn;
end;
P2 = abs(P2c);

%nivel de presion sonora
Lp2 = 20*log10(P2/P0/sqrt(2));

%% graficos plano (10,Y,Z)

figure(7)
surf(y2,z2,P2,'FaceColor','interp',...
                'EdgeColor','none',...
                'FaceLighting','phong');
title('presion sonora plano yz x = 10');
xlabel('y (m)');
ylabel('z (m)');
zlabel('p (N/m^2)')
colormap jet
colorbar
grid on;
box on;

figure(8)
surf(y2,z2,Lp2,'FaceColor','interp',...
                'EdgeColor','none',...
                'FaceLighting','phong');
title('nivel de presion sonora plano yz x = 10');
xlabel('y (m)');
ylabel('z (m)');
zlabel('Lp (dB)')
colormap jet
colorbar
grid on;
box on;
  
%% plano de recepcion (X,10,Z)        

%dimensiones
y3 = 10;

xmin =   0;
xmax =  20;
incx = 0.1;

zmin = -10;
zmax =  10;
incz = 0.1;

%grilla plano xz
[x3,z3] = meshgrid(xmin:incx:xmax,zmin:incz:zmax);

%longitud de la grilla
Nx3 = length(x3);       %longitud de la grilla en x3
Nz3 = length(z3);       %longitud de la grilla en z3

%prelocalizacion de las distancias como un arreglo 3D
rn3(1:N,1:Nx3,1:Nz3) = 0; 

%distancias
for n1 = 1:N
    rn3(n1,:,:) = sqrt( (x3-x0(n1)).^2 + (y3-y0(n1)).^2 + (z3-z0(n1)).^2 );
end;

%presion sonora prelocalizacion
P3c(1:Nx3,1:Nz3) = 0; %presion sonora compleja
P3(1:Nx3,1:Nz3) = 0;  %presion sonora en modulo del valor complejo amplitud

for n1 = 1:N
        pn(:,:) =  A(n1)*exp(j*(w*t - k*rn3(n1,:,:) ) )./(rn3(n1,:,:));
        P3c = P3c(:,:) + pn;
end;
P3 = abs(P3c);

%nivel de presion sonora
Lp3 = 20*log10(P3/P0/sqrt(2));

%% graficos plano (X,10,Z)

figure(9)
surf(x3,z3,P3,'FaceColor','interp',...
                'EdgeColor','none',...
                'FaceLighting','phong');
title('presion sonora plano xz y = 10');
xlabel('x (m)');
ylabel('z (m)');
zlabel('p (N/m^2)')
colormap jet
colorbar
grid on;
box on;

figure(10)
surf(x3,z3,Lp3,'FaceColor','interp',...
                'EdgeColor','none',...
                'FaceLighting','phong');
title('nivel de presion sonora plano xz y = 10');
xlabel('x (m)');
ylabel('z (m)');
zlabel('Lp (dB)')
colormap jet
colorbar
grid on;
box on;