/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class TransLineElm
extends CircuitElm {
    double delay;
    double imped;
    double[] voltageL;
    double[] voltageR;
    int lenSteps;
    int ptr;
    int width;
    Point[] posts;
    Point[] inner;
    int voltSource1;
    int voltSource2;
    double current1;
    double current2;
    double curCount1;
    double curCount2;

    public TransLineElm(int n, int n2) {
        super(n, n2);
        this.delay = 1000.0 * TransLineElm.sim.timeStep;
        this.imped = 75.0;
        this.noDiagonal = true;
        this.reset();
    }

    public TransLineElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.delay = new Double(stringTokenizer.nextToken());
        this.imped = new Double(stringTokenizer.nextToken());
        this.width = new Integer(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        this.noDiagonal = true;
        this.reset();
    }

    int getDumpType() {
        return 171;
    }

    int getPostCount() {
        return 4;
    }

    int getInternalNodeCount() {
        return 2;
    }

    String dump() {
        return super.dump() + " " + this.delay + " " + this.imped + " " + this.width + " " + 0.0;
    }

    void drag(int n, int n2) {
        int n3;
        n = sim.snapGrid(n);
        int n4 = TransLineElm.max(TransLineElm.sim.gridSize, TransLineElm.abs((n2 = sim.snapGrid(n2)) - this.y));
        if (n4 > (n3 = TransLineElm.max(TransLineElm.sim.gridSize, TransLineElm.abs(n - this.x)))) {
            n = this.x;
            this.width = n3;
        } else {
            n2 = this.y;
            this.width = n4;
        }
        this.x2 = n;
        this.y2 = n2;
        this.setPoints();
    }

    void reset() {
        if (TransLineElm.sim.timeStep == 0.0) {
            return;
        }
        this.lenSteps = (int)(this.delay / TransLineElm.sim.timeStep);
        System.out.println(this.lenSteps + " steps");
        if (this.lenSteps > 100000) {
            this.voltageR = null;
            this.voltageL = null;
        } else {
            this.voltageL = new double[this.lenSteps];
            this.voltageR = new double[this.lenSteps];
        }
        this.ptr = 0;
        super.reset();
    }

    void setPoints() {
        super.setPoints();
        int n = this.dy == 0 ? TransLineElm.sign(this.dx) : -TransLineElm.sign(this.dy);
        Point point = this.interpPoint(this.point1, this.point2, 0.0, (double)(-this.width * n));
        Point point2 = this.interpPoint(this.point1, this.point2, 1.0, (double)(-this.width * n));
        int n2 = TransLineElm.sim.gridSize / 2;
        Point point3 = this.interpPoint(this.point1, this.point2, 0.0, (double)(-(this.width / 2 - n2) * n));
        Point point4 = this.interpPoint(this.point1, this.point2, 1.0, (double)(-(this.width / 2 - n2) * n));
        Point point5 = this.interpPoint(this.point1, this.point2, 0.0, (double)(-(this.width / 2 + n2) * n));
        Point point6 = this.interpPoint(this.point1, this.point2, 1.0, (double)(-(this.width / 2 + n2) * n));
        this.posts = new Point[]{point, point2, this.point1, this.point2};
        this.inner = new Point[]{point5, point6, point3, point4};
    }

    void draw(Graphics graphics) {
        int n;
        this.setBbox(this.posts[0], this.posts[3], 0.0);
        int n2 = (int)(this.dn / 2.0);
        int n3 = this.ptr - 1 + this.lenSteps;
        double d = 1.0 / (double)n2;
        graphics.setColor(Color.darkGray);
        graphics.fillRect(this.inner[2].x, this.inner[2].y, this.inner[1].x - this.inner[2].x + 2, this.inner[1].y - this.inner[2].y + 2);
        for (n = 0; n != 4; ++n) {
            this.setVoltageColor(graphics, this.volts[n]);
            TransLineElm.drawThickLine(graphics, this.posts[n], this.inner[n]);
        }
        if (this.voltageL != null) {
            for (n = 0; n != n2; ++n) {
                int n4 = (n3 - this.lenSteps * n / n2) % this.lenSteps;
                int n5 = (n3 - this.lenSteps * (n2 - 1 - n) / n2) % this.lenSteps;
                double d2 = (this.voltageL[n4] + this.voltageR[n5]) / 2.0;
                this.setVoltageColor(graphics, d2);
                this.interpPoint(this.inner[0], this.inner[1], ps1, (double)n * d);
                this.interpPoint(this.inner[2], this.inner[3], ps2, (double)n * d);
                graphics.drawLine(TransLineElm.ps1.x, TransLineElm.ps1.y, TransLineElm.ps2.x, TransLineElm.ps2.y);
                this.interpPoint(this.inner[2], this.inner[3], ps1, (double)(n + 1) * d);
                TransLineElm.drawThickLine(graphics, ps1, ps2);
            }
        }
        this.setVoltageColor(graphics, this.volts[0]);
        TransLineElm.drawThickLine(graphics, this.inner[0], this.inner[1]);
        this.drawPosts(graphics);
        this.curCount1 = this.updateDotCount(-this.current1, this.curCount1);
        this.curCount2 = this.updateDotCount(this.current2, this.curCount2);
        if (TransLineElm.sim.dragElm != this) {
            this.drawDots(graphics, this.posts[0], this.inner[0], this.curCount1);
            this.drawDots(graphics, this.posts[2], this.inner[2], -this.curCount1);
            this.drawDots(graphics, this.posts[1], this.inner[1], -this.curCount2);
            this.drawDots(graphics, this.posts[3], this.inner[3], this.curCount2);
        }
    }

    void setVoltageSource(int n, int n2) {
        if (n == 0) {
            this.voltSource1 = n2;
        } else {
            this.voltSource2 = n2;
        }
    }

    void setCurrent(int n, double d) {
        if (n == this.voltSource1) {
            this.current1 = d;
        } else {
            this.current2 = d;
        }
    }

    void stamp() {
        sim.stampVoltageSource(this.nodes[4], this.nodes[0], this.voltSource1);
        sim.stampVoltageSource(this.nodes[5], this.nodes[1], this.voltSource2);
        sim.stampResistor(this.nodes[2], this.nodes[4], this.imped);
        sim.stampResistor(this.nodes[3], this.nodes[5], this.imped);
    }

    void startIteration() {
        if (this.voltageL == null) {
            sim.stop("Transmission line delay too large!", this);
            return;
        }
        this.voltageL[this.ptr] = this.volts[2] - this.volts[0] + this.volts[2] - this.volts[4];
        this.voltageR[this.ptr] = this.volts[3] - this.volts[1] + this.volts[3] - this.volts[5];
        this.ptr = (this.ptr + 1) % this.lenSteps;
    }

    void doStep() {
        if (this.voltageL == null) {
            sim.stop("Transmission line delay too large!", this);
            return;
        }
        sim.updateVoltageSource(this.nodes[4], this.nodes[0], this.voltSource1, -this.voltageR[this.ptr]);
        sim.updateVoltageSource(this.nodes[5], this.nodes[1], this.voltSource2, -this.voltageL[this.ptr]);
        if (Math.abs(this.volts[0]) > 1.0E-5 || Math.abs(this.volts[1]) > 1.0E-5) {
            sim.stop("Need to ground transmission line!", this);
            return;
        }
    }

    Point getPost(int n) {
        return this.posts[n];
    }

    int getVoltageSourceCount() {
        return 2;
    }

    boolean hasGroundConnection(int n) {
        return false;
    }

    boolean getConnection(int n, int n2) {
        return false;
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "transmission line";
        stringArray[1] = TransLineElm.getUnitText(this.imped, CirSim.ohmString);
        stringArray[2] = "length = " + TransLineElm.getUnitText(2.9979E8 * this.delay, "m");
        stringArray[3] = "delay = " + TransLineElm.getUnitText(this.delay, "s");
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Delay (s)", this.delay, 0.0, 0.0);
        }
        if (n == 1) {
            return new EditInfo("Impedance (ohms)", this.imped, 0.0, 0.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.delay = editInfo.value;
            this.reset();
        }
        if (n == 1) {
            this.imped = editInfo.value;
            this.reset();
        }
    }
}

