/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.StringTokenizer;

class PotElm
extends CircuitElm
implements AdjustmentListener {
    double position;
    double maxResistance;
    double resistance1;
    double resistance2;
    double current1;
    double current2;
    double current3;
    double curcount1;
    double curcount2;
    double curcount3;
    Scrollbar slider;
    Label label;
    String sliderText;
    Point post3;
    Point corner2;
    Point arrowPoint;
    Point midpoint;
    Point arrow1;
    Point arrow2;
    Point ps3;
    Point ps4;
    int bodyLen;

    public PotElm(int n, int n2) {
        super(n, n2);
        this.setup();
        this.maxResistance = 1000.0;
        this.position = 0.5;
        this.sliderText = "Resistance";
        this.createSlider();
    }

    public PotElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.maxResistance = new Double(stringTokenizer.nextToken());
        this.position = new Double(stringTokenizer.nextToken());
        this.sliderText = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            this.sliderText = this.sliderText + ' ' + stringTokenizer.nextToken();
        }
        this.createSlider();
    }

    void setup() {
    }

    int getPostCount() {
        return 3;
    }

    int getDumpType() {
        return 174;
    }

    Point getPost(int n) {
        return n == 0 ? this.point1 : (n == 1 ? this.point2 : this.post3);
    }

    String dump() {
        return super.dump() + " " + this.maxResistance + " " + this.position + " " + this.sliderText;
    }

    void createSlider() {
        this.label = new Label(this.sliderText, 1);
        CirSim.main.add(this.label);
        int n = (int)(this.position * 100.0);
        this.slider = new Scrollbar(0, n, 1, 0, 101);
        CirSim.main.add(this.slider);
        CirSim.main.validate();
        this.slider.addAdjustmentListener(this);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        PotElm.sim.analyzeFlag = true;
        this.setPoints();
    }

    void delete() {
        CirSim.main.remove(this.label);
        CirSim.main.remove(this.slider);
    }

    void setPoints() {
        super.setPoints();
        int n = 0;
        if (PotElm.abs(this.dx) > PotElm.abs(this.dy)) {
            this.dx = sim.snapGrid(this.dx / 2) * 2;
            this.point2.x = this.x2 = this.point1.x + this.dx;
            n = this.dx < 0 ? this.dy : -this.dy;
            this.point2.y = this.point1.y;
        } else {
            this.dy = sim.snapGrid(this.dy / 2) * 2;
            this.point2.y = this.y2 = this.point1.y + this.dy;
            n = this.dy > 0 ? this.dx : -this.dx;
            this.point2.x = this.point1.x;
        }
        if (n == 0) {
            n = PotElm.sim.gridSize;
        }
        this.dn = PotElm.distance(this.point1, this.point2);
        int n2 = 32;
        this.calcLeads(n2);
        this.position = (double)this.slider.getValue() * 0.0099 + 0.005;
        int n3 = (int)((this.position - 0.5) * (double)n2);
        this.post3 = this.interpPoint(this.point1, this.point2, 0.5, (double)n);
        this.corner2 = this.interpPoint(this.point1, this.point2, (double)n3 / this.dn + 0.5, (double)n);
        this.arrowPoint = this.interpPoint(this.point1, this.point2, (double)n3 / this.dn + 0.5, (double)(8 * PotElm.sign(n)));
        this.midpoint = this.interpPoint(this.point1, this.point2, (double)n3 / this.dn + 0.5);
        this.arrow1 = new Point();
        this.arrow2 = new Point();
        double d = PotElm.abs(n) - 8;
        this.interpPoint2(this.corner2, this.arrowPoint, this.arrow1, this.arrow2, (d - 8.0) / d, 8.0);
        this.ps3 = new Point();
        this.ps4 = new Point();
    }

    void draw(Graphics graphics) {
        int n = 16;
        int n2 = 0;
        int n3 = PotElm.sim.euroResistorCheckItem.getState() ? 6 : 8;
        double d = this.volts[0];
        double d2 = this.volts[1];
        double d3 = this.volts[2];
        this.setBbox(this.point1, this.point2, n3);
        this.draw2Leads(graphics);
        this.setPowerColor(graphics, true);
        double d4 = 1.0 / (double)n;
        int n4 = (int)((double)n * this.position);
        if (!PotElm.sim.euroResistorCheckItem.getState()) {
            for (int i = 0; i != n; ++i) {
                int n5 = 0;
                switch (i & 3) {
                    case 0: {
                        n5 = 1;
                        break;
                    }
                    case 2: {
                        n5 = -1;
                        break;
                    }
                    default: {
                        n5 = 0;
                    }
                }
                double d5 = d + (d3 - d) * (double)i / (double)n4;
                if (i >= n4) {
                    d5 = d3 + (d2 - d3) * (double)(i - n4) / (double)(n - n4);
                }
                this.setVoltageColor(graphics, d5);
                this.interpPoint(this.lead1, this.lead2, ps1, (double)i * d4, n3 * n2);
                this.interpPoint(this.lead1, this.lead2, ps2, (double)(i + 1) * d4, n3 * n5);
                PotElm.drawThickLine(graphics, ps1, ps2);
                n2 = n5;
            }
        } else {
            this.setVoltageColor(graphics, d);
            this.interpPoint2(this.lead1, this.lead2, ps1, ps2, 0.0, n3);
            PotElm.drawThickLine(graphics, ps1, ps2);
            for (int i = 0; i != n; ++i) {
                double d6 = d + (d3 - d) * (double)i / (double)n4;
                if (i >= n4) {
                    d6 = d3 + (d2 - d3) * (double)(i - n4) / (double)(n - n4);
                }
                this.setVoltageColor(graphics, d6);
                this.interpPoint2(this.lead1, this.lead2, ps1, ps2, (double)i * d4, n3);
                this.interpPoint2(this.lead1, this.lead2, this.ps3, this.ps4, (double)(i + 1) * d4, n3);
                PotElm.drawThickLine(graphics, ps1, this.ps3);
                PotElm.drawThickLine(graphics, ps2, this.ps4);
            }
            this.interpPoint2(this.lead1, this.lead2, ps1, ps2, 1.0, n3);
            PotElm.drawThickLine(graphics, ps1, ps2);
        }
        this.setVoltageColor(graphics, d3);
        PotElm.drawThickLine(graphics, this.post3, this.corner2);
        PotElm.drawThickLine(graphics, this.corner2, this.arrowPoint);
        PotElm.drawThickLine(graphics, this.arrow1, this.arrowPoint);
        PotElm.drawThickLine(graphics, this.arrow2, this.arrowPoint);
        this.curcount1 = this.updateDotCount(this.current1, this.curcount1);
        this.curcount2 = this.updateDotCount(this.current2, this.curcount2);
        this.curcount3 = this.updateDotCount(this.current3, this.curcount3);
        if (PotElm.sim.dragElm != this) {
            this.drawDots(graphics, this.point1, this.midpoint, this.curcount1);
            this.drawDots(graphics, this.point2, this.midpoint, this.curcount2);
            this.drawDots(graphics, this.post3, this.corner2, this.curcount3);
            this.drawDots(graphics, this.corner2, this.midpoint, this.curcount3 + PotElm.distance(this.post3, this.corner2));
        }
        this.drawPosts(graphics);
    }

    void calculateCurrent() {
        this.current1 = (this.volts[0] - this.volts[2]) / this.resistance1;
        this.current2 = (this.volts[1] - this.volts[2]) / this.resistance2;
        this.current3 = -this.current1 - this.current2;
    }

    void stamp() {
        this.resistance1 = this.maxResistance * this.position;
        this.resistance2 = this.maxResistance * (1.0 - this.position);
        sim.stampResistor(this.nodes[0], this.nodes[2], this.resistance1);
        sim.stampResistor(this.nodes[2], this.nodes[1], this.resistance2);
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "potentiometer";
        stringArray[1] = "Vd = " + PotElm.getVoltageDText(this.getVoltageDiff());
        stringArray[2] = "R1 = " + PotElm.getUnitText(this.resistance1, CirSim.ohmString);
        stringArray[3] = "R2 = " + PotElm.getUnitText(this.resistance2, CirSim.ohmString);
        stringArray[4] = "I1 = " + PotElm.getCurrentDText(this.current1);
        stringArray[5] = "I2 = " + PotElm.getCurrentDText(this.current2);
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Resistance (ohms)", this.maxResistance, 0.0, 0.0);
        }
        if (n == 1) {
            EditInfo editInfo = new EditInfo("Slider Text", 0.0, -1.0, -1.0);
            editInfo.text = this.sliderText;
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.maxResistance = editInfo.value;
        }
        if (n == 1) {
            this.sliderText = editInfo.textf.getText();
            this.label.setText(this.sliderText);
        }
    }
}

