# Canopy Carbon Exchange Experiment - kahikatea & totara - Landcare Research
# Horacio E. Bown, PhD
# November 6, 2018

# 1. preliminar steps /clean everything
ls()
rm(list=ls())
ls()


# 2. Set working directory 

dir()
getwd()
setwd("~/Desktop/GESTREN/STATII/Ejercicio1_stat_2")
dir()


# 3 Libraries

library(tidyverse)
library(tree)
library(car)
library(doBy)
library(Hmisc)
library(nlme)
library(nlmrt)

#4. CiCa from delta 13 vs CiCa from gas exchange

vert<-read.table("vertical.txt", header=T)
names(vert)
nfol<-read.table("foliageN.txt", header=T)
names(nfol)
pera<-vert %>%  inner_join(nfol, by=c("Shoot"))
pera$Species<-pera$Species.x

setEPS()
postscript("Fig4.eps", width=8, height=4)

par(mfrow=c(1,2))
par(mar=c(4,5,1,1)+.1)

eti1<-expression(italic(C)[i]~":"~italic(C)[a]~" from "~delta^13~"C")
eti2 <- expression(italic(C)[i]~":"~italic(C)[a]~" from gas exchange")
plot(CiCaD13C~CiCa2,las=1, xlim=c(0,1), ylim=c(0,1), pch=19, data=subset(pera,Species=="Kahikatea"), ylab=eti1, xlab=eti2)
points(CiCaD13C~CiCa2,pch=21,data=subset(pera,Species=="Totara"))
text(0.95,0.95, "a", cex=2)
text(0.75,0,"same day")

eti1<-expression(italic(C)[i]~":"~italic(C)[a]~" from "~delta^13~"C")
eti2 <- expression(italic(C)[i]~":"~italic(C)[a]~" from gas exchange")
plot(CiCaD13C~CiCa1,las=1, xlim=c(0,1), ylim=c(0,1), pch=19, data=subset(pera,Species=="Kahikatea"), ylab=eti1, xlab=eti2)
points(CiCaD13C~CiCa1,pch=21,data=subset(pera,Species=="Totara"))
text(0.95,0.95, "b", cex=2)
text(0.75,0,"two days before")

mod1<-lm(CiCaD13C~CiCa1, data=pera)
x<-seq(0.05,0.95,0.01)
points(x, predict(mod1, list(CiCa1=x)), type="l", lwd=2)
#a1<-expression(italic(y)~"= 0.402 + 0.276"~italic(x)~", "~italic(r)^2~"=0.49, "~italic(P)~"<0.001")
#text(0.4,0.95, a1, cex=0.8)

dev.off()



# 5. Vertical profile / Figure 3

names(pera)

setEPS()
postscript("Fig3.eps", width=6, height=5)

par(mfrow=c(2,4))
#par(mar=c(4,5,1,1)+.1)
par(mar=c(5,0,0.5,0.5))
par(oma=c(0,5,0,0))

eti1<-expression("Tree height (m)")
eti2<-expression(italic(C)[i]~":"~italic(C)[a]~" ("~delta^13~"C)")
plot(height/100~CiCaD13C,las=1, xlim=c(0,1), ylim=c(0,6), pch=19, data=subset(pera,Species=="Kahikatea"), ylab=eti1, xlab=eti2)
points(height/100~CiCaD13C,pch=21,data=subset(pera,Species=="Totara"))
text(0.95,5.8, "a", cex=2)
points(rep(0.5,100),seq(0.5,5.5,length=100), type="l", lty=1, lwd=1)
points(rep(0.59,100),seq(0.5,5.5,length=100), type="l", lty=1, lwd=1)


eti1<-expression("Tree height (m)")
eti2 <- expression(italic(C)[i]~":"~italic(C)[a]~" (gas)")
plot(height/100~CiCa1,las=1, xlim=c(0,1), ylim=c(0,6), pch=19, data=subset(pera,Species=="Kahikatea"), yaxt='n',  xlab=eti2)
points(height/100~CiCa1,pch=21,data=subset(pera,Species=="Totara"))
text(0.95,5.8, "b", cex=2)
points(rep(0.40,100),seq(0.5,5.5,length=100), type="l", lty=1, lwd=1)
points(rep(0.62,100),seq(0.5,5.5,length=100), type="l", lty=1, lwd=1)




eti1<-expression("Tree height (m)")
eti2 <- expression(italic(g)[s]~" (mmol m"^-2~" s"^-1~")")
pera$gsmmol<-pera$gs1*10^3
plot(height/100~gsmmol,las=1, xlim=c(0,150), ylim=c(0,6), pch=19, data=subset(pera,Species=="Kahikatea"), yaxt='n',  xlab=eti2)
points(height/100~gsmmol,pch=21,data=subset(pera,Species=="Totara"))
text(145,5.8, "c", cex=2)
points(rep(22,100),seq(0.5,5.5,length=100), type="l", lty=1, lwd=1)
points(rep(59,100),seq(0.5,5.5,length=100), type="l", lty=1, lwd=1)


eti1<-expression("Tree height (m)")
eti2 <- expression(italic(A)~" ("~mu~"mol m"^-2~" s"^-1~")")
plot(height/100~A1,las=1, xlim=c(0,8), ylim=c(0,6), pch=19, data=subset(pera,Species=="Kahikatea"), yaxt='n',  xlab=eti2)
points(height/100~A1,pch=21,data=subset(pera,Species=="Totara"))
text(7.5,5.8, "d", cex=2)

mod1<-lm(A1~height, data=pera)
summary(mod1)
x<-seq(50,550,1)
points(predict(mod1, list(height=x)), x/100, type="l", lwd=1)

mtext("Tree height (m)", side=2, line=3, cex=0.8, outer=TRUE) 


eti1<-expression("Tree height (m)")
eti2 <- expression(italic(T)~" ("~degree~"C)")
plot(height/100~T1,las=1, xlim=c(0,40), ylim=c(0,6), pch=19, data=subset(pera,Species=="Kahikatea"),ylab=eti1, xlab=eti2)
points(height/100~T1,pch=21,data=subset(pera,Species=="Totara"))
text(35,5.8, "e", cex=2)

mod1<-lm(T1~height, data=subset(pera,Species=="Kahikatea"))
summary(mod1)
x<-seq(50,550,1)
points(predict(mod1, list(height=x)), x/100, type="l", lwd=1)

mod1<-lm(T1~height, data=subset(pera,Species=="Totara"))
summary(mod1)
x<-seq(50,550,1)
points(predict(mod1, list(height=x)), x/100, type="l", lwd=1)

eti1<-expression("Tree height (m)")
eti2 <- expression(italic(Q)~" ("~mu~"mol m"^-2~" s"^-1~")")
plot(height/100~Q1,las=1, xlim=c(0,3000), ylim=c(0,6), pch=19, data=subset(pera,Species=="Kahikatea"), yaxt='n',  xlab=eti2)
points(height/100~Q1,pch=21,data=subset(pera,Species=="Totara"))
text(2500,5.8, "f", cex=2)

mod1<-lm(Q1~height, data=pera)
summary(mod1)
x<-seq(50,550,1)
points(predict(mod1, list(height=x)), x/100, type="l", lwd=1)


eti1<-expression("Tree height (m)")
eti2 <- expression(italic(S)~" ( m"^2~" kg"^-1~")")
pera$S<-pera$SLA/10
plot(height/100~S,las=1, xlim=c(0,8), ylim=c(0,6), pch=19, data=subset(pera,Species=="Kahikatea"), yaxt='n',  xlab=eti2)
points(height/100~S,pch=21,data=subset(pera,Species=="Totara"))
text(7.8,5.8, "g", cex=2)

mod1<-lm(SLA~height, data=pera)
summary(mod1)
x<-seq(50,550,1)
points(predict(mod1, list(height=x))/10, x/100, type="l", lwd=1)




eti1<-expression("Tree height (m)")
eti2 <- expression(italic(N)[a]~" ( mmol m"^-2~")")
pera$S<-pera$SLA/10
plot(height/100~Nmmol,las=1, xlim=c(0,200), ylim=c(0,6), pch=19, data=subset(pera,Species=="Kahikatea"), yaxt='n', xlab=eti2)
points(height/100~Nmmol,pch=21,data=subset(pera,Species=="Totara"))
text(180,5.9, "h", cex=2)


mod1<-lm(Nmmol~height, data=subset(pera,Species=="Kahikatea"))
summary(mod1)
x<-seq(50,550,1)
points(predict(mod1, list(height=x)), x/100, type="l", lwd=1)

mod1<-lm(Nmmol~height, data=subset(pera,Species=="Totara"))
summary(mod1)
x<-seq(50,550,1)
points(predict(mod1, list(height=x)), x/100, type="l", lwd=1)


dev.off()


# 6 ancovas vertical profile

ancova1<-aov(CiCaD13C~ height+ Species+height:Species, data=pera)
summary(ancova1)
shapiro.test(ancova1$res)


mod1<-lm(CiCaD13C~ height, data=subset(pera, Species=="Kahikatea"))
anova(mod1)

mod1<-lm(CiCaD13C~ height, data=subset(pera, Species=="Totara"))
anova(mod1)




# 7. Open daily Ci:Ca and deltas 

iso<-read.table("dayIsoClim.txt", sep=",", header=TRUE)
isot<-iso #%>% filter(day<29)
names(isot)

isot %>%
  ggplot()+
  geom_point(aes(x=VWC, y=CiCaD13, group=Species, color=Species))


isot %>%
  ggplot()+
  geom_point(aes(x=d13C, y=d18O, group=Species, color=Species))



isot %>%
  ggplot()+
  geom_point(aes(x=CiCaGas, y=cica8, group=Species, color=Species))




# 8. Correlation matrix

library(corrplot)


test<-cbind(isot$CiCaD13, isot$Rain, isot$Tair, isot$VPD, isot$PAR, isot$Wspd, isot$Wdir, isot$VWC)
M<-cor(test, use = "complete.obs")

corrplot(M, method="circle", type="upper")
corrplot(M, method="pie", type="upper")
corrplot(M, method="color", type="upper")
corrplot(M, method="number", type="upper")
corrplot(M, type="upper")

library(Hmisc)
rcorr(test, type="pearson") # type can be pearson or spearman



# 9. Figure 2. Environmental+ Atree+WUE+ETREED+delta13C

pera<-read.csv("Atree.csv")

pera$day1<-pera$day+0.5



setEPS()
postscript("Fig2.eps", width=10, height=7)

par(mfrow=c(7,1))
par(mar=c(0,7,0,0.5))
par(oma=c(5,0,0.5,5))

eti2<-expression(atop(italic(Q), "(MJ m"^2~"d"^-1~")"))
plot(PAR~day1,las=1, xlim=c(-1,26), ylim=c(0,40), data=subset(pera,Species=="Kahikatea"), type="h", lend=3, lwd=26, col="grey", xaxt='n',  ylab=eti2)
text(26.5,35, "a", cex=1.5)

eti2<-expression(atop(italic(D),"(kPa)"))
plot(dayVPD~day1,las=1, xlim=c(-1,26), ylim=c(0,1.9),  type="h", lend=3, lwd=26, col="grey", data=subset(pera,Species=="Kahikatea"), xaxt='n',  ylab=eti2)
text(26.5,1.8, "b", cex=1.5)

eti2<-expression(atop("Rain","(mm)"))
#R<-subset(pera, Species=="Kahikatea")$Rain
#r.bar<-barplot(R, space=0)
#lines(x=r.bar, y=)

plot(Rain~day1,las=1, xlim=c(-1,26), ylim=c(1,28), type="h", lend=3, lwd=26, col="grey", data=subset(pera,Species=="Kahikatea"), xaxt='n',  ylab=eti2)
text(26.5,25, "c", cex=1.5)
par(new=TRUE)
plot(SWC~day1, data=subset(pera,Species=="Kahikatea"), col="blue", type="s", ylim=c(0,0.4), xaxt="n", yaxt="n", ylab="", xlab="")
points(SWC~day1, data=subset(pera,Species=="Totara"), col="red", type="s")
#plot(SWC~day, data=subset(pera,Species=="Kahikatea"), col="blue", type="p", xaxt="n", yaxt="n", ylab="", xlab="")
#points(SWC~day, data=subset(pera,Species=="Totara"), col="red", type="p")
axis(4)
mtext(expression(theta~"(m"^3~"m"^-3~")"), cex=0.8, side=4, line=3)




eti2 <- expression(atop(italic(E), "(mm day"^-1~")"))
plot(EtreeD~day,las=1,xlim=c(-1,26), ylim=c(0,5.7),  data=subset(pera,Species=="Kahikatea"), col="blue", type="s",xaxt='n',  ylab=eti2)
points(EtreeD~day,pch=21,data=subset(pera,Species=="Totara"),col="red", type="s")
text(26.5,5, "d", cex=1.5)

eti2<-expression(atop(omega, "(g C kg"^-1~" H"[2]~"O)"))
plot(WUE11~day,las=1, xlim=c(-1,26), ylim=c(0,5.7),  data=subset(pera,Species=="Kahikatea"),  col="blue", type="s",xaxt='n',  ylab=eti2)
points(WUE11~day,pch=21,data=subset(pera,Species=="Totara"),col="red", type="s")
text(26.5,5, "e", cex=1.5)

legend(20, 5, c(expression(italic(D.dacrydioides)), expression(italic(P.totara))), cex=1, col = c("blue", "red"), lty = c(1, 1), bty="n")


eti2<-expression(atop(italic(A),"(g C m"^-2~" day"^-1~")"))
plot(Atree~day,las=1, xlim=c(-1,26), ylim=c(0,6.5),  data=subset(pera,Species=="Kahikatea"),  col="blue", type="s",xaxt='n',  ylab=eti2)
points(Atree~day,pch=21,data=subset(pera,Species=="Totara"),col="red", type="s")
text(26.5,5, "f", cex=1.5)

eti2<-expression(delta^13~"C")
plot(delta13C~day,las=1, xlim=c(-1,26), ylim=c(-28,-21.5), pch=19, data=subset(pera,Species=="Kahikatea"),   col="blue", type="s", xaxt="n", ylab=eti2)
points(delta13C~day,pch=21,data=subset(pera,Species=="Totara"),col="red", type="s")
text(26.5,-23, "g", cex=1.5)

dias<-c("23-Nov","24-Nov","25-Nov","26-Nov", "27-Nov", "28-Nov", "29-Nov", "30-Nov", "1-Dec", "2-Dec", "3-Dec", "4-Dec", "5-Dec", "6-Dec", "7-Dec", "8-Dec", "9-Dec", "10-Dec", "11-Dec", "12-Dec", "13-Dec", "14-dec", "15-Dec", "16-Dec", "17-Dec", "18-Dec", "19-Dec", "20-Dec") 

axis(1, at=-1:26, labels=dias, srt=90)


mtext("days", side=1, line=3, cex=0.8, outer=TRUE) 

dev.off()

